/*
 * Decompiled with CFR 0.152.
 */
package de.arstwo.twotil;

import de.arstwo.twotil.functional.ThrowingFunction;
import de.arstwo.twotil.functional.ThrowingSupplier;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.sql.Date;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class Util {
    public static <T> T first(Predicate<T> validator, T ... values) {
        for (T t : values) {
            if (!validator.test(t)) continue;
            return t;
        }
        return null;
    }

    public static <T, E extends Throwable> T firstOrThrow(Predicate<T> validator, Supplier<E> throwable, T ... values) throws E {
        for (T t : values) {
            if (!validator.test(t)) continue;
            return t;
        }
        throw (Throwable)throwable.get();
    }

    public static <T> T firstNonNull(T ... values) {
        return (T)Util.first(Objects::nonNull, values);
    }

    public static <T> T firstNonEmpty(T ... values) {
        return (T)Util.first(Util::isNotEmpty, values);
    }

    public static <T> T firstNonBlank(T ... values) {
        return (T)Util.first(Util::isNotBlank, values);
    }

    public static <T> boolean noneMatch(Predicate<T> validator, T ... values) {
        for (T t : values) {
            if (!validator.test(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean allMatch(Predicate<T> validator, T ... values) {
        return Util.noneMatch(validator.negate(), values);
    }

    public static <T> boolean anyMatch(Predicate<T> validator, T ... values) {
        for (T t : values) {
            if (!validator.test(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean anyFail(Predicate<T> validator, T ... values) {
        return Util.anyMatch(validator.negate(), values);
    }

    public static <T> boolean isEmpty(T t) {
        if (t == null) {
            return true;
        }
        if (t instanceof String) {
            return ((String)t).isEmpty();
        }
        if (t instanceof Collection) {
            return ((Collection)t).isEmpty();
        }
        if (t.getClass().isArray()) {
            return Array.getLength(t) == 0;
        }
        return false;
    }

    public static <T> boolean isNotEmpty(T t) {
        return !Util.isEmpty(t);
    }

    public static <T> boolean isBlank(T t) {
        if (t == null) {
            return true;
        }
        if (t instanceof String) {
            String s = (String)t;
            return s.isEmpty() || s.chars().allMatch(Character::isWhitespace);
        }
        if (t instanceof Collection) {
            Collection c = (Collection)t;
            return c.isEmpty() || c.stream().allMatch(Util::isBlank);
        }
        if (t.getClass().isArray()) {
            if (t instanceof Object[]) {
                Object[] a = (Object[])t;
                return a.length == 0 || Arrays.stream(a).allMatch(Util::isBlank);
            }
            return Array.getLength(t) == 0;
        }
        return false;
    }

    public static <T> boolean isNotBlank(T t) {
        return !Util.isBlank(t);
    }

    public static <T> Predicate<T> AND(Predicate<T> ... predicates) {
        return t -> {
            for (Predicate p : predicates) {
                if (p.test(t)) continue;
                return false;
            }
            return true;
        };
    }

    public static <T> Predicate<T> OR(Predicate<T> ... predicates) {
        return t -> {
            for (Predicate p : predicates) {
                if (!p.test(t)) continue;
                return true;
            }
            return false;
        };
    }

    public static <T> T getOrDefault(T optionalValue, Supplier<T> generator) {
        return optionalValue == null ? generator.get() : optionalValue;
    }

    public static <T, E extends Throwable> T getOrDefaultExceptional(T optionalValue, ThrowingSupplier<T, E> generator) throws E {
        return optionalValue == null ? generator.get() : optionalValue;
    }

    public static <T, R> R mapIfPresent(T optionalValue, Function<T, R> mapper) {
        return optionalValue == null ? null : (R)mapper.apply(optionalValue);
    }

    public static <T, R, E extends Throwable> R mapIfPresentExceptional(T optionalValue, ThrowingFunction<T, R, E> mapper) throws E {
        return optionalValue == null ? null : (R)mapper.apply(optionalValue);
    }

    public static String joinNonBlank(String delimiter, String ... parts) {
        return Arrays.stream(parts).filter(Util::isNotBlank).collect(Collectors.joining(delimiter));
    }

    public static String getStackTrace() {
        return "\tat " + Arrays.stream(Thread.currentThread().getStackTrace()).skip(2L).map(StackTraceElement::toString).collect(Collectors.joining("\n\tat "));
    }

    public static <T, R> List<R> mapList(List<T> list, Function<T, R> mapper) {
        return list.stream().map(mapper).collect(Collectors.toList());
    }

    public static java.util.Date toDate(LocalDate ld) {
        return java.util.Date.from(ld.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDate toLocalDate(java.util.Date d) {
        if (d instanceof Date) {
            return ((Date)d).toLocalDate();
        }
        return d.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static java.util.Date startOfMonth(java.util.Date inputDate) {
        return java.util.Date.from(Util.toLocalDate(inputDate).withDayOfMonth(1).atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static <V, K> Map<V, List<K>> inverseMap(Map<K, V> map) {
        return map.entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.mapping(Map.Entry::getKey, Collectors.toList())));
    }

    public static <K, V> Map<K, List<V>> groupList(List<V> list, Function<V, K> keyMapper) {
        return list.stream().collect(Collectors.groupingBy(keyMapper, Collectors.toList()));
    }

    public static <K, V> Map<K, NavigableSet<V>> groupListSorted(List<V> list, Function<V, K> keyMapper, Comparator<V> comparator) {
        return list.stream().collect(Collectors.groupingBy(keyMapper, Collectors.toCollection(() -> new TreeSet(comparator))));
    }

    public static <T> Comparator<T> compareDatesASC(Function<T, java.util.Date> dateGetFunc) {
        return Comparator.comparing(dateGetFunc, (d1, d2) -> d1.before((java.util.Date)d2) ? -1 : (d1.equals(d2) ? 0 : 1));
    }

    public static <T> Comparator<T> compareDatesDESC(Function<T, java.util.Date> dateGetFunc) {
        return Comparator.comparing(dateGetFunc, (d1, d2) -> d2.before((java.util.Date)d1) ? -1 : (d1.equals(d2) ? 0 : 1));
    }

    public static List<Class<?>> getAllClassesFromPackage(String sourcePackage) throws IOException {
        String SUFFIX_CLASS = ".class";
        try {
            ArrayList result = new ArrayList();
            String packageName = sourcePackage.replace(".", "/");
            Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources(packageName);
            while (resources.hasMoreElements()) {
                List newClasses = Files.walk(Paths.get(resources.nextElement().toURI()), new FileVisitOption[0]).filter(f -> Files.isRegularFile(f, new LinkOption[0]) && f.toString().endsWith(".class")).map(f -> {
                    String filename = f.getFileName().toString();
                    String fullClassName = sourcePackage + '.' + filename.substring(0, filename.length() - ".class".length());
                    try {
                        return Class.forName(fullClassName);
                    }
                    catch (ClassNotFoundException e) {
                        return null;
                    }
                }).filter(Objects::nonNull).collect(Collectors.toList());
                result.addAll(newClasses);
            }
            return result;
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    private Util() {
    }
}

