/*
 * Decompiled with CFR 0.152.
 */
package de.arstwo.twotil;

import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public class Cached<K, V>
implements Function<K, V> {
    final Function<K, V> source;
    final ConcurrentMap<K, Optional<V>> cache = new ConcurrentHashMap<K, Optional<V>>();

    public static <I, O> Function<I, O> cached(Function<I, O> source) {
        return new Cached<I, O>(source);
    }

    public Cached(Function<K, V> source) {
        this.source = source;
    }

    public V get(K key) {
        return this.cache.computeIfAbsent(key, this.source.andThen(Optional::ofNullable)).orElse(null);
    }

    @Override
    public V apply(K key) {
        return this.get(key);
    }

    public void clear() {
        this.cache.clear();
    }
}

