/*
 * Decompiled with CFR 0.152.
 */
package de.appelgriepsch.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.AppenderBase;
import de.appelgriepsch.logback.MessageLevelMapping;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import org.graylog2.gelfclient.GelfConfiguration;
import org.graylog2.gelfclient.GelfMessageBuilder;
import org.graylog2.gelfclient.GelfMessageLevel;
import org.graylog2.gelfclient.GelfTransports;
import org.graylog2.gelfclient.transport.GelfTransport;
import org.slf4j.Marker;

public class GelfAppender
extends AppenderBase<ILoggingEvent> {
    private String server = "localhost";
    private int port = 12201;
    private String hostName;
    private String protocol = "UDP";
    private boolean includeSource = true;
    private boolean includeMDC = true;
    private boolean includeStackTrace = true;
    private int queueSize = 512;
    private int connectTimeout = 1000;
    private int reconnectDelay = 500;
    private int sendBufferSize = -1;
    private boolean tcpNoDelay = false;
    private boolean tcpKeepAlive = false;
    private Map<String, Object> additionalFields = new HashMap<String, Object>();
    private GelfTransport client;

    protected void append(ILoggingEvent event) {
        if (event == null) {
            return;
        }
        GelfMessageBuilder builder = new GelfMessageBuilder(event.getFormattedMessage(), this.hostName()).timestamp((double)event.getTimeStamp() / 1000.0).level(GelfMessageLevel.fromNumericLevel((int)MessageLevelMapping.toGelfNumericValue(event.getLevel()))).additionalField("loggerName", (Object)event.getLoggerName()).additionalField("threadName", (Object)event.getThreadName());
        Marker marker = event.getMarker();
        if (marker != null) {
            builder.additionalField("marker", (Object)marker.getName());
        }
        if (this.includeMDC) {
            for (Map.Entry entry : event.getMDCPropertyMap().entrySet()) {
                builder.additionalField((String)entry.getKey(), entry.getValue());
            }
        }
        StackTraceElement[] callerData = event.getCallerData();
        if (this.includeSource && event.hasCallerData()) {
            StackTraceElement source = callerData[0];
            builder.additionalField("sourceFileName", (Object)source.getFileName());
            builder.additionalField("sourceMethodName", (Object)source.getMethodName());
            builder.additionalField("sourceClassName", (Object)source.getClassName());
            builder.additionalField("sourceLineNumber", (Object)source.getLineNumber());
        }
        IThrowableProxy thrown = event.getThrowableProxy();
        if (this.includeStackTrace && thrown != null) {
            StringBuilder stackTraceBuilder = new StringBuilder();
            for (StackTraceElementProxy stackTraceElementProxy : thrown.getStackTraceElementProxyArray()) {
                StackTraceElement stackTraceElement = stackTraceElementProxy.getStackTraceElement();
                new Formatter(stackTraceBuilder).format("%s.%s(%s:%d)%n", stackTraceElement.getClassName(), stackTraceElement.getMethodName(), stackTraceElement.getFileName(), stackTraceElement.getLineNumber());
            }
            builder.additionalField("exceptionClass", (Object)thrown.getClass().getCanonicalName());
            builder.additionalField("exceptionMessage", (Object)thrown.getMessage());
            builder.additionalField("exceptionStackTrace", (Object)stackTraceBuilder.toString());
            builder.fullMessage(event.getFormattedMessage() + "\n\n" + stackTraceBuilder.toString());
        }
        if (!this.additionalFields.isEmpty()) {
            builder.additionalFields(this.additionalFields);
        }
        try {
            this.client.send(builder.build());
        }
        catch (Exception e) {
            this.addError("Failed to write log event to the GELF server: " + e.getMessage(), e);
        }
    }

    public void start() {
        super.start();
        this.createGelfClient();
    }

    public void stop() {
        super.stop();
        this.client.stop();
    }

    private String hostName() {
        if (this.hostName == null || this.hostName.trim().isEmpty()) {
            try {
                return InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                return "localhost";
            }
        }
        return this.hostName;
    }

    private void createGelfClient() {
        this.client = GelfTransports.create((GelfConfiguration)this.getGelfConfiguration());
    }

    public GelfConfiguration getGelfConfiguration() {
        InetSocketAddress serverAddress = new InetSocketAddress(this.server, this.port);
        GelfTransports gelfProtocol = GelfTransports.valueOf((String)this.protocol().toUpperCase());
        return new GelfConfiguration(serverAddress).transport(gelfProtocol).queueSize(this.queueSize).connectTimeout(this.connectTimeout).reconnectDelay(this.reconnectDelay).sendBufferSize(this.sendBufferSize).tcpNoDelay(this.tcpNoDelay).tcpKeepAlive(this.tcpKeepAlive);
    }

    private String protocol() {
        if (!"UDP".equalsIgnoreCase(this.protocol) && !"TCP".equalsIgnoreCase(this.protocol)) {
            return "UDP";
        }
        return this.protocol;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setIncludeSource(boolean includeSource) {
        this.includeSource = includeSource;
    }

    public void setIncludeMDC(boolean includeMDC) {
        this.includeMDC = includeMDC;
    }

    public void setIncludeStackTrace(boolean includeStackTrace) {
        this.includeStackTrace = includeStackTrace;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReconnectDelay(int reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public void setTcpKeepAlive(boolean tcpKeepAlive) {
        this.tcpKeepAlive = tcpKeepAlive;
    }

    public void setAdditionalFields(String additionalFields) {
        try {
            String[] values;
            for (String field : values = additionalFields.split(",")) {
                String[] components = field.split("=");
                this.additionalFields.put(components[0], components[1]);
            }
        }
        catch (Exception e) {
            this.addWarn("Failed to read additional fields: " + e.getMessage(), e);
        }
    }
}

