/*
 * Decompiled with CFR 0.152.
 */
package raml.tools.html;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.MarkdownHelper;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.io.StringTemplateSource;
import com.github.jknack.handlebars.io.TemplateSource;
import java.io.IOException;
import org.raml.model.Raml;
import raml.tools.AbstractGenerator;
import raml.tools.IoUtil;
import raml.tools.html.HandlebarsHelper;
import raml.tools.html.HtmlGeneratorBuilder;
import raml.tools.model.RamlContext;

public class HtmlGenerator
extends AbstractGenerator {
    final Handlebars handlebars;
    private final IoUtil io;
    private String templateLocation;
    private String output = "";

    public HtmlGenerator(String string, IoUtil ioUtil) {
        this.io = ioUtil;
        this.templateLocation = string;
        this.handlebars = new Handlebars();
        this.handlebars.setInfiniteLoops(true);
        this.addHelpers();
    }

    private void addHelpers() {
        this.handlebars.registerHelper("md", (Helper)new MarkdownHelper());
        this.handlebars.registerHelper("lower", HandlebarsHelper.lowerCaseHelper());
        this.handlebars.registerHelper("lock", HandlebarsHelper.lockHelper());
        this.handlebars.registerHelper("highlight", HandlebarsHelper.highlitghHelper());
    }

    @Override
    public void startTraversal(Raml raml) {
        try {
            Template template = this.handlebars.compile((TemplateSource)new StringTemplateSource(this.templateLocation, this.io.contentFromFile(this.templateLocation)));
            this.output = template.apply((Object)new RamlContext(raml));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static HtmlGeneratorBuilder build() {
        return new HtmlGeneratorBuilder();
    }

    public String getOutput() {
        return this.output;
    }
}

