/*
 * Decompiled with CFR 0.152.
 */
package raml.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.raml.model.Raml;
import org.raml.model.Resource;
import raml.tools.RamlTraversalListener;
import raml.tools.model.ApiInformation;

public class RamlTraversal {
    Raml raml;
    List<RamlTraversalListener> traversalListeners = new ArrayList<RamlTraversalListener>();

    public RamlTraversal(Raml raml) {
        if (raml == null) {
            throw new IllegalArgumentException("raml must not be null");
        }
        if (this.traversalListeners == null) {
            throw new IllegalArgumentException("listeners must not be null");
        }
        this.raml = raml;
    }

    public RamlTraversal withListener(RamlTraversalListener ramlTraversalListener) {
        this.traversalListeners.add(ramlTraversalListener);
        return this;
    }

    public void traverse() {
        this.notifyStartTraversal();
        this.notifyStartApiInformation();
        for (final Map.Entry entry : this.raml.getResources().entrySet()) {
            this.eachListener(new ListenerFunction(){

                @Override
                public void apply(RamlTraversalListener ramlTraversalListener) {
                    ramlTraversalListener.startResource((String)entry.getKey(), (Resource)entry.getValue());
                    ramlTraversalListener.endResource((String)entry.getKey(), (Resource)entry.getValue());
                }
            });
        }
        this.notifyEndTraversal();
    }

    private void notifyEndTraversal() {
        this.eachListener(new ListenerFunction(){

            @Override
            public void apply(RamlTraversalListener ramlTraversalListener) {
                ramlTraversalListener.endTraversal(RamlTraversal.this.raml);
            }
        });
    }

    private void notifyStartApiInformation() {
        this.eachListener(new ListenerFunction(){

            @Override
            public void apply(RamlTraversalListener ramlTraversalListener) {
                ramlTraversalListener.startApiInformation(new ApiInformation(RamlTraversal.this.raml.getTitle(), RamlTraversal.this.raml.getVersion(), RamlTraversal.this.raml.getBaseUri()));
            }
        });
    }

    private void notifyStartTraversal() {
        this.eachListener(new ListenerFunction(){

            @Override
            public void apply(RamlTraversalListener ramlTraversalListener) {
                ramlTraversalListener.startTraversal(RamlTraversal.this.raml);
            }
        });
    }

    public void eachListener(ListenerFunction listenerFunction) {
        for (RamlTraversalListener ramlTraversalListener : this.traversalListeners) {
            listenerFunction.apply(ramlTraversalListener);
        }
    }

    public static interface ListenerFunction {
        public void apply(RamlTraversalListener var1);
    }
}

