/*
 * Decompiled with CFR 0.152.
 */
package raml.tools.html;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.raml.model.Raml;
import org.raml.parser.visitor.RamlDocumentBuilder;
import raml.tools.RamlTraversal;
import raml.tools.html.HtmlGenerator;
import raml.tools.html.HtmlGeneratorBuilder;

public class Raml2HtmlConverter {
    public void convert(String string, String string2) {
        OutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(new File(string2));
            HtmlGenerator htmlGenerator = new HtmlGeneratorBuilder().build();
            new RamlTraversal(this.parseRaml(string)).withListener(htmlGenerator).traverse();
            ((FileOutputStream)outputStream).write(htmlGenerator.getOutput().getBytes());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    ((FileOutputStream)outputStream).close();
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        }
    }

    private Raml parseRaml(String string) {
        try {
            return (Raml)new RamlDocumentBuilder().build((InputStream)new FileInputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException(fileNotFoundException);
        }
    }
}

