/*
 * Decompiled with CFR 0.152.
 */
package de.androbit.nibbler.file;

import de.androbit.nibbler.converter.TypedOutput;
import de.androbit.nibbler.handler.BodyHandlers;
import de.androbit.nibbler.http.MediaType;
import de.androbit.nibbler.http.RestResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.Tika;

public class FileSupport {
    private static Tika tika = new Tika();

    public static RestResponse classPathResource(String resourcePath, RestResponse restResponse) {
        InputStream resourceStream = FileSupport.class.getResourceAsStream(resourcePath);
        if (resourceStream == null) {
            return restResponse.status(404).with(BodyHandlers.text((String)("resource not found in classpath: " + resourcePath)));
        }
        MediaType from = FileSupport.getMediaType(resourcePath);
        TypedOutput output = new TypedOutput(FileSupport.readBytes(resourceStream)).withMediaType(from);
        restResponse.body(output);
        return restResponse;
    }

    public static MediaType getMediaType(String filePath) {
        String detectedType = tika.detect(filePath);
        return MediaType.valueOf((String)detectedType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] readBytes(InputStream stream) {
        try (InputStream is = stream;){
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            while ((nRead = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }
}

