/*
 * Decompiled with CFR 0.152.
 */
package de.androbit.nibbler.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;

public class IoUtil {
    public static byte[] loadBytes(InputStream inputStream) {
        try {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            return buffer.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeText(File file, String content) {
        try {
            PrintWriter out = new PrintWriter(file.getAbsolutePath());
            out.print(content);
            out.close();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String loadTextFile(File textFile) {
        try (FileInputStream fileStream = new FileInputStream(textFile);){
            String string = new String(IoUtil.loadBytes(fileStream));
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String streamToString(InputStream is) {
        return new String(IoUtil.loadBytes(is));
    }
}

