/*
 * Decompiled with CFR 0.152.
 */
package de.androbit.nibbler.netty;

import de.androbit.nibbler.converter.ContentConverters;
import de.androbit.nibbler.dsl.HandlerDefinition;
import de.androbit.nibbler.http.DefaultRestResponse;
import de.androbit.nibbler.http.FoundHandlerDefinition;
import de.androbit.nibbler.http.Header;
import de.androbit.nibbler.http.MediaType;
import de.androbit.nibbler.http.RequestHandlerMatcher;
import de.androbit.nibbler.http.RestRequest;
import de.androbit.nibbler.http.RestResponse;
import de.androbit.nibbler.netty.NettyRequestWrapper;
import de.androbit.nibbler.netty.NettyResponseWriter;
import de.androbit.nibbler.util.StacktraceUtil;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.netty.protocol.http.server.HttpServerRequest;
import io.reactivex.netty.protocol.http.server.HttpServerResponse;
import io.reactivex.netty.protocol.http.server.RequestHandler;
import java.util.HashMap;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.functions.Func1;

public class NettyServiceRequestHandler
implements RequestHandler<ByteBuf, ByteBuf> {
    final RequestHandlerMatcher handlerFinder;
    final ContentConverters converters;
    final NettyResponseWriter responseWriter;
    Logger logger = LoggerFactory.getLogger(NettyServiceRequestHandler.class);

    public NettyServiceRequestHandler(RequestHandlerMatcher handlerFinder, ContentConverters converters) {
        this.handlerFinder = handlerFinder;
        this.converters = converters;
        this.responseWriter = new NettyResponseWriter(converters);
    }

    @Override
    public Observable<Void> handle(HttpServerRequest<ByteBuf> request, HttpServerResponse<ByteBuf> response) {
        try {
            String requestPath = request.getPath();
            this.logger.debug("Server => Request: " + requestPath);
            return request.getContent().flatMap(this.processRequest(request, response));
        }
        catch (Throwable e) {
            this.logger.error("error during request: ", e);
            return this.respondWithServerError(request, response, e);
        }
    }

    Func1<ByteBuf, Observable<? extends Void>> processRequest(HttpServerRequest<ByteBuf> nettyRequest, HttpServerResponse<ByteBuf> response) {
        return byteBuf -> {
            NettyRequestWrapper request = new NettyRequestWrapper(nettyRequest, (ByteBuf)byteBuf, this.converters);
            RequestHandlerMatcher.MatchingHandlers matchingHandlers = this.handlerFinder.getMatchingHandlers(request);
            if (matchingHandlers.getContentHandler().isPresent()) {
                return this.respondWithServiceResponse(request, response, matchingHandlers.getContentHandler().get());
            }
            if (matchingHandlers.getMatchingPathHandlers().isEmpty()) {
                return this.respondWithNotFound(nettyRequest, response);
            }
            if (matchingHandlers.getMethodHandlers().isEmpty()) {
                return this.respondWithMethodNotAllowed(nettyRequest, response);
            }
            return this.respondWithNotAcceptable(response);
        };
    }

    private RestResponse handleService(RestRequest request, HandlerDefinition requestHandler) {
        DefaultRestResponse initialResponse = new DefaultRestResponse(HttpResponseStatus.OK.code(), new HashMap<Header, String>(), false);
        return requestHandler.getRequestHandler().handle(request, initialResponse);
    }

    private Observable<? extends Void> respondWithServiceResponse(NettyRequestWrapper request, HttpServerResponse<ByteBuf> response, FoundHandlerDefinition handlerDefinition) {
        HandlerDefinition currentHandler = handlerDefinition.getHandlerDefinition();
        request.withPathParams(handlerDefinition.getMatchResult().getPathParams());
        RestResponse handlerResponse = this.handleService(request, currentHandler);
        this.responseWriter.writeResponse(handlerResponse, response, currentHandler);
        return response.close(false);
    }

    private Observable<Void> respondWithServerError(HttpServerRequest<ByteBuf> request, HttpServerResponse<ByteBuf> response, Throwable e) {
        this.logger.error("Server => Error [" + request.getPath() + "] => " + e);
        return this.respondWithStatusAndMessage(response, HttpResponseStatus.BAD_REQUEST, Optional.of("Error during request: \n" + StacktraceUtil.getStackTrace(e)));
    }

    private Observable<Void> respondWithMethodNotAllowed(HttpServerRequest<ByteBuf> request, HttpServerResponse<ByteBuf> response) {
        return this.respondWithStatusAndMessage(response, HttpResponseStatus.METHOD_NOT_ALLOWED, Optional.of("Path Requested =>: " + request.getPath() + '\n'));
    }

    private Observable<Void> respondWithNotFound(HttpServerRequest<ByteBuf> request, HttpServerResponse<ByteBuf> response) {
        return this.respondWithStatusAndMessage(response, HttpResponseStatus.NOT_FOUND, Optional.of("Path Requested =>: " + request.getPath() + '\n'));
    }

    private Observable<Void> respondWithNotAcceptable(HttpServerResponse<ByteBuf> response) {
        return this.respondWithStatusAndMessage(response, HttpResponseStatus.NOT_ACCEPTABLE, Optional.empty());
    }

    private Observable<Void> respondWithStatusAndMessage(HttpServerResponse<ByteBuf> response, HttpResponseStatus status, Optional<String> message) {
        response.setStatus(status);
        response.writeString(message.orElse(""));
        response.getHeaders().set(Header.ContentType.name(), (Object)MediaType.TEXT_PLAIN.contentType());
        return response.close();
    }
}

