/*
 * Decompiled with CFR 0.152.
 */
package de.androbit.nibbler.netty;

import de.androbit.nibbler.converter.ContentConverters;
import de.androbit.nibbler.converter.TypedInput;
import de.androbit.nibbler.http.Header;
import de.androbit.nibbler.http.MediaType;
import de.androbit.nibbler.http.Params;
import de.androbit.nibbler.http.RequestPath;
import de.androbit.nibbler.http.RestHttpMethod;
import de.androbit.nibbler.http.RestRequest;
import io.netty.buffer.ByteBuf;
import io.reactivex.netty.protocol.http.server.HttpServerRequest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class NettyRequestWrapper
implements RestRequest {
    private final HttpServerRequest<ByteBuf> request;
    private final ContentConverters converters;
    private final ByteBuf content;
    private Map<String, String> pathParams;

    public NettyRequestWrapper(HttpServerRequest<ByteBuf> request, ByteBuf content, ContentConverters converters) {
        this.request = request;
        this.converters = converters;
        this.content = content;
    }

    @Override
    public RestHttpMethod method() {
        return RestHttpMethod.valueOf(this.request.getHttpMethod().name());
    }

    @Override
    public RequestPath path() {
        return new RequestPath(this.request.getPath());
    }

    @Override
    public Params pathParams() {
        HashMap<String, List<String>> paramsWithListValues = new HashMap<String, List<String>>();
        this.pathParams.forEach((key, value) -> paramsWithListValues.put((String)key, Arrays.asList(value)));
        return new Params(paramsWithListValues);
    }

    @Override
    public Optional<String> pathParam(String paramName) {
        return this.pathParams().get(paramName);
    }

    @Override
    public Params queryParams() {
        return new Params(this.request.getQueryParameters());
    }

    @Override
    public Optional<String> queryParam(String paramName) {
        return this.queryParams().get(paramName);
    }

    @Override
    public String header(String name) {
        return this.request.getHeaders().get(name);
    }

    @Override
    public TypedInput body() {
        return new TypedInput(this.getContentStream(), this.getContentType());
    }

    @Override
    public <T> T bodyAs(Class<T> clazz) {
        return this.convertBodyContent(this.getContentType(), clazz);
    }

    public <T> T convertBodyContent(MediaType contentType, Class<T> clazz) {
        return this.converters.getConverter(contentType).orElse(this.converters.getDefaultConverter()).fromBody(new TypedInput(this.getContentStream(), contentType), clazz);
    }

    InputStream getContentStream() {
        byte[] bytes = new byte[this.content.readableBytes()];
        int readerIndex = this.content.readerIndex();
        this.content.getBytes(readerIndex, bytes);
        return new ByteArrayInputStream(bytes);
    }

    MediaType getContentType() {
        String header = this.header(Header.ContentType.name());
        return header != null ? MediaType.valueOf(header) : MediaType.APPLICATION_OCTET_STREAM;
    }

    public NettyRequestWrapper withPathParams(Map<String, String> pathParams) {
        this.pathParams = pathParams;
        return this;
    }
}

