/*
 * Decompiled with CFR 0.152.
 */
package de.androbit.nibbler.converter;

import de.androbit.nibbler.converter.ContentConverter;
import de.androbit.nibbler.http.MediaType;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class ContentConverters {
    ContentConverter defaultConverter;
    Map<MediaType, ContentConverter> typeConverters = new HashMap<MediaType, ContentConverter>();
    Map<Class, ContentConverter> converterClasses = new HashMap<Class, ContentConverter>();

    public ContentConverters(ContentConverter defaultConverter) {
        this.setDefaultConverter(defaultConverter);
    }

    public Optional<ContentConverter> getConverter(Class<? extends ContentConverter> converterClass) {
        return Optional.ofNullable(this.converterClasses.get(converterClass));
    }

    public Optional<ContentConverter> getConverter(MediaType mediaType) {
        return Optional.ofNullable(this.typeConverters.get(mediaType));
    }

    public ContentConverters addConverter(MediaType mediaType, ContentConverter converter) {
        this.typeConverters.put(mediaType, converter);
        this.converterClasses.put(converter.getClass(), converter);
        return this;
    }

    public ContentConverter getDefaultConverter() {
        return this.defaultConverter;
    }

    public void setDefaultConverter(ContentConverter defaultConverter) {
        this.defaultConverter = defaultConverter;
        this.converterClasses.put(defaultConverter.getClass(), defaultConverter);
    }
}

