/*
 * Decompiled with CFR 0.152.
 */
package brainslug.quartz;

import brainslug.flow.Identifier;
import brainslug.flow.context.BrainslugContext;
import brainslug.flow.execution.TriggerContext;
import brainslug.flow.execution.async.AbstractAsyncTaskScheduler;
import brainslug.flow.execution.async.AsyncTask;
import brainslug.util.IdUtil;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.spi.JobFactory;
import org.quartz.spi.TriggerFiredBundle;

public class QuartzScheduler
extends AbstractAsyncTaskScheduler {
    protected static final String INSTANCE_ID = "instanceId";
    protected static final String TASK_NODE_ID = "taskNodeId";
    protected static final String DEFINITION_ID = "definitionId";
    protected final Scheduler quartz;

    public QuartzScheduler(Scheduler quartz) {
        this.quartz = quartz;
        try {
            this.quartz.setJobFactory((JobFactory)new BrainslugContextJobFactory());
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    public void internalScheduleTask(AsyncTask asyncTask) {
        JobDetail job = JobBuilder.newJob(TaskJob.class).usingJobData(TASK_NODE_ID, asyncTask.getTaskNodeId().stringValue()).usingJobData(INSTANCE_ID, asyncTask.getInstanceId().stringValue()).usingJobData(DEFINITION_ID, asyncTask.getDefinitionId().stringValue()).storeDurably().build();
        Trigger trigger = TriggerBuilder.newTrigger().startNow().build();
        this.scheduleInQuartz(job, trigger);
    }

    private void scheduleInQuartz(JobDetail job, Trigger trigger) {
        try {
            this.quartz.scheduleJob(job, trigger);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    protected void internalStart() {
        try {
            this.quartz.start();
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    protected void internalStop() {
        try {
            this.quartz.shutdown(true);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    public static class TaskJob
    implements Job {
        BrainslugContext brainslugContext;
        Identifier taskNodeId;
        Identifier instanceId;
        Identifier definitionId;

        public TaskJob(BrainslugContext brainslugContext) {
            this.brainslugContext = brainslugContext;
        }

        TaskJob withTaskNodeId(Identifier taskNodeId) {
            this.taskNodeId = taskNodeId;
            return this;
        }

        TaskJob withInstanceId(Identifier instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        TaskJob withDefinitionId(Identifier definitionId) {
            this.definitionId = definitionId;
            return this;
        }

        public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
            this.brainslugContext.trigger(new TriggerContext().instanceId(this.instanceId).nodeId(this.taskNodeId).definitionId(this.definitionId).async(Boolean.valueOf(true)));
        }
    }

    class BrainslugContextJobFactory
    implements JobFactory {
        BrainslugContextJobFactory() {
        }

        public Job newJob(TriggerFiredBundle bundle, Scheduler scheduler) throws SchedulerException {
            if (bundle.getJobDetail().getJobClass().isAssignableFrom(TaskJob.class)) {
                Identifier instanceId = IdUtil.id((String)bundle.getJobDetail().getJobDataMap().getString(QuartzScheduler.INSTANCE_ID));
                Identifier taskNodeId = IdUtil.id((String)bundle.getJobDetail().getJobDataMap().getString(QuartzScheduler.TASK_NODE_ID));
                Identifier definitionId = IdUtil.id((String)bundle.getJobDetail().getJobDataMap().getString(QuartzScheduler.DEFINITION_ID));
                return new TaskJob(QuartzScheduler.this.context).withTaskNodeId(taskNodeId).withDefinitionId(definitionId).withInstanceId(instanceId);
            }
            throw new IllegalArgumentException("can only handle task jobs");
        }
    }
}

