/*
 * Decompiled with CFR 0.152.
 */
package brainslug.util;

import java.util.Collection;

public class Preconditions {
    public static <T> T singleItem(Collection<T> collection) {
        if (collection.size() == 1) {
            return collection.iterator().next();
        }
        throw new AssertionException("expected collection to have single item: " + collection);
    }

    public static String notEmpty(String input) {
        return Preconditions.notEmpty(input, "string");
    }

    public static String notEmpty(String input, String name) {
        if (Preconditions.notNull(input).trim().isEmpty()) {
            throw new AssertionException(name + " should not be empty");
        }
        return input;
    }

    public static <T> T notNull(T object) {
        return Preconditions.notNull(object, "object");
    }

    public static <T> T notNull(T object, String name) {
        if (object == null) {
            throw new AssertionException(name + " should not be null");
        }
        return object;
    }

    static class AssertionException
    extends RuntimeException {
        public AssertionException(String message) {
            super(message);
        }
    }
}

