/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.node.task;

import brainslug.flow.node.task.CallDefinition;
import java.lang.reflect.Method;

public class InvokeDefinition
extends CallDefinition {
    private final Class<?> serviceClass;
    private Method method;

    public InvokeDefinition(Class<?> serviceClass) {
        this.serviceClass = serviceClass;
    }

    public InvokeDefinition method(Method method) {
        this.method = method;
        return this;
    }

    public InvokeDefinition name(String methodName, Class<?> ... parameterTypes) {
        try {
            this.method = this.serviceClass.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            String noMethodMessage = String.format("method %s for service %s does not exist", methodName, this.serviceClass);
            throw new IllegalArgumentException(noMethodMessage);
        }
        return this;
    }

    public Class<?> getTargetClass() {
        return this.serviceClass;
    }

    public Method getMethod() {
        return this.method;
    }
}

