/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.node.task;

import brainslug.flow.node.FlowNodeDefinition;
import brainslug.flow.node.task.CallDefinition;
import brainslug.flow.node.task.GoalDefinition;
import brainslug.flow.node.task.RetryStrategy;
import brainslug.flow.node.task.TaskScript;
import brainslug.util.Option;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractTaskDefinition<SelfType extends AbstractTaskDefinition>
extends FlowNodeDefinition<SelfType> {
    protected Class<?> delegateClass;
    protected TaskScript taskScript;
    protected boolean async;
    protected boolean retryAsync;
    protected CallDefinition methodCall;
    protected RetryStrategy retryStrategy;
    protected Option<GoalDefinition> goal = Option.empty();
    protected Map<String, String> configuration = new HashMap<String, String>();

    public SelfType delegate(Class<?> delegateClass) {
        this.delegateClass = delegateClass;
        return (SelfType)((AbstractTaskDefinition)this.self());
    }

    public SelfType call(CallDefinition methodCall) {
        this.methodCall = methodCall;
        return (SelfType)((AbstractTaskDefinition)this.self());
    }

    public SelfType async(boolean async) {
        this.async = async;
        return (SelfType)((AbstractTaskDefinition)this.self());
    }

    public SelfType retryAsync(boolean retryAsync) {
        this.retryAsync = retryAsync;
        return (SelfType)((AbstractTaskDefinition)this.self());
    }

    public SelfType retryStrategy(RetryStrategy retryStrategy) {
        this.retryStrategy = retryStrategy;
        return (SelfType)((AbstractTaskDefinition)this.self());
    }

    public SelfType goal(GoalDefinition goal) {
        this.goal = Option.of(goal);
        return (SelfType)((AbstractTaskDefinition)this.self());
    }

    public SelfType script(String language, String text) {
        this.taskScript = new TaskScript(language, text);
        return (SelfType)((AbstractTaskDefinition)this.self());
    }

    public ConfiugrationBuilder withConfiguration() {
        return new ConfiugrationBuilder(this, (AbstractTaskDefinition)this.self());
    }

    public Class<?> getDelegateClass() {
        return this.delegateClass;
    }

    public CallDefinition getMethodCall() {
        return this.methodCall;
    }

    public Option<TaskScript> getTaskScript() {
        return Option.of(this.taskScript);
    }

    public Option<GoalDefinition> getGoal() {
        return this.goal;
    }

    public boolean isAsync() {
        return this.async;
    }

    public boolean isRetryAsync() {
        return this.retryAsync;
    }

    public Option<RetryStrategy> getRetryStrategy() {
        return Option.of(this.retryStrategy);
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public static class ConfiugrationBuilder {
        SelfType task;
        final /* synthetic */ AbstractTaskDefinition this$0;

        public ConfiugrationBuilder(SelfType task) {
            this.this$0 = this$0;
            this.task = task;
        }

        public ConfiugrationBuilder parameter(String parameterName, String parameterValue) {
            this.this$0.configuration.put(parameterName, parameterValue);
            return this;
        }

        public ConfiugrationBuilder parameters(Map<? extends String, ? extends String> parameters) {
            this.this$0.configuration.putAll(parameters);
            return this;
        }

        public SelfType done() {
            return this.task;
        }
    }
}

