/*
 * Decompiled with CFR 0.152.
 */
package brainslug.maven;

import brainslug.flow.builder.FlowBuilder;
import brainslug.flow.renderer.DefaultSkin;
import brainslug.flow.renderer.Format;
import brainslug.flow.renderer.JGraphBpmnRenderer;
import brainslug.flow.renderer.Skin;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="render-flows", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class RenderFlowsMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="project.compileClasspathElements", required=true, readonly=true)
    private List<String> classpath;
    @Parameter(required=true)
    private String flows;
    @Parameter(required=false)
    private String format = "PNG";
    @Parameter(required=false)
    private String outputDir = "flows";

    public void execute() throws MojoExecutionException, MojoFailureException {
        for (String flowName : this.flows.split(",")) {
            FlowBuilder flowBuilder = this.createFlowInstance(flowName.trim(), this.setupClassPath());
            this.renderImage(flowBuilder);
        }
    }

    private void renderImage(FlowBuilder flowBuilder) {
        Format imageFormat = Format.valueOf((String)this.format.toUpperCase());
        FileOutputStream fileOutputStream = this.getFileOutputStream(this.getOutputFile(this.flows + "." + imageFormat.name().toLowerCase()));
        new JGraphBpmnRenderer((Skin)new DefaultSkin()).render(flowBuilder, (OutputStream)fileOutputStream, imageFormat);
    }

    private FlowBuilder createFlowInstance(String flowName, ClassLoader classLoader) {
        try {
            Class<?> flowClass = Class.forName(flowName, true, classLoader);
            try {
                return (FlowBuilder)flowClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("unable to find flow with name: " + flowName, e);
        }
    }

    private File getOutputFile(String fileName) {
        return new File(this.getOutputDirectory().getAbsolutePath() + File.separatorChar + fileName);
    }

    private File getOutputDirectory() {
        File outputDirectory = new File(this.project.getBuild().getDirectory() + File.separatorChar + this.outputDir);
        outputDirectory.mkdirs();
        return outputDirectory;
    }

    private FileOutputStream getFileOutputStream(File outputFile) {
        try {
            return new FileOutputStream(outputFile);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(outputFile + " is a invalid path.");
        }
    }

    ClassLoader setupClassPath() {
        try {
            HashSet<URL> urls = new HashSet<URL>();
            for (String element : this.classpath) {
                urls.add(new File(element).toURI().toURL());
            }
            URLClassLoader contextClassLoader = URLClassLoader.newInstance(urls.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
            Thread.currentThread().setContextClassLoader(contextClassLoader);
            return contextClassLoader;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

