/*
 * Decompiled with CFR 0.152.
 */
package brainslug.jpa.spring;

import brainslug.jpa.Database;
import brainslug.jpa.spring.SpringJpaAsyncTriggerStore;
import brainslug.jpa.spring.SpringJpaInstanceStore;
import brainslug.jpa.spring.SpringJpaPropertyStore;
import brainslug.jpa.spring.SpringJpaTokenStore;
import brainslug.util.IdGenerator;
import brainslug.util.UuidGenerator;
import com.mysema.query.jpa.JPQLTemplates;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
public class SpringDatabaseConfiguration {
    @PersistenceContext
    @Qualifier(value="brainslug")
    EntityManager entityManager;
    @Autowired
    JPQLTemplates jpqlTemplates;

    @Bean
    Database database() {
        return new Database(this.entityManager, this.jpqlTemplates);
    }

    @Bean
    IdGenerator idGenerator() {
        return this.createIdGenerator();
    }

    protected IdGenerator createIdGenerator() {
        return new UuidGenerator();
    }

    @Bean
    SpringJpaPropertyStore springJpaPropertyStore() {
        return new SpringJpaPropertyStore(this.database(), this.idGenerator(), this.springJpaInstanceStore());
    }

    @Bean
    SpringJpaTokenStore springJpaTokenStore() {
        return new SpringJpaTokenStore(this.database(), this.idGenerator(), this.springJpaInstanceStore());
    }

    @Bean
    SpringJpaAsyncTriggerStore springJpaAsyncTriggerStore() {
        return new SpringJpaAsyncTriggerStore(this.database(), this.idGenerator());
    }

    @Bean
    SpringJpaInstanceStore springJpaInstanceStore() {
        return new SpringJpaInstanceStore(this.database(), this.idGenerator());
    }
}

