/*
 * Decompiled with CFR 0.152.
 */
package brainslug.jpa.entity;

import brainslug.flow.execution.property.BooleanProperty;
import brainslug.flow.execution.property.DateProperty;
import brainslug.flow.execution.property.DoubleProperty;
import brainslug.flow.execution.property.FloatProperty;
import brainslug.flow.execution.property.IntProperty;
import brainslug.flow.execution.property.LongProperty;
import brainslug.flow.execution.property.ObjectProperty;
import brainslug.flow.execution.property.StringProperty;
import brainslug.flow.instance.FlowInstanceProperty;
import brainslug.jpa.util.ObjectSerializer;
import brainslug.util.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Version;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BS_INSTANCE_PROPERTY")
public class InstancePropertyEntity
implements FlowInstanceProperty {
    @Id
    @Column(name="_ID")
    protected String id;
    @NotNull
    @Column(name="_CREATED")
    protected Long created;
    @Version
    @Column(name="_VERSION")
    protected Long version;
    @NotNull
    @Column(name="_INSTANCE_ID")
    protected String instanceId;
    @Column(name="_VALUE_TYPE")
    protected String valueType;
    @Column(name="_PROPERTY_KEY")
    protected String propertyKey;
    @Lob
    @Type(type="org.hibernate.type.StringType")
    @Column(name="_STRING_VALUE", length=4000)
    protected String stringValue;
    @Column(name="_LONG_VALUE")
    protected Long longValue;
    @Column(name="_DOUBLE_VALUE")
    protected Double doubleValue;
    @Type(type="org.hibernate.type.BlobType")
    @Column(name="_BLOB_VALUE")
    protected Blob blobValue;

    public String getId() {
        return this.id;
    }

    public InstancePropertyEntity withId(String id) {
        this.id = id;
        return this;
    }

    public Long getCreated() {
        return this.created;
    }

    public InstancePropertyEntity withCreated(Long created) {
        this.created = created;
        return this;
    }

    public Long getVersion() {
        return this.version;
    }

    public InstancePropertyEntity withVersion(Long version) {
        this.version = version;
        return this;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public InstancePropertyEntity withInstanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public String getValueType() {
        return this.valueType;
    }

    public InstancePropertyEntity withValueType(String valueType) {
        this.valueType = valueType;
        return this;
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    public InstancePropertyEntity withPropertyKey(String propertyKey) {
        this.propertyKey = propertyKey;
        return this;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public InstancePropertyEntity withStringValue(String stringValue) {
        this.stringValue = stringValue;
        return this;
    }

    public InstancePropertyEntity withBlobValue(Blob blobValue) {
        this.blobValue = blobValue;
        return this;
    }

    public Long getLongValue() {
        return this.longValue;
    }

    public InstancePropertyEntity withLongValue(Long longValue) {
        this.longValue = longValue;
        return this;
    }

    public Double getDoubleValue() {
        return this.doubleValue;
    }

    public InstancePropertyEntity withDoubleValue(Double doubleValue) {
        this.doubleValue = doubleValue;
        return this;
    }

    public String getKey() {
        return this.propertyKey;
    }

    public Object getValue() {
        return this.propertyForType(this.getKey(), this.getValueType(), this.getStringValue(), this.getLongValue(), this.getDoubleValue()).getValue();
    }

    FlowInstanceProperty propertyForType(String key, String type, String stringValue, Long longValue, Double doubleValue) {
        ValueType valueType = new ValueType(type);
        if (valueType.equals(ValueType.STRING)) {
            return new StringProperty(key, stringValue);
        }
        if (valueType.equals(ValueType.LONG)) {
            return new LongProperty(key, longValue);
        }
        if (valueType.equals(ValueType.DATE)) {
            return new DateProperty(key, new Date(longValue));
        }
        if (valueType.equals(ValueType.INT)) {
            return new IntProperty(key, Integer.valueOf(longValue.intValue()));
        }
        if (valueType.equals(ValueType.DOUBLE)) {
            return new DoubleProperty(key, doubleValue);
        }
        if (valueType.equals(ValueType.FLOAT)) {
            return new FloatProperty(key, Float.valueOf(doubleValue.floatValue()));
        }
        if (valueType.equals(ValueType.BOOLEAN)) {
            return new BooleanProperty(key, Boolean.valueOf(longValue == 1L));
        }
        if (valueType.equals(ValueType.SERIALIZABLE)) {
            byte[] inputStream = this.bytesFromBlob((Blob)Preconditions.notNull((Object)this.blobValue));
            return new ObjectProperty(key, new ObjectSerializer().deserialize(inputStream));
        }
        throw new IllegalArgumentException("unhandled value type:" + valueType);
    }

    private byte[] bytesFromBlob(Blob blob) {
        try {
            return this.toBytes((InputStream)Preconditions.notNull((Object)blob.getBinaryStream()));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    byte[] toBytes(InputStream inputStream) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        try {
            int nRead;
            while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            return buffer.toByteArray();
        }
        catch (IOException ioError) {
            throw new RuntimeException(ioError);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstancePropertyEntity that = (InstancePropertyEntity)o;
        if (this.instanceId != null ? !this.instanceId.equals(that.instanceId) : that.instanceId != null) {
            return false;
        }
        if (this.propertyKey != null ? !this.propertyKey.equals(that.propertyKey) : that.propertyKey != null) {
            return false;
        }
        return !(this.valueType != null ? !this.valueType.equals(that.valueType) : that.valueType != null);
    }

    public int hashCode() {
        int result = this.instanceId != null ? this.instanceId.hashCode() : 0;
        result = 31 * result + (this.valueType != null ? this.valueType.hashCode() : 0);
        result = 31 * result + (this.propertyKey != null ? this.propertyKey.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "InstancePropertyEntity{id='" + this.id + '\'' + ", created=" + this.created + ", version=" + this.version + ", instanceId='" + this.instanceId + '\'' + ", valueType='" + this.valueType + '\'' + ", propertyKey='" + this.propertyKey + '\'' + ", stringValue='" + this.stringValue + '\'' + ", longValue=" + this.longValue + ", doubleValue=" + this.doubleValue + '}';
    }

    public static class ValueType {
        public static final ValueType STRING = new ValueType("string");
        public static final ValueType DATE = new ValueType("date");
        public static final ValueType INT = new ValueType("int");
        public static final ValueType DOUBLE = new ValueType("double");
        public static final ValueType FLOAT = new ValueType("float");
        public static final ValueType BOOLEAN = new ValueType("boolean");
        public static final ValueType SERIALIZABLE = new ValueType("serializable");
        public static final ValueType LONG = new ValueType("long");
        String typeName;

        public ValueType(String typeName) {
            this.typeName = typeName;
        }

        public String typeName() {
            return this.typeName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ValueType valueType = (ValueType)o;
            return !(this.typeName != null ? !this.typeName.equals(valueType.typeName) : valueType.typeName != null);
        }

        public int hashCode() {
            return this.typeName != null ? this.typeName.hashCode() : 0;
        }
    }
}

