/*
 * Decompiled with CFR 0.152.
 */
package brainslug.jpa.entity;

import brainslug.flow.builder.FlowBuilder;
import brainslug.flow.definition.Identifier;
import brainslug.flow.execution.property.ExecutionProperties;
import brainslug.flow.execution.token.TokenList;
import brainslug.flow.instance.FlowInstance;
import brainslug.flow.instance.FlowInstanceProperties;
import brainslug.flow.instance.FlowInstanceTokenList;
import brainslug.jpa.entity.FlowTokenEntity;
import brainslug.jpa.entity.InstancePropertyEntity;
import brainslug.util.IdUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Version;
import javax.validation.constraints.NotNull;

@Entity
@Table(name="BS_FLOW_INSTANCE")
public class FlowInstanceEntity
implements FlowInstance {
    @Id
    @Column(name="_ID")
    protected String id;
    @NotNull
    @Column(name="_CREATED")
    protected Long created;
    @NotNull
    @Column(name="_DEFINITION_ID")
    protected String definitionId;
    @Version
    @Column(name="_VERSION")
    protected Long version;
    @OneToMany(fetch=FetchType.EAGER)
    @JoinColumn(name="_INSTANCE_ID")
    Set<InstancePropertyEntity> properties = new HashSet<InstancePropertyEntity>();
    @OneToMany(fetch=FetchType.EAGER)
    @JoinColumn(name="_FLOW_INSTANCE_ID")
    List<FlowTokenEntity> tokens = new ArrayList<FlowTokenEntity>();

    public String getId() {
        return this.id;
    }

    public FlowInstanceEntity withId(String id) {
        this.id = id;
        return this;
    }

    public Long getCreated() {
        return this.created;
    }

    public FlowInstanceEntity withCreated(Long created) {
        this.created = created;
        return this;
    }

    public Identifier getDefinitionId() {
        return IdUtil.id((String)this.definitionId);
    }

    public FlowInstanceTokenList getTokens() {
        return new TokenList(this.tokens);
    }

    public List<FlowTokenEntity> getTokenEntities() {
        return this.tokens;
    }

    public FlowInstanceEntity withDefinitionId(String definitionId) {
        this.definitionId = definitionId;
        return this;
    }

    public FlowInstanceProperties getProperties() {
        return new ExecutionProperties().from(this.properties);
    }

    public Set<InstancePropertyEntity> getPropertiesEntities() {
        return this.properties;
    }

    public Long getVersion() {
        return this.version;
    }

    public FlowInstanceEntity withVersion(Long version) {
        this.version = version;
        return this;
    }

    public Identifier<?> getIdentifier() {
        return FlowBuilder.id((String)this.id);
    }
}

