/*
 * Decompiled with CFR 0.152.
 */
package brainslug.jpa;

import brainslug.flow.definition.Identifier;
import brainslug.flow.definition.StringIdentifier;
import brainslug.flow.execution.token.Token;
import brainslug.flow.execution.token.TokenList;
import brainslug.flow.execution.token.TokenStore;
import brainslug.flow.instance.FlowInstanceToken;
import brainslug.flow.instance.FlowInstanceTokenList;
import brainslug.jpa.Database;
import brainslug.jpa.JpaInstanceStore;
import brainslug.jpa.entity.FlowTokenEntity;
import brainslug.jpa.entity.QFlowTokenEntity;
import brainslug.util.IdGenerator;
import brainslug.util.Option;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.ConstructorExpression;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Predicate;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaTokenStore
implements TokenStore {
    private Logger log = LoggerFactory.getLogger(JpaTokenStore.class);
    private final Database database;
    private final IdGenerator idGenerator;
    private final JpaInstanceStore jpaInstanceStore;

    public JpaTokenStore(Database database, IdGenerator idGenerator, JpaInstanceStore jpaInstanceStore) {
        this.database = database;
        this.idGenerator = idGenerator;
        this.jpaInstanceStore = jpaInstanceStore;
    }

    public FlowInstanceTokenList getInstanceTokens(Identifier instanceId) {
        return new TokenList(this.tokensForInstance(instanceId));
    }

    private List<Token> tokensForInstance(Identifier instanceId) {
        return ((JPAQuery)((JPAQuery)this.database.query().from((EntityPath)QFlowTokenEntity.flowTokenEntity)).where(new Predicate[]{QFlowTokenEntity.flowTokenEntity.flowInstanceId.eq((Object)instanceId.stringValue()), QFlowTokenEntity.flowTokenEntity.isDead.eq((Object)0)})).list((Expression)ConstructorExpression.create(Token.class, (Expression[])new Expression[]{QFlowTokenEntity.flowTokenEntity.id, QFlowTokenEntity.flowTokenEntity.currentNode, QFlowTokenEntity.flowTokenEntity.sourceNode, QFlowTokenEntity.flowTokenEntity.flowInstanceId, QFlowTokenEntity.flowTokenEntity.isDead, QFlowTokenEntity.flowTokenEntity.isFinal}));
    }

    public FlowInstanceTokenList getNodeTokens(Identifier nodeId, Identifier instanceId) {
        return new TokenList(this.tokensForNode(nodeId, instanceId));
    }

    List<Token> tokensForNode(Identifier nodeId, Identifier instanceId) {
        return ((JPAQuery)((JPAQuery)this.database.query().from((EntityPath)QFlowTokenEntity.flowTokenEntity)).where(new Predicate[]{QFlowTokenEntity.flowTokenEntity.flowInstanceId.eq((Object)instanceId.stringValue()), QFlowTokenEntity.flowTokenEntity.currentNode.eq((Object)nodeId.stringValue()), QFlowTokenEntity.flowTokenEntity.isDead.eq((Object)0)})).list((Expression)ConstructorExpression.create(Token.class, (Expression[])new Expression[]{QFlowTokenEntity.flowTokenEntity.id, QFlowTokenEntity.flowTokenEntity.currentNode, QFlowTokenEntity.flowTokenEntity.sourceNode, QFlowTokenEntity.flowTokenEntity.flowInstanceId, QFlowTokenEntity.flowTokenEntity.isDead, QFlowTokenEntity.flowTokenEntity.isFinal}));
    }

    public FlowInstanceToken addToken(Identifier instanceId, Identifier nodeId, Option<Identifier> sourceNodeId, boolean isFinal) {
        Identifier tokenId = this.idGenerator.generateId();
        FlowTokenEntity newToken = new FlowTokenEntity().withId(tokenId.stringValue()).withCreated(new Date().getTime()).withCurrentNode(nodeId.stringValue()).withSourceNode(((Identifier)sourceNodeId.orElse((Object)new StringIdentifier(null))).stringValue()).withFlowInstanceId(instanceId.stringValue()).setFinal(isFinal).setDead(false);
        this.database.insertOrUpdate(newToken);
        this.jpaInstanceStore.findInstanceById(instanceId).getTokenEntities().add(newToken);
        return newToken;
    }

    public boolean setDead(Identifier instanceId, Identifier tokenId) {
        this.log.debug("removing token: {}", (Object)tokenId.stringValue());
        Option<FlowTokenEntity> tokenEntity = this.getToken(instanceId, tokenId);
        if (tokenEntity.isPresent()) {
            ((FlowTokenEntity)tokenEntity.get()).setDead(true);
            this.database.insertOrUpdate(tokenEntity.get());
            return true;
        }
        return false;
    }

    public boolean setFinal(Identifier instanceId, Identifier tokenId) {
        Option<FlowTokenEntity> tokenEntity = this.getToken(instanceId, tokenId);
        if (tokenEntity.isPresent()) {
            ((FlowTokenEntity)tokenEntity.get()).setFinal(true);
            this.database.insertOrUpdate(tokenEntity.get());
            return true;
        }
        return false;
    }

    Option<FlowTokenEntity> getToken(Identifier instanceId, Identifier tokenId) {
        for (FlowTokenEntity token : this.jpaInstanceStore.findInstanceById(instanceId).getTokenEntities()) {
            if (!token.getId().equals(tokenId)) continue;
            return Option.of((Object)token);
        }
        return Option.empty();
    }
}

