/*
 * Decompiled with CFR 0.152.
 */
package brainslug.jpa;

import brainslug.flow.definition.Identifier;
import brainslug.flow.execution.property.BooleanProperty;
import brainslug.flow.execution.property.DateProperty;
import brainslug.flow.execution.property.DoubleProperty;
import brainslug.flow.execution.property.ExecutionProperties;
import brainslug.flow.execution.property.FloatProperty;
import brainslug.flow.execution.property.IntProperty;
import brainslug.flow.execution.property.LongProperty;
import brainslug.flow.execution.property.StringProperty;
import brainslug.flow.execution.property.store.PropertyStore;
import brainslug.flow.instance.FlowInstanceProperties;
import brainslug.flow.instance.FlowInstanceProperty;
import brainslug.jpa.Database;
import brainslug.jpa.JpaInstanceStore;
import brainslug.jpa.entity.FlowInstanceEntity;
import brainslug.jpa.entity.InstancePropertyEntity;
import brainslug.jpa.entity.QInstancePropertyEntity;
import brainslug.jpa.util.ObjectSerializer;
import brainslug.util.IdGenerator;
import brainslug.util.Option;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Predicate;
import java.sql.Blob;
import java.util.Collection;
import java.util.Date;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaPropertyStore
implements PropertyStore {
    private Logger log = LoggerFactory.getLogger(JpaPropertyStore.class);
    private ObjectSerializer serializer = new ObjectSerializer();
    protected final Database database;
    protected final IdGenerator idGenerator;
    private final JpaInstanceStore jpaInstanceStore;

    public JpaPropertyStore(Database database, IdGenerator idGenerator, JpaInstanceStore jpaInstanceStore) {
        this.database = database;
        this.idGenerator = idGenerator;
        this.jpaInstanceStore = jpaInstanceStore;
    }

    public void setProperty(Identifier<?> instanceId, FlowInstanceProperty<?> property) {
        FlowInstanceEntity instance = this.jpaInstanceStore.findInstanceById(instanceId);
        this.updateOrCreatePropertyEntity(instance, property);
    }

    public void setProperties(Identifier<?> instanceId, FlowInstanceProperties<?, FlowInstanceProperty<?>> executionProperties) {
        this.log.debug("storing properties {} for instance {}", executionProperties, instanceId);
        for (FlowInstanceProperty property : executionProperties.getValues()) {
            this.setProperty(instanceId, property);
        }
    }

    public Option<FlowInstanceProperty<?>> getProperty(Identifier<?> instanceId, Identifier<?> key) {
        FlowInstanceProperty propertyEntity = (FlowInstanceProperty)this.propertyQuery(instanceId, key.stringValue()).singleResult(new Expression[0]);
        return Option.of((Object)propertyEntity);
    }

    JPAQuery propertyQuery(Identifier<?> instanceId, String propertyKey) {
        return (JPAQuery)((JPAQuery)this.database.query().from((EntityPath)QInstancePropertyEntity.instancePropertyEntity)).where(new Predicate[]{QInstancePropertyEntity.instancePropertyEntity.propertyKey.eq((Object)propertyKey), QInstancePropertyEntity.instancePropertyEntity.instanceId.eq((Object)instanceId.stringValue())});
    }

    protected void updateOrCreatePropertyEntity(FlowInstanceEntity instance, FlowInstanceProperty property) {
        Option<InstancePropertyEntity> instanceProperty = this.propertyEntity(instance, property.getKey());
        if (instanceProperty.isPresent()) {
            this.database.insertOrUpdate(this.withPropertyValue((InstancePropertyEntity)instanceProperty.get(), property));
        } else {
            InstancePropertyEntity newProperty = this.newInstancePropertyEntity(instance.getIdentifier(), property);
            this.database.insertOrUpdate(this.withPropertyValue(newProperty, property));
            instance.getPropertiesEntities().add(newProperty);
        }
    }

    Option<InstancePropertyEntity> propertyEntity(FlowInstanceEntity instanceEntity, String propertyKey) {
        for (InstancePropertyEntity propertyEntity : instanceEntity.getPropertiesEntities()) {
            if (!propertyEntity.getKey().equals(propertyKey)) continue;
            return Option.of((Object)propertyEntity);
        }
        return Option.empty();
    }

    protected InstancePropertyEntity newInstancePropertyEntity(Identifier<?> instanceId, FlowInstanceProperty property) {
        Identifier newId = this.idGenerator.generateId();
        Long created = new Date().getTime();
        return new InstancePropertyEntity().withId(newId.stringValue()).withCreated(created).withInstanceId(instanceId.stringValue()).withPropertyKey(property.getKey());
    }

    public FlowInstanceProperties<?, FlowInstanceProperty<?>> getProperties(Identifier<?> instanceId) {
        return new ExecutionProperties().from((Collection)((JPAQuery)((JPAQuery)this.database.query().from((EntityPath)QInstancePropertyEntity.instancePropertyEntity)).where((Predicate)QInstancePropertyEntity.instancePropertyEntity.instanceId.eq((Object)instanceId.stringValue()))).list((Expression)QInstancePropertyEntity.instancePropertyEntity));
    }

    protected InstancePropertyEntity withPropertyValue(InstancePropertyEntity entity, FlowInstanceProperty<?> property) {
        if (property instanceof StringProperty) {
            return entity.withStringValue((String)((StringProperty)property).getValue()).withValueType(InstancePropertyEntity.ValueType.STRING.typeName());
        }
        if (property instanceof LongProperty) {
            return entity.withLongValue((Long)((LongProperty)property).getValue()).withValueType(InstancePropertyEntity.ValueType.LONG.typeName());
        }
        if (property instanceof BooleanProperty) {
            return entity.withLongValue(this.boolToLong((BooleanProperty)property)).withValueType(InstancePropertyEntity.ValueType.BOOLEAN.typeName());
        }
        if (property instanceof IntProperty) {
            return entity.withLongValue(((Integer)((IntProperty)property).getValue()).longValue()).withValueType(InstancePropertyEntity.ValueType.INT.typeName());
        }
        if (property instanceof FloatProperty) {
            return entity.withDoubleValue(Double.valueOf(((Float)((FloatProperty)property).getValue()).floatValue())).withValueType(InstancePropertyEntity.ValueType.FLOAT.typeName());
        }
        if (property instanceof DoubleProperty) {
            return entity.withDoubleValue((Double)((DoubleProperty)property).getValue()).withValueType(InstancePropertyEntity.ValueType.DOUBLE.typeName());
        }
        if (property instanceof DateProperty) {
            return entity.withLongValue(((Date)((DateProperty)property).getValue()).getTime()).withValueType(InstancePropertyEntity.ValueType.DATE.typeName());
        }
        byte[] serialized = this.getSerializer().serialize(property.getValue());
        Blob blob = this.database.unwrap(Session.class).getLobHelper().createBlob(serialized);
        return entity.withBlobValue(blob).withValueType(InstancePropertyEntity.ValueType.SERIALIZABLE.typeName());
    }

    private long boolToLong(BooleanProperty property) {
        return (Boolean)property.getValue() != false ? 1L : 0L;
    }

    public ObjectSerializer getSerializer() {
        return this.serializer;
    }
}

