/*
 * Decompiled with CFR 0.152.
 */
package brainslug.jpa;

import brainslug.flow.definition.Identifier;
import brainslug.flow.execution.instance.InstanceStore;
import brainslug.flow.expression.EqualsExpression;
import brainslug.flow.expression.Property;
import brainslug.flow.expression.Value;
import brainslug.flow.instance.FlowInstance;
import brainslug.flow.instance.FlowInstanceSelector;
import brainslug.jpa.Database;
import brainslug.jpa.entity.FlowInstanceEntity;
import brainslug.jpa.entity.QFlowInstanceEntity;
import brainslug.jpa.entity.QInstancePropertyEntity;
import brainslug.util.IdGenerator;
import brainslug.util.Option;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.expr.BooleanExpression;
import java.util.Date;
import java.util.List;

public class JpaInstanceStore
implements InstanceStore {
    Database database;
    IdGenerator idGenerator;

    public JpaInstanceStore(Database database, IdGenerator idGenerator) {
        this.database = database;
        this.idGenerator = idGenerator;
    }

    public List<? extends FlowInstance> findInstances(FlowInstanceSelector instanceSelector) {
        JPAQuery instanceQuery = (JPAQuery)this.database.query().from((EntityPath)QFlowInstanceEntity.flowInstanceEntity);
        return this.filterByInstance(instanceSelector, this.filterByDefinitionId(instanceSelector, this.filterByProperties(instanceSelector, instanceQuery))).list((Expression)QFlowInstanceEntity.flowInstanceEntity);
    }

    private JPAQuery filterByProperties(FlowInstanceSelector instanceSelector, JPAQuery instanceQuery) {
        for (EqualsExpression propertyExpression : instanceSelector.properties()) {
            QInstancePropertyEntity instanceProperty = (QInstancePropertyEntity)QFlowInstanceEntity.flowInstanceEntity.properties.any();
            instanceQuery.where((Predicate)instanceProperty.stringValue.eq(((Value)propertyExpression.getRight()).getValue()).and((Predicate)instanceProperty.propertyKey.eq((Object)((Identifier)((Property)propertyExpression.getLeft()).getValue()).stringValue())));
        }
        return instanceQuery;
    }

    private JPAQuery filterByDefinitionId(FlowInstanceSelector instanceSelector, JPAQuery instanceQuery) {
        if (instanceSelector.definitionId().isPresent()) {
            BooleanExpression matchesDefinitionId = QFlowInstanceEntity.flowInstanceEntity.definitionId.eq((Object)((Identifier)instanceSelector.definitionId().get()).stringValue());
            return (JPAQuery)instanceQuery.where((Predicate)matchesDefinitionId);
        }
        return instanceQuery;
    }

    private JPAQuery filterByInstance(FlowInstanceSelector instanceSelector, JPAQuery instanceQuery) {
        if (instanceSelector.instanceId().isPresent()) {
            BooleanExpression matchesInstanceId = QFlowInstanceEntity.flowInstanceEntity.id.eq((Object)((Identifier)instanceSelector.instanceId().get()).stringValue());
            return (JPAQuery)instanceQuery.where((Predicate)matchesInstanceId);
        }
        return instanceQuery;
    }

    public Option<? extends FlowInstance> findInstance(FlowInstanceSelector instanceSelector) {
        List<? extends FlowInstance> instances = this.findInstances(instanceSelector);
        if (instances.isEmpty()) {
            return Option.empty();
        }
        return Option.of((Object)instances.get(0));
    }

    public FlowInstance createInstance(Identifier definitionId) {
        Identifier identifier = this.idGenerator.generateId();
        FlowInstanceEntity newInstance = new FlowInstanceEntity().withId(identifier.stringValue()).withCreated(new Date().getTime()).withDefinitionId(definitionId.stringValue());
        this.database.insertOrUpdate(newInstance);
        return newInstance;
    }

    public FlowInstanceEntity findInstanceById(Identifier<?> instanceId) {
        return (FlowInstanceEntity)((JPAQuery)((JPAQuery)this.database.query().from((EntityPath)QFlowInstanceEntity.flowInstanceEntity)).where((Predicate)QFlowInstanceEntity.flowInstanceEntity.id.eq((Object)instanceId.stringValue()))).singleResult((Expression)QFlowInstanceEntity.flowInstanceEntity);
    }
}

