/*
 * Decompiled with CFR 0.152.
 */
package brainslug.jpa;

import brainslug.flow.definition.Identifier;
import brainslug.flow.execution.async.AsyncTrigger;
import brainslug.flow.execution.async.AsyncTriggerErrorDetails;
import brainslug.flow.execution.async.AsyncTriggerQuery;
import brainslug.flow.execution.async.AsyncTriggerStore;
import brainslug.jpa.Database;
import brainslug.jpa.entity.AsyncTaskEntity;
import brainslug.jpa.entity.AsyncTaskErrorDetailsEntity;
import brainslug.jpa.entity.QAsyncTaskEntity;
import brainslug.util.IdGenerator;
import brainslug.util.IdUtil;
import brainslug.util.Option;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.ConstructorExpression;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Predicate;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaAsyncTriggerStore
implements AsyncTriggerStore {
    private Logger log = LoggerFactory.getLogger(JpaAsyncTriggerStore.class);
    protected final Database database;
    protected final IdGenerator idGenerator;

    public JpaAsyncTriggerStore(Database database, IdGenerator idGenerator) {
        this.database = database;
        this.idGenerator = idGenerator;
    }

    public AsyncTrigger storeTrigger(AsyncTrigger asyncTrigger) {
        Option<AsyncTrigger> existingTask = this.getTrigger(asyncTrigger.getNodeId(), asyncTrigger.getInstanceId(), asyncTrigger.getDefinitionId());
        if (existingTask.isPresent()) {
            return this.updatedTask((AsyncTrigger)existingTask.get(), asyncTrigger);
        }
        return this.insertTask(asyncTrigger, this.generateId(), this.getCreatedDate());
    }

    public AsyncTrigger updateTrigger(AsyncTrigger asyncTrigger) {
        Option<AsyncTrigger> existingTask = this.getTrigger(asyncTrigger.getNodeId(), asyncTrigger.getInstanceId(), asyncTrigger.getDefinitionId());
        if (existingTask.isPresent()) {
            return this.updatedTask((AsyncTrigger)existingTask.get(), asyncTrigger);
        }
        throw new IllegalArgumentException("trigger cant be updated, does not exist: " + asyncTrigger);
    }

    protected long getCreatedDate() {
        return new Date().getTime();
    }

    protected Identifier generateId() {
        return this.idGenerator.generateId();
    }

    protected AsyncTrigger insertTask(AsyncTrigger asyncTrigger, Identifier asyncTaskId, long createdDate) {
        this.log.debug("inserting async task: {}", (Object)asyncTrigger);
        AsyncTaskEntity taskEntity = new AsyncTaskEntity().withCreated(createdDate).withId(asyncTaskId.stringValue()).withDueDate(asyncTrigger.getDueDate()).withDefinitionId(asyncTrigger.getDefinitionId().stringValue()).withInstanceId(asyncTrigger.getInstanceId().stringValue()).withMaxRetries(asyncTrigger.getMaxRetries()).withRetries(asyncTrigger.getRetries()).withTaskNodeId(asyncTrigger.getNodeId().stringValue());
        this.database.insertOrUpdate(taskEntity);
        this.database.flush();
        return asyncTrigger.withId(IdUtil.id((String)taskEntity.getId())).withVersion(taskEntity.getVersion().longValue()).withCreatedDate(createdDate);
    }

    private AsyncTaskErrorDetailsEntity mapErrorDetails(AsyncTaskErrorDetailsEntity errorDetailsEntity, AsyncTriggerErrorDetails asyncTriggerErrorDetails) {
        return errorDetailsEntity.withExceptionType(asyncTriggerErrorDetails.getException().getClass().getName()).withMessage(asyncTriggerErrorDetails.getException().getMessage()).withStackTrace(this.stackTraceToString(asyncTriggerErrorDetails.getException()));
    }

    String stackTraceToString(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        return sw.toString();
    }

    protected AsyncTrigger updatedTask(AsyncTrigger existingTask, AsyncTrigger updatedTask) {
        this.log.debug("updating async task: {}", (Object)existingTask);
        AsyncTaskEntity taskEntity = this.getTaskEntity((Identifier)existingTask.getId().get());
        taskEntity.withRetries(updatedTask.getRetries()).withMaxRetries(updatedTask.getMaxRetries()).withDueDate(updatedTask.getDueDate());
        this.addErrorDetails((Option<AsyncTriggerErrorDetails>)updatedTask.getErrorDetails(), taskEntity);
        this.database.insertOrUpdate(taskEntity);
        this.database.flush();
        return updatedTask.withVersion(taskEntity.getVersion().longValue());
    }

    private void addErrorDetails(Option<AsyncTriggerErrorDetails> errorDetails, AsyncTaskEntity taskEntity) {
        if (taskEntity.getErrorDetails() != null && errorDetails.isPresent()) {
            this.mapErrorDetails(taskEntity.getErrorDetails(), (AsyncTriggerErrorDetails)errorDetails.get());
        } else if (errorDetails.isPresent()) {
            taskEntity.withErrorDetails(this.createErrorDetails(errorDetails));
        }
    }

    private AsyncTaskErrorDetailsEntity createErrorDetails(Option<AsyncTriggerErrorDetails> errorDetails) {
        AsyncTaskErrorDetailsEntity errorDetailsEntity = new AsyncTaskErrorDetailsEntity().withId(this.idGenerator.generateId().stringValue()).withCreated(new Date().getTime());
        this.mapErrorDetails(errorDetailsEntity, (AsyncTriggerErrorDetails)errorDetails.get());
        this.database.insertOrUpdate(errorDetailsEntity);
        return errorDetailsEntity;
    }

    public boolean removeTrigger(AsyncTrigger asyncTrigger) {
        this.log.debug("removing async task: {}", (Object)asyncTrigger);
        Long deletedCount = this.database.delete((EntityPath<?>)QAsyncTaskEntity.asyncTaskEntity).where(new Predicate[]{QAsyncTaskEntity.asyncTaskEntity.id.eq((Object)((Identifier)asyncTrigger.getId().get()).stringValue())}).execute();
        return deletedCount > 0L;
    }

    public List<AsyncTrigger> getTriggers(AsyncTriggerQuery taskQuery) {
        JPAQuery query = (JPAQuery)((JPAQuery)this.database.query().from((EntityPath)QAsyncTaskEntity.asyncTaskEntity)).limit(taskQuery.getMaxCount());
        return this.queryWithOptionalDueDate(query, taskQuery).list(this.asyncTaskConstructor());
    }

    JPAQuery queryWithOptionalDueDate(JPAQuery jpaQuery, AsyncTriggerQuery taskQuery) {
        if (taskQuery.getOverdueDate().isPresent()) {
            long dueDate = ((Date)taskQuery.getOverdueDate().get()).getTime();
            return (JPAQuery)jpaQuery.where((Predicate)QAsyncTaskEntity.asyncTaskEntity.dueDate.loe((Number)dueDate));
        }
        return jpaQuery;
    }

    protected ConstructorExpression<AsyncTrigger> asyncTaskConstructor() {
        return ConstructorExpression.create(AsyncTrigger.class, (Expression[])new Expression[]{QAsyncTaskEntity.asyncTaskEntity.id, QAsyncTaskEntity.asyncTaskEntity.taskNodeId, QAsyncTaskEntity.asyncTaskEntity.instanceId, QAsyncTaskEntity.asyncTaskEntity.definitionId, QAsyncTaskEntity.asyncTaskEntity.created, QAsyncTaskEntity.asyncTaskEntity.dueDate, QAsyncTaskEntity.asyncTaskEntity.retries, QAsyncTaskEntity.asyncTaskEntity.maxRetries, QAsyncTaskEntity.asyncTaskEntity.version});
    }

    public Option<AsyncTrigger> getTrigger(Identifier taskNodeId, Identifier instanceId, Identifier definitionId) {
        return Option.of((Object)((JPAQuery)((JPAQuery)this.database.query().from((EntityPath)QAsyncTaskEntity.asyncTaskEntity)).where(new Predicate[]{QAsyncTaskEntity.asyncTaskEntity.taskNodeId.eq((Object)taskNodeId.stringValue()), QAsyncTaskEntity.asyncTaskEntity.instanceId.eq((Object)instanceId.stringValue()), QAsyncTaskEntity.asyncTaskEntity.definitionId.eq((Object)definitionId.stringValue())})).singleResult(this.asyncTaskConstructor()));
    }

    protected AsyncTaskEntity getTaskEntity(Identifier id) {
        return (AsyncTaskEntity)((JPAQuery)((JPAQuery)this.database.query().from((EntityPath)QAsyncTaskEntity.asyncTaskEntity)).where((Predicate)QAsyncTaskEntity.asyncTaskEntity.id.eq((Object)id.stringValue()))).singleResult((Expression)QAsyncTaskEntity.asyncTaskEntity);
    }
}

