/*
 * Decompiled with CFR 0.152.
 */
package brainslug.jdbc;

import brainslug.flow.context.IdGenerator;
import brainslug.flow.execution.Token;
import brainslug.flow.execution.TokenList;
import brainslug.flow.execution.TokenStore;
import brainslug.flow.model.Identifier;
import brainslug.jdbc.Database;
import brainslug.jdbc.tables.QFlowInstance;
import brainslug.jdbc.tables.QFlowToken;
import brainslug.util.Option;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.sql.SQLQuery;
import com.mysema.query.types.ConstructorExpression;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import java.util.Date;

public class JdbcTokenStore
implements TokenStore {
    private final Database database;
    private final IdGenerator idGenerator;

    public JdbcTokenStore(Database database, IdGenerator idGenerator) {
        this.database = database;
        this.idGenerator = idGenerator;
    }

    public TokenList getInstanceTokens(Identifier instanceId) {
        return new TokenList(((SQLQuery)((SQLQuery)this.database.query().from((Expression)QFlowToken.flowToken)).where((Predicate)QFlowToken.flowToken.flowInstanceId.eq((Object)instanceId.stringValue()))).list((Expression)ConstructorExpression.create(Token.class, (Expression[])new Expression[]{QFlowToken.flowToken.id, QFlowToken.flowToken.currentNode, QFlowToken.flowToken.sourceNode, QFlowToken.flowToken.flowInstanceId, QFlowToken.flowToken.isDead})));
    }

    public TokenList getNodeTokens(Identifier nodeId, Identifier instanceId) {
        return new TokenList(((SQLQuery)((SQLQuery)this.database.query().from((Expression)QFlowToken.flowToken)).where(new Predicate[]{QFlowToken.flowToken.flowInstanceId.eq((Object)instanceId.stringValue()), QFlowToken.flowToken.currentNode.eq((Object)nodeId.stringValue())})).list((Expression)ConstructorExpression.create(Token.class, (Expression[])new Expression[]{QFlowToken.flowToken.id, QFlowToken.flowToken.currentNode, QFlowToken.flowToken.sourceNode, QFlowToken.flowToken.flowInstanceId, QFlowToken.flowToken.isDead})));
    }

    public Token addToken(Identifier instanceId, Identifier nodeId, Option<Identifier> sourceNodeId) {
        Identifier tokenId = this.idGenerator.generateId();
        this.database.insert((RelationalPath<?>)QFlowToken.flowToken).columns(new Path[]{QFlowToken.flowToken.id, QFlowToken.flowToken.currentNode, QFlowToken.flowToken.sourceNode, QFlowToken.flowToken.flowInstanceId, QFlowToken.flowToken.created}).values(new Object[]{tokenId.stringValue(), nodeId.stringValue(), sourceNodeId.orElse(null), instanceId.stringValue(), new Date().getTime()}).execute();
        return new Token(tokenId, nodeId, sourceNodeId, Option.of((Object)instanceId), false);
    }

    public void removeToken(Identifier instanceId, Identifier tokenId) {
        this.database.update((RelationalPath<?>)QFlowToken.flowToken).set(QFlowToken.flowToken.isDead, (Object)1).where(new Predicate[]{QFlowToken.flowToken.id.eq((Object)tokenId.stringValue()), QFlowToken.flowToken.flowInstanceId.eq((Object)instanceId.stringValue())}).execute();
    }

    public Identifier createInstance(Identifier definitionId) {
        Identifier identifier = this.idGenerator.generateId();
        this.database.insert((RelationalPath<?>)QFlowInstance.flowInstance).columns(new Path[]{QFlowInstance.flowInstance.id, QFlowInstance.flowInstance.definitionId, QFlowInstance.flowInstance.created}).values(new Object[]{identifier.stringValue(), definitionId.stringValue(), new Date().getTime()}).execute();
        return identifier;
    }
}

