package brainslug;

import brainslug.flow.builder.FlowBuilder;
import brainslug.flow.context.ExecutionContext;
import brainslug.flow.node.task.Task;

public class TaskExamples {

  public static
  //# tag::example-service[]
  class ExampleService {
    public void doSomething() {
      System.out.println("Done!");
    }
  }
  //# end::example-service[]

  //# tag::inline-task[]
  FlowBuilder inlineTaskFlow = new FlowBuilder() {
    @Override
    public void define() {
      flowId(id("task_flow"));

      start(event(id("start")).display("Start"))
        .execute(task(id("task"), new Task() {
          @Override
          public void execute(ExecutionContext ctx) {
            ctx.service(ExampleService.class).doSomething();
          }
        }).display("Do Something"))
        .end(event(id("end")).display("End"));
    }
  };
  //# end::inline-task[]

}
