/*
 * Decompiled with CFR 0.152.
 */
package brainslug.bpmn;

import brainslug.flow.builder.FlowBuilder;
import brainslug.flow.definition.FlowDefinition;
import brainslug.flow.definition.Identifier;
import brainslug.flow.expression.Expression;
import brainslug.flow.node.ChoiceDefinition;
import brainslug.flow.node.EventDefinition;
import brainslug.flow.node.FlowNodeDefinition;
import brainslug.flow.node.JoinDefinition;
import brainslug.flow.node.ParallelDefinition;
import brainslug.flow.node.TaskDefinition;
import brainslug.flow.node.event.AbstractEventDefinition;
import brainslug.flow.node.event.EndEvent;
import brainslug.flow.node.event.IntermediateEvent;
import brainslug.flow.path.FlowEdgeDefinition;
import brainslug.flow.path.ThenDefinition;
import brainslug.juel.JuelExpression;
import brainslug.util.Option;
import brainslug.util.Preconditions;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.ExclusiveGateway;
import org.camunda.bpm.model.bpmn.instance.FlowElement;
import org.camunda.bpm.model.bpmn.instance.IntermediateCatchEvent;
import org.camunda.bpm.model.bpmn.instance.ParallelGateway;
import org.camunda.bpm.model.bpmn.instance.Process;
import org.camunda.bpm.model.bpmn.instance.SequenceFlow;
import org.camunda.bpm.model.bpmn.instance.StartEvent;
import org.camunda.bpm.model.bpmn.instance.Task;
import org.camunda.bpm.model.xml.instance.DomElement;

public class BpmnModelImporter {
    public Collection<FlowDefinition> fromBpmnXml(InputStream bpmnStream) {
        BpmnModelInstance modelInstance = Bpmn.readModelFromStream((InputStream)bpmnStream);
        Collection processes = modelInstance.getModelElementsByType(Process.class);
        ArrayList<FlowDefinition> flowDefinitions = new ArrayList<FlowDefinition>();
        for (Process process : processes) {
            flowDefinitions.add(new BpmnProcessFlowBuilder(process).getDefinition());
        }
        return flowDefinitions;
    }

    private Option<DomElement> uniqueChild(DomElement parent, String namespace, String tag) {
        List childElements = parent.getChildElementsByNameNs(namespace, tag);
        if (childElements.isEmpty()) {
            return Option.empty();
        }
        return Option.of((Object)Preconditions.singleItem((Collection)childElements));
    }

    class BpmnProcessFlowBuilder
    extends FlowBuilder {
        final Process bpmnProcess;

        public BpmnProcessFlowBuilder(Process bpmnProcess) {
            this.bpmnProcess = bpmnProcess;
        }

        public void define() {
            this.convertProcessToFlowDefinition();
        }

        void convertProcessToFlowDefinition() {
            ArrayList<SequenceFlow> sequenceFlows = new ArrayList<SequenceFlow>();
            for (FlowElement flowElement : this.bpmnProcess.getFlowElements()) {
                this.addFlowNode(this.definition, flowElement, sequenceFlows);
            }
            this.createEdges(sequenceFlows, this.definition);
        }

        private FlowDefinition addFlowNode(FlowDefinition flowDefinition, FlowElement flowElement, List<SequenceFlow> sequenceFlows) {
            if (flowElement instanceof StartEvent) {
                this.start((AbstractEventDefinition)BpmnProcessFlowBuilder.event((Identifier)BpmnProcessFlowBuilder.id((String)flowElement.getId())).display(flowElement.getName()));
            } else if (flowElement instanceof Task) {
                this.handleTask(flowDefinition, (Task)flowElement);
            } else if (flowElement instanceof IntermediateCatchEvent) {
                flowDefinition.addNode((FlowNodeDefinition)((EventDefinition)BpmnProcessFlowBuilder.event((Identifier)BpmnProcessFlowBuilder.id((String)flowElement.getId())).display(flowElement.getName())).with((Object)new IntermediateEvent()));
            } else if (flowElement instanceof org.camunda.bpm.model.bpmn.instance.EndEvent) {
                flowDefinition.addNode((FlowNodeDefinition)((EventDefinition)BpmnProcessFlowBuilder.event((Identifier)BpmnProcessFlowBuilder.id((String)flowElement.getId())).display(flowElement.getName())).with((Object)new EndEvent()));
            } else if (flowElement instanceof SequenceFlow) {
                sequenceFlows.add((SequenceFlow)flowElement);
            } else if (flowElement instanceof ExclusiveGateway) {
                flowDefinition.addNode(((ChoiceDefinition)new ChoiceDefinition(flowDefinition).id(flowElement.getId())).display(flowElement.getName()));
            } else if (flowElement instanceof ParallelGateway) {
                if (((ParallelGateway)flowElement).getPreviousNodes().count() < 2) {
                    flowDefinition.addNode(((ParallelDefinition)new ParallelDefinition(flowDefinition).id(flowElement.getId())).display(flowElement.getName()));
                } else {
                    flowDefinition.addNode(((JoinDefinition)new JoinDefinition().id(flowElement.getId())).display(flowElement.getName()));
                }
            } else {
                throw new IllegalArgumentException("can't handle flow element: " + flowElement);
            }
            return flowDefinition;
        }

        void handleTask(FlowDefinition flowDefinition, Task bpmnTask) {
            TaskDefinition task = (TaskDefinition)BpmnProcessFlowBuilder.task((Identifier)BpmnProcessFlowBuilder.id((String)bpmnTask.getId())).display(bpmnTask.getName());
            Option<DomElement> brainslugTask = this.getBrainslugTaskElement(bpmnTask);
            this.handleBrainslugTaskElement(brainslugTask, bpmnTask, task);
            flowDefinition.addNode((FlowNodeDefinition)task);
        }

        private void handleBrainslugTaskElement(Option<DomElement> brainslugTask, Task bpmnTask, TaskDefinition taskDefinition) {
            if (!brainslugTask.isPresent()) {
                return;
            }
            Option<String> delegate = this.brainslugDelegate((DomElement)brainslugTask.get());
            if (delegate.isPresent()) {
                taskDefinition.delegate(this.getClassFor((String)delegate.get()));
            }
            taskDefinition.async(this.isAsync((DomElement)brainslugTask.get()).booleanValue());
            taskDefinition.retryAsync(this.isRetryAsync((DomElement)brainslugTask.get()));
            this.addConfigParametersIfPresent((DomElement)brainslugTask.get(), taskDefinition);
            this.addScriptIfPresent((DomElement)brainslugTask.get(), taskDefinition);
        }

        private boolean isRetryAsync(DomElement brainslugTask) {
            String retryAsyncAttribute = "retryAsync";
            return brainslugTask.hasAttribute(retryAsyncAttribute) && Boolean.parseBoolean(brainslugTask.getAttribute(retryAsyncAttribute));
        }

        private void addScriptIfPresent(DomElement brainslugTask, TaskDefinition task) {
            Option textContent;
            Option scriptElement = BpmnModelImporter.this.uniqueChild(brainslugTask, "http://brainslug.it/bpmn", "script");
            if (scriptElement.isPresent() && (textContent = Option.of((Object)((DomElement)scriptElement.get()).getTextContent())).isPresent()) {
                task.script(Preconditions.notEmpty((String)((DomElement)scriptElement.get()).getAttribute("language")), Preconditions.notEmpty((String)((String)textContent.get()).trim()));
            }
        }

        private void addConfigParametersIfPresent(DomElement brainslugTask, TaskDefinition task) {
            Option configElement = BpmnModelImporter.this.uniqueChild(brainslugTask, "http://brainslug.it/bpmn", "configuration");
            if (configElement.isPresent()) {
                Map<String, String> configurationValues = this.getConfigurationValues((DomElement)configElement.get());
                task.withConfiguration().parameters(configurationValues);
            }
        }

        private Map<String, String> getConfigurationValues(DomElement configuration) {
            HashMap<String, String> configValues = new HashMap<String, String>();
            for (DomElement parameter : configuration.getChildElementsByNameNs("http://brainslug.it/bpmn", "parameter")) {
                configValues.put(Preconditions.notEmpty((String)parameter.getAttribute("name")), (String)Preconditions.notNull((Object)parameter.getAttribute("value")));
            }
            return configValues;
        }

        private Option<String> brainslugDelegate(DomElement brainslugTask) {
            return Option.of((Object)brainslugTask.getAttribute("delegate"));
        }

        private Boolean isAsync(DomElement brainslugTask) {
            String asyncAttribute = "async";
            return brainslugTask.hasAttribute(asyncAttribute) && Boolean.parseBoolean(brainslugTask.getAttribute(asyncAttribute));
        }

        private Option<DomElement> getBrainslugTaskElement(Task bpmnTask) {
            if (bpmnTask.getExtensionElements() == null) {
                return Option.empty();
            }
            return BpmnModelImporter.this.uniqueChild(bpmnTask.getExtensionElements().getDomElement(), "http://brainslug.it/bpmn", "task");
        }

        private Class<?> getClassFor(String className) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        void createEdges(List<SequenceFlow> sequenceFlows, FlowDefinition flowDefinition) {
            for (SequenceFlow sequenceFlow : sequenceFlows) {
                FlowNodeDefinition source = flowDefinition.getNode(BpmnProcessFlowBuilder.id((String)sequenceFlow.getSource().getId()));
                FlowNodeDefinition target = flowDefinition.getNode(BpmnProcessFlowBuilder.id((String)sequenceFlow.getTarget().getId()));
                this.handleSequenceFlow(sequenceFlow, source, target);
                this.addEdge(source, target);
            }
        }

        private void addEdge(FlowNodeDefinition<?> source, FlowNodeDefinition<?> target) {
            FlowEdgeDefinition edge = new FlowEdgeDefinition(source, target);
            source.getOutgoing().add(edge);
            target.getIncoming().add(edge);
        }

        private void handleSequenceFlow(SequenceFlow sequenceFlow, FlowNodeDefinition<?> source, FlowNodeDefinition<?> target) {
            if (source instanceof ChoiceDefinition) {
                ChoiceDefinition choiceDefinition = (ChoiceDefinition)source;
                ExclusiveGateway exclusiveGateway = (ExclusiveGateway)sequenceFlow.getSource();
                if (exclusiveGateway.getDefault() != null && exclusiveGateway.getDefault().getId().equals(sequenceFlow.getId())) {
                    choiceDefinition.setOtherwisePath(new ThenDefinition((Expression)new JuelExpression("true"), this.definition, choiceDefinition));
                } else {
                    choiceDefinition.when(this.getExpression(sequenceFlow)).getPathNodes().add(target);
                }
            }
        }

        private Expression getExpression(SequenceFlow sequenceFlow) {
            if (sequenceFlow.getConditionExpression() != null) {
                return new JuelExpression(sequenceFlow.getConditionExpression().getTextContent().replaceFirst("^\\$\\{", "").replaceFirst("\\}$", ""));
            }
            return new JuelExpression("false");
        }
    }
}

