/*
 * Decompiled with CFR 0.152.
 */
package brainslug.bpmn;

import brainslug.bpmn.JuelExpression;
import brainslug.bpmn.task.UserTaskDefinition;
import brainslug.flow.builder.FlowBuilder;
import brainslug.flow.definition.FlowDefinition;
import brainslug.flow.expression.EqualsTrueExpression;
import brainslug.flow.node.ChoiceDefinition;
import brainslug.flow.node.FlowNodeDefinition;
import brainslug.flow.node.JoinDefinition;
import brainslug.flow.node.MergeDefinition;
import brainslug.flow.node.ParallelDefinition;
import brainslug.flow.node.event.AbstractEventDefinition;
import brainslug.flow.node.event.IntermediateEvent;
import brainslug.flow.node.event.StartEvent;
import brainslug.flow.node.task.AbstractTaskDefinition;
import brainslug.flow.node.task.TaskScript;
import brainslug.flow.path.AndDefinition;
import brainslug.flow.path.FlowEdgeDefinition;
import brainslug.flow.path.FlowPathDefinition;
import brainslug.flow.path.ThenDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.IntermediateCatchEvent;
import org.activiti.bpmn.model.ParallelGateway;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.bpmn.model.UserTask;

public class BpmnModelExporter {
    List<SequenceFlow> sequenceFlows = new ArrayList<SequenceFlow>();

    public BpmnModel toBpmnModel(FlowBuilder flowBuilder) {
        return this.toBpmnModel(flowBuilder.getDefinition());
    }

    public BpmnModel toBpmnModel(FlowDefinition definition) {
        Process process = new Process();
        process.setId(definition.getId().toString());
        process.setName(definition.getName());
        BpmnModel model = new BpmnModel();
        model.addNamespace("brainslug", "http://brainslug.it/bpmn");
        model.addProcess(process);
        this.addNodes(process, definition);
        this.addFlows(process);
        return model;
    }

    public String toBpmnXml(FlowBuilder flowBuilder) {
        return this.toBpmnXml(flowBuilder.getDefinition());
    }

    public String toBpmnXml(FlowDefinition definition) {
        BpmnXMLConverter bpmnXMLConverter = new BpmnXMLConverter();
        try {
            return new String(bpmnXMLConverter.convertToXML(this.toBpmnModel(definition)), "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toBpmnXml(BpmnModel bpmnModel) {
        BpmnXMLConverter bpmnXMLConverter = new BpmnXMLConverter();
        try {
            return new String(bpmnXMLConverter.convertToXML(bpmnModel), "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addFlows(Process process) {
        for (SequenceFlow flow : this.sequenceFlows) {
            process.addFlowElement((FlowElement)flow);
        }
    }

    private void addNodes(Process process, FlowDefinition definition) {
        for (FlowNodeDefinition node : definition.getNodes()) {
            if (node instanceof AbstractEventDefinition) {
                this.addEvent((AbstractEventDefinition)node, process);
                this.collectOutgoingFlows(node);
                continue;
            }
            if (node instanceof AbstractTaskDefinition) {
                this.addTask((AbstractTaskDefinition)node, process);
                this.collectOutgoingFlows(node);
                continue;
            }
            if (node instanceof ChoiceDefinition) {
                this.addChoice((ChoiceDefinition)node, process);
                continue;
            }
            if (node instanceof ParallelDefinition) {
                this.addParallel((ParallelDefinition)node, process);
                continue;
            }
            if (node instanceof MergeDefinition) {
                this.addMerge((MergeDefinition)node, process);
                this.collectOutgoingFlows(node);
                continue;
            }
            if (node instanceof JoinDefinition) {
                this.addJoin((JoinDefinition)node, process);
                this.collectOutgoingFlows(node);
                continue;
            }
            throw new UnsupportedOperationException("unable  to transform " + node);
        }
    }

    private void addJoin(JoinDefinition node, Process process) {
        ParallelGateway gateway = this.createParallelGateway((FlowNodeDefinition)node);
        process.addFlowElement((FlowElement)gateway);
    }

    private void addParallel(ParallelDefinition parallel, Process process) {
        ParallelGateway parallelGateway = this.createParallelGateway((FlowNodeDefinition)parallel);
        process.addFlowElement((FlowElement)parallelGateway);
        for (AndDefinition andDefinition : parallel.getParallelPaths()) {
            this.addIncomingSequenceFlowToFirstPathNode((FlowElement)parallelGateway, (FlowPathDefinition<?>)andDefinition);
        }
    }

    private ParallelGateway createParallelGateway(FlowNodeDefinition parallel) {
        ParallelGateway parallelGateway = new ParallelGateway();
        parallelGateway.setId(parallel.getId().toString());
        return parallelGateway;
    }

    private void addChoice(ChoiceDefinition choice, Process process) {
        ExclusiveGateway gateway = this.createExclusiveGateway((FlowNodeDefinition)choice);
        process.addFlowElement((FlowElement)gateway);
        for (ThenDefinition then : choice.getThenPaths()) {
            SequenceFlow flow = this.addIncomingSequenceFlowToFirstPathNode((FlowElement)gateway, (FlowPathDefinition<?>)then);
            flow.setConditionExpression(this.getExpressionString(then));
        }
    }

    private String getExpressionString(ThenDefinition then) {
        if (then.getExpression() instanceof EqualsTrueExpression && ((EqualsTrueExpression)then.getExpression()).getLeft() instanceof JuelExpression) {
            return "${" + (String)((JuelExpression)((EqualsTrueExpression)then.getExpression()).getLeft()).getValue() + "}";
        }
        return then.getExpression().toString();
    }

    private SequenceFlow addIncomingSequenceFlowToFirstPathNode(FlowElement flowElement, FlowPathDefinition<?> then) {
        SequenceFlow flow = this.createSequenceFlow(flowElement.getId(), ((FlowNodeDefinition)then.getPathNodes().getFirst()).getId().toString());
        this.sequenceFlows.add(flow);
        return flow;
    }

    private void addMerge(MergeDefinition merge, Process process) {
        ExclusiveGateway gateway = this.createExclusiveGateway((FlowNodeDefinition)merge);
        process.addFlowElement((FlowElement)gateway);
    }

    private void addTask(AbstractTaskDefinition task, Process process) {
        if (task instanceof UserTaskDefinition) {
            process.addFlowElement((FlowElement)this.createUserTask(task));
        } else {
            process.addFlowElement((FlowElement)this.createServiceTask(task));
        }
    }

    private void addEvent(AbstractEventDefinition event, Process process) {
        if (event.is(StartEvent.class)) {
            process.addFlowElement((FlowElement)this.createStartEvent(event));
        } else if (event.is(brainslug.flow.node.event.EndEvent.class)) {
            process.addFlowElement((FlowElement)this.createEndEvent(event));
        } else if (event.is(IntermediateEvent.class)) {
            process.addFlowElement(this.createIntermediateCatchEvent(event));
        } else {
            throw new UnsupportedOperationException("unable to transform " + event);
        }
    }

    private FlowElement createIntermediateCatchEvent(AbstractEventDefinition event) {
        IntermediateCatchEvent catchEvent = new IntermediateCatchEvent();
        catchEvent.setId(event.getId().toString());
        catchEvent.setName(event.getDisplayName());
        return catchEvent;
    }

    private void collectOutgoingFlows(FlowNodeDefinition<?> node) {
        for (FlowEdgeDefinition edge : node.getOutgoing()) {
            this.sequenceFlows.add(this.createSequenceFlow(edge));
        }
    }

    protected SequenceFlow createSequenceFlow(FlowEdgeDefinition edge) {
        return this.createSequenceFlow(edge.getSource().getId().toString(), edge.getTarget().getId().toString());
    }

    protected SequenceFlow createSequenceFlow(String source, String target) {
        SequenceFlow flow = new SequenceFlow();
        flow.setSourceRef(source);
        flow.setTargetRef(target);
        return flow;
    }

    protected org.activiti.bpmn.model.StartEvent createStartEvent(AbstractEventDefinition event) {
        org.activiti.bpmn.model.StartEvent startEvent = new org.activiti.bpmn.model.StartEvent();
        startEvent.setId(event.getId().toString());
        startEvent.setName(event.getDisplayName());
        return startEvent;
    }

    protected ExclusiveGateway createExclusiveGateway(FlowNodeDefinition choiceDefinition) {
        ExclusiveGateway exclusiveGateway = new ExclusiveGateway();
        exclusiveGateway.setId(choiceDefinition.getId().toString());
        exclusiveGateway.setName(choiceDefinition.getDisplayName());
        return exclusiveGateway;
    }

    protected EndEvent createEndEvent(AbstractEventDefinition event) {
        EndEvent endEvent = new EndEvent();
        endEvent.setId(event.getId().toString());
        endEvent.setName(event.getDisplayName());
        return endEvent;
    }

    protected ServiceTask createServiceTask(AbstractTaskDefinition task) {
        ServiceTask serviceTask = new ServiceTask();
        serviceTask.setId(task.getId().toString());
        serviceTask.setName(task.getDisplayName());
        this.addTaskOptions(task, serviceTask);
        if (!task.getConfiguration().isEmpty()) {
            this.addConfiguration(task, serviceTask);
        }
        if (task.getTaskScript().isPresent()) {
            this.addScript(task, serviceTask);
        }
        return serviceTask;
    }

    private void addScript(AbstractTaskDefinition<?> task, ServiceTask serviceTask) {
        ExtensionElement scriptElement = new ExtensionElement();
        scriptElement.setName("script");
        scriptElement.setNamespace("http://brainslug.it/bpmn");
        this.addAttribute("language", ((TaskScript)task.getTaskScript().get()).getLanguage(), scriptElement);
        scriptElement.setElementText(((TaskScript)task.getTaskScript().get()).getText());
        serviceTask.addExtensionElement(scriptElement);
    }

    private void addTaskOptions(AbstractTaskDefinition task, ServiceTask serviceTask) {
        ExtensionElement delegateElement = new ExtensionElement();
        delegateElement.setName("task");
        delegateElement.setNamespace("http://brainslug.it/bpmn");
        if (task.getDelegateClass() != null) {
            this.addAttribute("delegate", task.getDelegateClass().getName(), delegateElement);
        }
        if (task.isAsync()) {
            this.addAttribute("async", "" + task.isAsync(), delegateElement);
        }
        if (task.isRetryAsync()) {
            this.addAttribute("retryAsync", "" + task.isRetryAsync(), delegateElement);
        }
        serviceTask.addExtensionElement(delegateElement);
    }

    private void addAttribute(String name, String value, ExtensionElement delegateElement) {
        ExtensionAttribute attribute = new ExtensionAttribute();
        attribute.setName(name);
        attribute.setValue(value);
        delegateElement.addAttribute(attribute);
    }

    private void addConfiguration(AbstractTaskDefinition<?> task, ServiceTask serviceTask) {
        ExtensionElement configurationElement = new ExtensionElement();
        configurationElement.setName("configuration");
        configurationElement.setNamespace("http://brainslug.it/bpmn");
        for (Map.Entry parameter : task.getConfiguration().entrySet()) {
            ExtensionElement parameterElement = new ExtensionElement();
            parameterElement.setName("parameter");
            parameterElement.setNamespace("http://brainslug.it/bpmn");
            this.addAttribute("name", (String)parameter.getKey(), parameterElement);
            this.addAttribute("value", (String)parameter.getValue(), parameterElement);
            configurationElement.addChildElement(parameterElement);
        }
        serviceTask.addExtensionElement(configurationElement);
    }

    protected UserTask createUserTask(AbstractTaskDefinition task) {
        UserTask userTask = new UserTask();
        userTask.setId(task.getId().toString());
        userTask.setName(task.getDisplayName());
        if (task instanceof UserTaskDefinition) {
            userTask.setAssignee(((UserTaskDefinition)task).getAssignee());
        }
        return userTask;
    }
}

