/*
 * Decompiled with CFR 0.152.
 */
package brainslug.bpmn;

import brainslug.bpmn.task.UserTaskDefinition;
import brainslug.flow.FlowBuilder;
import brainslug.flow.expression.Expression;
import brainslug.flow.node.ChoiceDefinition;
import brainslug.flow.node.FlowNodeDefinition;
import brainslug.flow.node.JoinDefinition;
import brainslug.flow.node.MergeDefinition;
import brainslug.flow.node.ParallelDefinition;
import brainslug.flow.node.event.AbstractEventDefinition;
import brainslug.flow.node.event.IntermediateEvent;
import brainslug.flow.node.event.StartEvent;
import brainslug.flow.node.task.AbstractTaskDefinition;
import brainslug.flow.path.AndDefinition;
import brainslug.flow.path.FlowEdgeDefinition;
import brainslug.flow.path.FlowPathDefinition;
import brainslug.flow.path.ThenDefinition;
import brainslug.util.Option;
import java.util.ArrayList;
import java.util.List;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.ImplementationType;
import org.activiti.bpmn.model.IntermediateCatchEvent;
import org.activiti.bpmn.model.ParallelGateway;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.bpmn.model.Task;
import org.activiti.bpmn.model.UserTask;

public class BpmnModelTransformer {
    List<SequenceFlow> sequenceFlows = new ArrayList<SequenceFlow>();

    public BpmnModel toBpmnModel(FlowBuilder flowBuilder) {
        Process process = new Process();
        process.setId(flowBuilder.getDefinition().getId().toString());
        process.setName(flowBuilder.getDefinition().getName());
        BpmnModel model = new BpmnModel();
        model.addProcess(process);
        this.addNodes(process, flowBuilder);
        this.addFlows(process);
        return model;
    }

    public String toBpmnXml(FlowBuilder flowBuilder) {
        BpmnXMLConverter bpmnXMLConverter = new BpmnXMLConverter();
        try {
            return new String(bpmnXMLConverter.convertToXML(this.toBpmnModel(flowBuilder)), "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toBpmnXml(BpmnModel bpmnModel) {
        BpmnXMLConverter bpmnXMLConverter = new BpmnXMLConverter();
        try {
            return new String(bpmnXMLConverter.convertToXML(bpmnModel), "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addFlows(Process process) {
        for (SequenceFlow flow : this.sequenceFlows) {
            process.addFlowElement((FlowElement)flow);
        }
    }

    private void addNodes(Process process, FlowBuilder flowBuilder) {
        for (FlowNodeDefinition node : flowBuilder.getDefinition().getNodes()) {
            if (node instanceof AbstractEventDefinition) {
                this.addEvent((AbstractEventDefinition)node, process);
                this.collectOutgoingFlows(node);
                continue;
            }
            if (node instanceof AbstractTaskDefinition) {
                this.addTask((AbstractTaskDefinition)node, process);
                this.collectOutgoingFlows(node);
                continue;
            }
            if (node instanceof ChoiceDefinition) {
                this.addChoice((ChoiceDefinition)node, process);
                continue;
            }
            if (node instanceof ParallelDefinition) {
                this.addParallel((ParallelDefinition)node, process);
                continue;
            }
            if (node instanceof MergeDefinition) {
                this.addMerge((MergeDefinition)node, process);
                this.collectOutgoingFlows(node);
                continue;
            }
            if (node instanceof JoinDefinition) {
                this.addJoin((JoinDefinition)node, process);
                this.collectOutgoingFlows(node);
                continue;
            }
            throw new UnsupportedOperationException("unable  to transform " + node);
        }
    }

    private void addJoin(JoinDefinition node, Process process) {
        ParallelGateway gateway = this.createParallelGateway((FlowNodeDefinition)node);
        process.addFlowElement((FlowElement)gateway);
    }

    private void addParallel(ParallelDefinition parallel, Process process) {
        ParallelGateway parallelGateway = this.createParallelGateway((FlowNodeDefinition)parallel);
        process.addFlowElement((FlowElement)parallelGateway);
        for (AndDefinition andDefinition : parallel.getParallelPaths()) {
            this.addIncomingSequenceFlowToFirstPathNode((FlowElement)parallelGateway, (FlowPathDefinition<?>)andDefinition);
        }
    }

    private ParallelGateway createParallelGateway(FlowNodeDefinition parallel) {
        ParallelGateway parallelGateway = new ParallelGateway();
        parallelGateway.setId(parallel.getId().toString());
        return parallelGateway;
    }

    private void addChoice(ChoiceDefinition choice, Process process) {
        ExclusiveGateway gateway = this.createExclusiveGateway((FlowNodeDefinition)choice);
        process.addFlowElement((FlowElement)gateway);
        for (ThenDefinition then : choice.getThenPaths()) {
            SequenceFlow flow = this.addIncomingSequenceFlowToFirstPathNode((FlowElement)gateway, (FlowPathDefinition<?>)then);
            flow.setConditionExpression(this.getExpressionString(then));
        }
    }

    private String getExpressionString(ThenDefinition then) {
        if (then.getPredicateDefinition().getActual() instanceof Expression) {
            Expression expression = (Expression)then.getPredicateDefinition().getActual();
            return expression.getString();
        }
        throw new UnsupportedOperationException("can only get expression string for Expression predicate");
    }

    private SequenceFlow addIncomingSequenceFlowToFirstPathNode(FlowElement flowElement, FlowPathDefinition<?> then) {
        SequenceFlow flow = this.createSequenceFlow(flowElement.getId(), ((FlowNodeDefinition)then.getPathNodes().getFirst()).getId().toString());
        this.sequenceFlows.add(flow);
        return flow;
    }

    private void addMerge(MergeDefinition merge, Process process) {
        ExclusiveGateway gateway = this.createExclusiveGateway((FlowNodeDefinition)merge);
        process.addFlowElement((FlowElement)gateway);
    }

    private void addTask(AbstractTaskDefinition task, Process process) {
        if (task instanceof UserTaskDefinition) {
            process.addFlowElement((FlowElement)this.createUserTask(task));
        } else {
            process.addFlowElement((FlowElement)this.createServiceTask(task));
        }
    }

    private void addEvent(AbstractEventDefinition event, Process process) {
        if (event.is(StartEvent.class)) {
            process.addFlowElement((FlowElement)this.createStartEvent(event));
        } else if (event.is(brainslug.flow.node.event.EndEvent.class)) {
            process.addFlowElement((FlowElement)this.createEndEvent(event));
        } else if (event.is(IntermediateEvent.class)) {
            process.addFlowElement(this.createIntermediateCatchEvent(event));
        } else {
            throw new UnsupportedOperationException("unable to transform " + event);
        }
    }

    private FlowElement createIntermediateCatchEvent(AbstractEventDefinition event) {
        IntermediateCatchEvent catchEvent = new IntermediateCatchEvent();
        catchEvent.setId(event.getId().toString());
        catchEvent.setName(event.getDisplayName());
        return catchEvent;
    }

    private void collectOutgoingFlows(FlowNodeDefinition<?> node) {
        for (FlowEdgeDefinition edge : node.getOutgoing()) {
            this.sequenceFlows.add(this.createSequenceFlow(edge));
        }
    }

    protected SequenceFlow createSequenceFlow(FlowEdgeDefinition edge) {
        return this.createSequenceFlow(edge.getSource().getId().toString(), edge.getTarget().getId().toString());
    }

    protected SequenceFlow createSequenceFlow(String source, String target) {
        SequenceFlow flow = new SequenceFlow();
        flow.setSourceRef(source);
        flow.setTargetRef(target);
        return flow;
    }

    protected org.activiti.bpmn.model.StartEvent createStartEvent(AbstractEventDefinition event) {
        org.activiti.bpmn.model.StartEvent startEvent = new org.activiti.bpmn.model.StartEvent();
        startEvent.setId(event.getId().toString());
        startEvent.setName(event.getDisplayName());
        return startEvent;
    }

    protected ExclusiveGateway createExclusiveGateway(FlowNodeDefinition choiceDefinition) {
        ExclusiveGateway exclusiveGateway = new ExclusiveGateway();
        exclusiveGateway.setId(choiceDefinition.getId().toString());
        exclusiveGateway.setName(choiceDefinition.getDisplayName());
        return exclusiveGateway;
    }

    protected EndEvent createEndEvent(AbstractEventDefinition event) {
        EndEvent endEvent = new EndEvent();
        endEvent.setId(event.getId().toString());
        endEvent.setName(event.getDisplayName());
        return endEvent;
    }

    protected ServiceTask createServiceTask(AbstractTaskDefinition task) {
        ServiceTask serviceTask = new ServiceTask();
        serviceTask.setId(task.getId().toString());
        serviceTask.setName(task.getDisplayName());
        if (Option.of((Object)task.getDelegateClass()).isPresent()) {
            serviceTask.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_CLASS);
            serviceTask.setImplementation(task.getDelegateClass().getName());
        }
        if (task.isAsync()) {
            serviceTask.setAsynchronous(true);
        }
        return serviceTask;
    }

    protected UserTask createUserTask(AbstractTaskDefinition task) {
        UserTask userTask = new UserTask();
        userTask.setId(task.getId().toString());
        userTask.setName(task.getDisplayName());
        if (task instanceof UserTaskDefinition) {
            userTask.setAssignee(((UserTaskDefinition)task).getAssignee());
        }
        return userTask;
    }

    protected Task createTask(AbstractTaskDefinition brainslugTask) {
        Task task = new Task();
        task.setId(brainslugTask.getId().toString());
        task.setName(brainslugTask.getDisplayName());
        return task;
    }
}

