/*
 * Decompiled with CFR 0.152.
 */
package de.andrena.tools.nopackagecycles;

import de.andrena.tools.nopackagecycles.CollectionOutput;
import de.andrena.tools.nopackagecycles.PackageCycleCollector;
import de.andrena.tools.nopackagecycles.comparator.JavaClassNameComparator;
import de.andrena.tools.nopackagecycles.comparator.JavaPackageListComparator;
import de.andrena.tools.nopackagecycles.comparator.JavaPackageNameComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import jdepend.framework.JavaClass;
import jdepend.framework.JavaPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageCycleOutput {
    private List<JavaPackage> packages;
    private StringBuilder output;
    private PackageCycleCollector packageCycleCollector;

    public PackageCycleOutput(List<JavaPackage> packages) {
        this.packages = packages;
        this.packageCycleCollector = new PackageCycleCollector();
    }

    public String getOutput() {
        this.output = new StringBuilder();
        for (List<JavaPackage> cycle : this.collectAndSortCycles()) {
            this.appendOutputForPackageCycle(cycle);
        }
        return this.output.toString();
    }

    private List<List<JavaPackage>> collectAndSortCycles() {
        List<Set<JavaPackage>> cycles = this.packageCycleCollector.collectCycles(this.packages);
        ArrayList<List<JavaPackage>> orderedCycles = new ArrayList<List<JavaPackage>>();
        for (Set<JavaPackage> cycle : cycles) {
            ArrayList<JavaPackage> cycleAsList = new ArrayList<JavaPackage>(cycle);
            Collections.sort(cycleAsList, JavaPackageNameComparator.INSTANCE);
            orderedCycles.add(cycleAsList);
        }
        Collections.sort(orderedCycles, JavaPackageListComparator.INSTANCE);
        return orderedCycles;
    }

    private void appendOutputForPackageCycle(List<JavaPackage> cyclicPackages) {
        this.packages.removeAll(cyclicPackages);
        this.appendHeaderForPackageCycle(cyclicPackages);
        for (JavaPackage cyclicPackage : cyclicPackages) {
            this.appendOutputForPackage(cyclicPackage, cyclicPackages);
        }
    }

    private void appendHeaderForPackageCycle(List<JavaPackage> cyclicPackages) {
        this.output.append("\n\n").append("Package-cycle found involving ");
        this.output.append(CollectionOutput.joinCollection(cyclicPackages, new CollectionOutput.StringProvider<JavaPackage>(){

            @Override
            public String provide(JavaPackage javaPackage) {
                return javaPackage.getName();
            }
        }, ", "));
        this.output.append(':');
    }

    private void appendOutputForPackage(JavaPackage javaPackage, List<JavaPackage> cyclicPackages) {
        this.output.append("\n    ").append(javaPackage.getName()).append(" depends on:");
        for (JavaPackage cyclicPackage : cyclicPackages) {
            this.appendOutputForCyclicPackage(javaPackage, cyclicPackage);
        }
    }

    private void appendOutputForCyclicPackage(JavaPackage javaPackage, JavaPackage cyclicPackage) {
        if (javaPackage.equals((Object)cyclicPackage)) {
            return;
        }
        List<JavaClass> dependentClasses = this.getOrderedDependentClasses(javaPackage, cyclicPackage);
        if (!dependentClasses.isEmpty()) {
            this.appendOutputForDependentCyclicPackage(javaPackage, cyclicPackage, dependentClasses);
        }
    }

    private List<JavaClass> getOrderedDependentClasses(JavaPackage javaPackage, JavaPackage cyclicPackage) {
        ArrayList<JavaClass> dependentClasses = new ArrayList<JavaClass>();
        Collection allClasses = javaPackage.getClasses();
        for (JavaClass javaClass : allClasses) {
            if (!javaClass.getImportedPackages().contains(cyclicPackage)) continue;
            dependentClasses.add(javaClass);
        }
        Collections.sort(dependentClasses, JavaClassNameComparator.INSTANCE);
        return dependentClasses;
    }

    private void appendOutputForDependentCyclicPackage(JavaPackage javaPackage, JavaPackage cyclicPackage, List<JavaClass> dependentClasses) {
        this.output.append("\n        ").append(cyclicPackage.getName()).append(" (");
        this.appendOutputForCyclicPackageClasses(javaPackage, cyclicPackage, dependentClasses);
        this.output.append(")");
    }

    private void appendOutputForCyclicPackageClasses(JavaPackage javaPackage, JavaPackage cyclicPackage, List<JavaClass> dependentClasses) {
        CollectionOutput.joinCollection(dependentClasses, this.output, new CollectionOutput.Appender<JavaClass>(){

            @Override
            public void append(JavaClass packageClass) {
                PackageCycleOutput.this.output.append(packageClass.getName().substring(packageClass.getPackageName().length() + 1));
            }
        }, ", ");
    }
}

