/*
 * Decompiled with CFR 0.152.
 */
package de.andrena.tools.nopackagecycles;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jdepend.framework.JavaPackage;
import org.jgrapht.DirectedGraph;
import org.jgrapht.alg.StrongConnectivityInspector;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageCycleCollector {
    public List<Set<JavaPackage>> collectCycles(List<JavaPackage> packages) {
        DefaultDirectedGraph graph = new DefaultDirectedGraph(DefaultEdge.class);
        this.addVerticesToGraph(packages, (DirectedGraph<JavaPackage, DefaultEdge>)graph);
        this.addEdgesToGraph(packages, (DirectedGraph<JavaPackage, DefaultEdge>)graph);
        return this.collectCycles((DirectedGraph<JavaPackage, DefaultEdge>)graph);
    }

    private List<Set<JavaPackage>> collectCycles(DirectedGraph<JavaPackage, DefaultEdge> graph) {
        List stronglyConnectedSets = new StrongConnectivityInspector(graph).stronglyConnectedSets();
        this.removeSingletonSets(stronglyConnectedSets);
        return stronglyConnectedSets;
    }

    private void removeSingletonSets(List<Set<JavaPackage>> stronglyConnectedSets) {
        Iterator<Set<JavaPackage>> iterator = stronglyConnectedSets.iterator();
        while (iterator.hasNext()) {
            Set<JavaPackage> stronglyConnectedSet = iterator.next();
            if (stronglyConnectedSet.size() != 1) continue;
            iterator.remove();
        }
    }

    private void addEdgesToGraph(List<JavaPackage> packages, DirectedGraph<JavaPackage, DefaultEdge> graph) {
        for (JavaPackage javaPackage : packages) {
            for (JavaPackage efferent : javaPackage.getEfferents()) {
                graph.addEdge((Object)javaPackage, (Object)efferent);
            }
        }
    }

    private void addVerticesToGraph(List<JavaPackage> packages, DirectedGraph<JavaPackage, DefaultEdge> graph) {
        for (JavaPackage javaPackage : packages) {
            graph.addVertex((Object)javaPackage);
        }
    }
}

