/*
 * Decompiled with CFR 0.152.
 */
package de.andrena.tools.nopackagecycles;

import de.andrena.tools.nopackagecycles.CollectionOutput;
import de.andrena.tools.nopackagecycles.PackageCycleCollector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import jdepend.framework.JavaClass;
import jdepend.framework.JavaPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageCycleOutput {
    private List<JavaPackage> packages;
    private StringBuilder output;
    private PackageCycleCollector packageCycleCollector = new PackageCycleCollector();

    public PackageCycleOutput(List<JavaPackage> packages) {
        this.packages = packages;
    }

    public String getOutput() {
        this.output = new StringBuilder();
        this.orderByPackageName(this.packages);
        while (!this.packages.isEmpty()) {
            JavaPackage javaPackage = this.packages.get(0);
            this.packages.remove(javaPackage);
            List<JavaPackage> cyclicPackages = this.getCyclicPackages(javaPackage);
            if (cyclicPackages.isEmpty()) continue;
            this.appendOutputForPackageCycle(cyclicPackages);
        }
        return this.output.toString();
    }

    private void appendOutputForPackageCycle(List<JavaPackage> cyclicPackages) {
        this.packages.removeAll(cyclicPackages);
        this.appendHeaderForPackageCycle(cyclicPackages);
        for (JavaPackage cyclicPackage : cyclicPackages) {
            this.appendOutputForPackage(cyclicPackage, cyclicPackages);
        }
    }

    private void appendHeaderForPackageCycle(List<JavaPackage> cyclicPackages) {
        this.output.append("\n\n").append("Package-cycle found involving ");
        this.output.append(CollectionOutput.joinCollection(cyclicPackages, new CollectionOutput.StringProvider<JavaPackage>(){

            @Override
            public String provide(JavaPackage javaPackage) {
                return javaPackage.getName();
            }
        }, ", "));
        this.output.append(':');
    }

    private void appendOutputForPackage(JavaPackage javaPackage, List<JavaPackage> cyclicPackages) {
        this.output.append("\n    ").append(javaPackage.getName()).append(" depends on:");
        for (JavaPackage cyclicPackage : cyclicPackages) {
            this.appendOutputForCyclicPackage(javaPackage, cyclicPackage);
        }
    }

    private void appendOutputForCyclicPackage(JavaPackage javaPackage, JavaPackage cyclicPackage) {
        if (javaPackage.equals((Object)cyclicPackage)) {
            return;
        }
        List<JavaClass> dependentClasses = this.getOrderedDependentClasses(javaPackage, cyclicPackage);
        if (!dependentClasses.isEmpty()) {
            this.appendOutputForDependentCyclicPackage(javaPackage, cyclicPackage, dependentClasses);
        }
    }

    private List<JavaClass> getOrderedDependentClasses(JavaPackage javaPackage, JavaPackage cyclicPackage) {
        ArrayList<JavaClass> dependentClasses = new ArrayList<JavaClass>();
        Collection allClasses = javaPackage.getClasses();
        for (JavaClass javaClass : allClasses) {
            if (!javaClass.getImportedPackages().contains(cyclicPackage)) continue;
            dependentClasses.add(javaClass);
        }
        this.orderByClassName(dependentClasses);
        return dependentClasses;
    }

    private void appendOutputForDependentCyclicPackage(JavaPackage javaPackage, JavaPackage cyclicPackage, List<JavaClass> dependentClasses) {
        this.output.append("\n        ").append(cyclicPackage.getName()).append(" (");
        this.appendOutputForCyclicPackageClasses(javaPackage, cyclicPackage, dependentClasses);
        this.output.append(")");
    }

    private void appendOutputForCyclicPackageClasses(JavaPackage javaPackage, JavaPackage cyclicPackage, List<JavaClass> dependentClasses) {
        CollectionOutput.joinCollection(dependentClasses, this.output, new CollectionOutput.Appender<JavaClass>(){

            @Override
            public void append(JavaClass packageClass) {
                PackageCycleOutput.this.output.append(packageClass.getName().substring(packageClass.getPackageName().length() + 1));
            }
        }, ", ");
    }

    private void orderByClassName(List<JavaClass> dependentClasses) {
        Collections.sort(dependentClasses, new Comparator<JavaClass>(){

            @Override
            public int compare(JavaClass class1, JavaClass class2) {
                return class1.getName().compareTo(class2.getName());
            }
        });
    }

    private List<JavaPackage> getCyclicPackages(JavaPackage javaPackage) {
        ArrayList<JavaPackage> cyclicPackages = new ArrayList<JavaPackage>(this.packageCycleCollector.collectCycles(javaPackage));
        this.orderByPackageName(cyclicPackages);
        return cyclicPackages;
    }

    private void orderByPackageName(List<JavaPackage> cyclicPackages) {
        Collections.sort(cyclicPackages, new Comparator<JavaPackage>(){

            @Override
            public int compare(JavaPackage package1, JavaPackage package2) {
                return package1.getName().compareTo(package2.getName());
            }
        });
    }
}

