/*
 * Decompiled with CFR 0.152.
 */
package de.andrena.tools.nopackagecycles;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jdepend.framework.JavaPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageCycleCollector {
    public Set<JavaPackage> collectCycles(JavaPackage javaPackage) {
        return this.collectCycles(javaPackage, new ArrayList<JavaPackage>());
    }

    private Set<JavaPackage> collectCycles(JavaPackage javaPackage, List<JavaPackage> visitedPackages) {
        if (visitedPackages.contains(javaPackage)) {
            return this.getPackageCycle(javaPackage, visitedPackages);
        }
        visitedPackages.add(javaPackage);
        return this.collectAllDependencyCycles(javaPackage, visitedPackages);
    }

    private Set<JavaPackage> collectAllDependencyCycles(JavaPackage javaPackage, List<JavaPackage> visitedPackages) {
        HashSet<JavaPackage> allCycles = new HashSet<JavaPackage>();
        for (JavaPackage dependencyPackage : this.getEfferents(javaPackage)) {
            Set<JavaPackage> dependencyPackageCycle = this.collectCycles(dependencyPackage, new ArrayList<JavaPackage>(visitedPackages));
            if (!dependencyPackageCycle.contains(javaPackage)) continue;
            allCycles.addAll(dependencyPackageCycle);
        }
        return allCycles;
    }

    private Collection<JavaPackage> getEfferents(JavaPackage javaPackage) {
        return javaPackage.getEfferents();
    }

    private Set<JavaPackage> getPackageCycle(JavaPackage javaPackage, List<JavaPackage> visitedPackages) {
        HashSet<JavaPackage> packageCycle = new HashSet<JavaPackage>();
        boolean includeFollowingPackages = false;
        for (JavaPackage visitedPackage : visitedPackages) {
            if (visitedPackage.equals((Object)javaPackage)) {
                includeFollowingPackages = true;
            }
            if (!includeFollowingPackages) continue;
            packageCycle.add(visitedPackage);
        }
        return packageCycle;
    }
}

