/*
 * Decompiled with CFR 0.152.
 */
package de.andrena.tools.nopackagecycles;

import de.andrena.tools.nopackagecycles.PackageCycleOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import jdepend.framework.JDepend;
import jdepend.framework.JavaPackage;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;

public class NoPackageCyclesRule
implements EnforcerRule {
    public static final String MAVEN_JAR_PACKAGING = "jar";
    public static final String MAVEN_CLASSES_DIR = "classes";
    public static final String MAVEN_PROJECT_BUILD_DIRECTORY_VAR = "${project.build.directory}";
    public static final String MAVEN_PROJECT_VAR = "${project}";

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        try {
            this.executePackageCycleCheckIfNecessary(helper);
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException("Unable to lookup an expression " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new EnforcerRuleException("Unable to access target directory " + e.getLocalizedMessage(), (Exception)e);
        }
    }

    private void executePackageCycleCheckIfNecessary(EnforcerRuleHelper helper) throws ExpressionEvaluationException, IOException, EnforcerRuleException {
        File targetDir;
        File classesDir;
        MavenProject project = (MavenProject)helper.evaluate(MAVEN_PROJECT_VAR);
        if (this.checkIsNecessary(project, classesDir = new File(targetDir = new File((String)helper.evaluate(MAVEN_PROJECT_BUILD_DIRECTORY_VAR)), MAVEN_CLASSES_DIR))) {
            this.executePackageCycleCheck(classesDir);
        }
    }

    private void executePackageCycleCheck(File classesDir) throws IOException, EnforcerRuleException {
        JDepend jdepend = this.createJDepend();
        jdepend.addDirectory(classesDir.getAbsolutePath());
        jdepend.analyze();
        if (jdepend.containsCycles()) {
            throw new EnforcerRuleException("There are package cycles:" + this.getPackageCycles(jdepend));
        }
    }

    protected JDepend createJDepend() {
        return new JDepend();
    }

    private String getPackageCycles(JDepend jdepend) {
        Collection packages = jdepend.getPackages();
        return new PackageCycleOutput(new ArrayList<JavaPackage>(packages)).getOutput();
    }

    private boolean checkIsNecessary(MavenProject project, File classesDir) {
        return classesDir.exists();
    }

    public String getCacheId() {
        return "";
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule arg0) {
        return false;
    }
}

