/*
 * Decompiled with CFR 0.152.
 */
package de.andrena.tools.nopackagecycles;

import de.andrena.tools.nopackagecycles.CollectionOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import jdepend.framework.JavaClass;
import jdepend.framework.JavaPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageCycleOutput {
    private List<JavaPackage> packages;
    private StringBuilder output;

    public PackageCycleOutput(List<JavaPackage> packages) {
        this.packages = packages;
    }

    public String getOutput() {
        this.output = new StringBuilder();
        this.orderPackagesByName();
        while (!this.packages.isEmpty()) {
            JavaPackage javaPackage = this.packages.get(0);
            this.packages.remove(0);
            if (!javaPackage.containsCycle()) continue;
            this.appendOutputForPackage(javaPackage);
        }
        return this.output.toString();
    }

    private void orderPackagesByName() {
        ArrayList<JavaPackage> packageList = new ArrayList<JavaPackage>(this.packages);
        this.orderByPackageName(packageList);
        this.packages = packageList;
    }

    private void appendOutputForPackage(final JavaPackage javaPackage) {
        this.output.append("\n").append(javaPackage.getName()).append(" has cyclic dependency to: ");
        CollectionOutput.joinCollection(this.getAndPrependCyclicPackages(javaPackage), this.output, new CollectionOutput.Appender<JavaPackage>(){

            @Override
            public void append(JavaPackage cyclicPackage) {
                PackageCycleOutput.this.appendOutputForCyclicPackage(javaPackage, cyclicPackage);
            }
        });
    }

    private void appendOutputForCyclicPackage(JavaPackage javaPackage, JavaPackage cyclicPackage) {
        this.output.append(cyclicPackage.getName()).append(" (");
        this.appendOutputForCyclicPackageClasses(javaPackage, cyclicPackage);
        this.output.append(")");
    }

    private void appendOutputForCyclicPackageClasses(JavaPackage javaPackage, final JavaPackage cyclicPackage) {
        CollectionOutput.joinCollection(this.getOrderedPackageClasses(javaPackage, cyclicPackage), this.output, new CollectionOutput.Appender<JavaClass>(){

            @Override
            public void append(JavaClass packageClass) {
                PackageCycleOutput.this.output.append(packageClass.getName().substring(cyclicPackage.getName().length() + 1));
            }
        });
    }

    private Collection<JavaClass> getOrderedPackageClasses(JavaPackage javaPackage, JavaPackage cyclicPackage) {
        List<JavaClass> classes = this.getClassesDependentOnPackage(javaPackage, cyclicPackage);
        Collections.sort(classes, new Comparator<JavaClass>(){

            @Override
            public int compare(JavaClass class1, JavaClass class2) {
                return class1.getName().compareTo(class2.getName());
            }
        });
        return classes;
    }

    private List<JavaClass> getClassesDependentOnPackage(JavaPackage javaPackage, JavaPackage cyclicPackage) {
        Collection allClasses = cyclicPackage.getClasses();
        ArrayList<JavaClass> dependentClasses = new ArrayList<JavaClass>();
        for (JavaClass clazz : allClasses) {
            if (!clazz.getImportedPackages().contains(javaPackage)) continue;
            dependentClasses.add(clazz);
        }
        return dependentClasses;
    }

    private List<JavaPackage> getAndPrependCyclicPackages(JavaPackage javaPackage) {
        ArrayList<JavaPackage> cyclicPackages = new ArrayList<JavaPackage>();
        javaPackage.collectAllCycles(cyclicPackages);
        this.removeSelfAndDuplications(javaPackage, cyclicPackages);
        this.orderByPackageName(cyclicPackages);
        this.prependPackages(cyclicPackages);
        return cyclicPackages;
    }

    private void prependPackages(List<JavaPackage> cyclicPackages) {
        List<JavaPackage> pendingCyclicPackages = this.getPendingCyclicPackages(cyclicPackages);
        this.packages.removeAll(pendingCyclicPackages);
        this.packages.addAll(0, pendingCyclicPackages);
    }

    private List<JavaPackage> getPendingCyclicPackages(List<JavaPackage> cyclicPackages) {
        ArrayList<JavaPackage> pendingCyclicPackages = new ArrayList<JavaPackage>();
        for (JavaPackage cyclicPackage : cyclicPackages) {
            if (!this.packages.contains(cyclicPackage)) continue;
            pendingCyclicPackages.add(cyclicPackage);
        }
        return pendingCyclicPackages;
    }

    private void orderByPackageName(List<JavaPackage> cyclicPackages) {
        Collections.sort(cyclicPackages, new Comparator<JavaPackage>(){

            @Override
            public int compare(JavaPackage package1, JavaPackage package2) {
                return package1.getName().compareTo(package2.getName());
            }
        });
    }

    private void removeSelfAndDuplications(JavaPackage javaPackage, List<JavaPackage> cyclicPackages) {
        HashSet<JavaPackage> uniquePackages = new HashSet<JavaPackage>(cyclicPackages);
        uniquePackages.remove(javaPackage);
        cyclicPackages.clear();
        cyclicPackages.addAll(uniquePackages);
    }
}

