/*
 * Decompiled with CFR 0.152.
 */
package de.andrena.tools.nopackagecycles;

import edu.emory.mathcs.backport.java.util.Arrays;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionOutput {
    public static <T> String joinCollection(Collection<T> collection, final StringProvider<T> stringProvider) {
        final StringBuilder output = new StringBuilder();
        CollectionOutput.joinCollection(collection, output, new Appender<T>(){

            @Override
            public void append(T value) {
                output.append(stringProvider.provide(value));
            }
        });
        return output.toString();
    }

    public static <T> String joinArray(T[] array, StringProvider<T> stringProvider) {
        List list = Arrays.asList((Object[])array);
        return CollectionOutput.joinCollection(list, stringProvider);
    }

    public static <T> void joinCollection(Collection<T> collection, StringBuilder output, Appender<T> appender) {
        boolean first = true;
        for (T element : collection) {
            if (!first) {
                output.append(", ");
            }
            appender.append(element);
            first = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Appender<T> {
        public void append(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface StringProvider<T> {
        public String provide(T var1);
    }
}

