/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.ShippingCarriers;
import org.openapitools.client.model.ShopShippingProfile;
import org.openapitools.client.model.ShopShippingProfileDestination;
import org.openapitools.client.model.ShopShippingProfileDestinations;
import org.openapitools.client.model.ShopShippingProfileUpgrade;
import org.openapitools.client.model.ShopShippingProfileUpgrades;
import org.openapitools.client.model.ShopShippingProfiles;

public class ShopShippingProfileApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ShopShippingProfileApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ShopShippingProfileApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createShopShippingProfileCall(Long shopId, String title, String originCountryIso, Float primaryCost, Float secondaryCost, Long minProcessingTime, Long maxProcessingTime, String processingTimeUnit, String destinationCountryIso, String destinationRegion, String originPostalCode, Long shippingCarrierId, String mailClass, Long minDeliveryDays, Long maxDeliveryDays, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/shipping-profiles".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (title != null) {
            localVarFormParams.put("title", title);
        }
        if (originCountryIso != null) {
            localVarFormParams.put("origin_country_iso", originCountryIso);
        }
        if (primaryCost != null) {
            localVarFormParams.put("primary_cost", primaryCost);
        }
        if (secondaryCost != null) {
            localVarFormParams.put("secondary_cost", secondaryCost);
        }
        if (minProcessingTime != null) {
            localVarFormParams.put("min_processing_time", minProcessingTime);
        }
        if (maxProcessingTime != null) {
            localVarFormParams.put("max_processing_time", maxProcessingTime);
        }
        if (processingTimeUnit != null) {
            localVarFormParams.put("processing_time_unit", processingTimeUnit);
        }
        if (destinationCountryIso != null) {
            localVarFormParams.put("destination_country_iso", destinationCountryIso);
        }
        if (destinationRegion != null) {
            localVarFormParams.put("destination_region", destinationRegion);
        }
        if (originPostalCode != null) {
            localVarFormParams.put("origin_postal_code", originPostalCode);
        }
        if (shippingCarrierId != null) {
            localVarFormParams.put("shipping_carrier_id", shippingCarrierId);
        }
        if (mailClass != null) {
            localVarFormParams.put("mail_class", mailClass);
        }
        if (minDeliveryDays != null) {
            localVarFormParams.put("min_delivery_days", minDeliveryDays);
        }
        if (maxDeliveryDays != null) {
            localVarFormParams.put("max_delivery_days", maxDeliveryDays);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/x-www-form-urlencoded"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createShopShippingProfileValidateBeforeCall(Long shopId, String title, String originCountryIso, Float primaryCost, Float secondaryCost, Long minProcessingTime, Long maxProcessingTime, String processingTimeUnit, String destinationCountryIso, String destinationRegion, String originPostalCode, Long shippingCarrierId, String mailClass, Long minDeliveryDays, Long maxDeliveryDays, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling createShopShippingProfile(Async)");
        }
        if (title == null) {
            throw new ApiException("Missing the required parameter 'title' when calling createShopShippingProfile(Async)");
        }
        if (originCountryIso == null) {
            throw new ApiException("Missing the required parameter 'originCountryIso' when calling createShopShippingProfile(Async)");
        }
        if (primaryCost == null) {
            throw new ApiException("Missing the required parameter 'primaryCost' when calling createShopShippingProfile(Async)");
        }
        if (secondaryCost == null) {
            throw new ApiException("Missing the required parameter 'secondaryCost' when calling createShopShippingProfile(Async)");
        }
        if (minProcessingTime == null) {
            throw new ApiException("Missing the required parameter 'minProcessingTime' when calling createShopShippingProfile(Async)");
        }
        if (maxProcessingTime == null) {
            throw new ApiException("Missing the required parameter 'maxProcessingTime' when calling createShopShippingProfile(Async)");
        }
        return this.createShopShippingProfileCall(shopId, title, originCountryIso, primaryCost, secondaryCost, minProcessingTime, maxProcessingTime, processingTimeUnit, destinationCountryIso, destinationRegion, originPostalCode, shippingCarrierId, mailClass, minDeliveryDays, maxDeliveryDays, _callback);
    }

    public ShopShippingProfile createShopShippingProfile(Long shopId, String title, String originCountryIso, Float primaryCost, Float secondaryCost, Long minProcessingTime, Long maxProcessingTime, String processingTimeUnit, String destinationCountryIso, String destinationRegion, String originPostalCode, Long shippingCarrierId, String mailClass, Long minDeliveryDays, Long maxDeliveryDays) throws ApiException {
        ApiResponse<ShopShippingProfile> localVarResp = this.createShopShippingProfileWithHttpInfo(shopId, title, originCountryIso, primaryCost, secondaryCost, minProcessingTime, maxProcessingTime, processingTimeUnit, destinationCountryIso, destinationRegion, originPostalCode, shippingCarrierId, mailClass, minDeliveryDays, maxDeliveryDays);
        return localVarResp.getData();
    }

    public ApiResponse<ShopShippingProfile> createShopShippingProfileWithHttpInfo(Long shopId, String title, String originCountryIso, Float primaryCost, Float secondaryCost, Long minProcessingTime, Long maxProcessingTime, String processingTimeUnit, String destinationCountryIso, String destinationRegion, String originPostalCode, Long shippingCarrierId, String mailClass, Long minDeliveryDays, Long maxDeliveryDays) throws ApiException {
        Call localVarCall = this.createShopShippingProfileValidateBeforeCall(shopId, title, originCountryIso, primaryCost, secondaryCost, minProcessingTime, maxProcessingTime, processingTimeUnit, destinationCountryIso, destinationRegion, originPostalCode, shippingCarrierId, mailClass, minDeliveryDays, maxDeliveryDays, null);
        Type localVarReturnType = new TypeToken<ShopShippingProfile>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createShopShippingProfileAsync(Long shopId, String title, String originCountryIso, Float primaryCost, Float secondaryCost, Long minProcessingTime, Long maxProcessingTime, String processingTimeUnit, String destinationCountryIso, String destinationRegion, String originPostalCode, Long shippingCarrierId, String mailClass, Long minDeliveryDays, Long maxDeliveryDays, ApiCallback<ShopShippingProfile> _callback) throws ApiException {
        Call localVarCall = this.createShopShippingProfileValidateBeforeCall(shopId, title, originCountryIso, primaryCost, secondaryCost, minProcessingTime, maxProcessingTime, processingTimeUnit, destinationCountryIso, destinationRegion, originPostalCode, shippingCarrierId, mailClass, minDeliveryDays, maxDeliveryDays, _callback);
        Type localVarReturnType = new TypeToken<ShopShippingProfile>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createShopShippingProfileDestinationCall(Long shopId, Long shippingProfileId, Float primaryCost, Float secondaryCost, String destinationCountryIso, String destinationRegion, Long shippingCarrierId, String mailClass, Long minDeliveryDays, Long maxDeliveryDays, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/shipping-profiles/{shipping_profile_id}/destinations".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString())).replace("{shipping_profile_id}", this.localVarApiClient.escapeString(shippingProfileId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (primaryCost != null) {
            localVarFormParams.put("primary_cost", primaryCost);
        }
        if (secondaryCost != null) {
            localVarFormParams.put("secondary_cost", secondaryCost);
        }
        if (destinationCountryIso != null) {
            localVarFormParams.put("destination_country_iso", destinationCountryIso);
        }
        if (destinationRegion != null) {
            localVarFormParams.put("destination_region", destinationRegion);
        }
        if (shippingCarrierId != null) {
            localVarFormParams.put("shipping_carrier_id", shippingCarrierId);
        }
        if (mailClass != null) {
            localVarFormParams.put("mail_class", mailClass);
        }
        if (minDeliveryDays != null) {
            localVarFormParams.put("min_delivery_days", minDeliveryDays);
        }
        if (maxDeliveryDays != null) {
            localVarFormParams.put("max_delivery_days", maxDeliveryDays);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/x-www-form-urlencoded"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createShopShippingProfileDestinationValidateBeforeCall(Long shopId, Long shippingProfileId, Float primaryCost, Float secondaryCost, String destinationCountryIso, String destinationRegion, Long shippingCarrierId, String mailClass, Long minDeliveryDays, Long maxDeliveryDays, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling createShopShippingProfileDestination(Async)");
        }
        if (shippingProfileId == null) {
            throw new ApiException("Missing the required parameter 'shippingProfileId' when calling createShopShippingProfileDestination(Async)");
        }
        if (primaryCost == null) {
            throw new ApiException("Missing the required parameter 'primaryCost' when calling createShopShippingProfileDestination(Async)");
        }
        if (secondaryCost == null) {
            throw new ApiException("Missing the required parameter 'secondaryCost' when calling createShopShippingProfileDestination(Async)");
        }
        return this.createShopShippingProfileDestinationCall(shopId, shippingProfileId, primaryCost, secondaryCost, destinationCountryIso, destinationRegion, shippingCarrierId, mailClass, minDeliveryDays, maxDeliveryDays, _callback);
    }

    public ShopShippingProfileDestination createShopShippingProfileDestination(Long shopId, Long shippingProfileId, Float primaryCost, Float secondaryCost, String destinationCountryIso, String destinationRegion, Long shippingCarrierId, String mailClass, Long minDeliveryDays, Long maxDeliveryDays) throws ApiException {
        ApiResponse<ShopShippingProfileDestination> localVarResp = this.createShopShippingProfileDestinationWithHttpInfo(shopId, shippingProfileId, primaryCost, secondaryCost, destinationCountryIso, destinationRegion, shippingCarrierId, mailClass, minDeliveryDays, maxDeliveryDays);
        return localVarResp.getData();
    }

    public ApiResponse<ShopShippingProfileDestination> createShopShippingProfileDestinationWithHttpInfo(Long shopId, Long shippingProfileId, Float primaryCost, Float secondaryCost, String destinationCountryIso, String destinationRegion, Long shippingCarrierId, String mailClass, Long minDeliveryDays, Long maxDeliveryDays) throws ApiException {
        Call localVarCall = this.createShopShippingProfileDestinationValidateBeforeCall(shopId, shippingProfileId, primaryCost, secondaryCost, destinationCountryIso, destinationRegion, shippingCarrierId, mailClass, minDeliveryDays, maxDeliveryDays, null);
        Type localVarReturnType = new TypeToken<ShopShippingProfileDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createShopShippingProfileDestinationAsync(Long shopId, Long shippingProfileId, Float primaryCost, Float secondaryCost, String destinationCountryIso, String destinationRegion, Long shippingCarrierId, String mailClass, Long minDeliveryDays, Long maxDeliveryDays, ApiCallback<ShopShippingProfileDestination> _callback) throws ApiException {
        Call localVarCall = this.createShopShippingProfileDestinationValidateBeforeCall(shopId, shippingProfileId, primaryCost, secondaryCost, destinationCountryIso, destinationRegion, shippingCarrierId, mailClass, minDeliveryDays, maxDeliveryDays, _callback);
        Type localVarReturnType = new TypeToken<ShopShippingProfileDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createShopShippingProfileUpgradeCall(Long shopId, Long shippingProfileId, String type, String upgradeName, Float price, Float secondaryPrice, Long shippingCarrierId, String mailClass, Long minDeliveryDays, Long maxDeliveryDays, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/shipping-profiles/{shipping_profile_id}/upgrades".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString())).replace("{shipping_profile_id}", this.localVarApiClient.escapeString(shippingProfileId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (type != null) {
            localVarFormParams.put("type", type);
        }
        if (upgradeName != null) {
            localVarFormParams.put("upgrade_name", upgradeName);
        }
        if (price != null) {
            localVarFormParams.put("price", price);
        }
        if (secondaryPrice != null) {
            localVarFormParams.put("secondary_price", secondaryPrice);
        }
        if (shippingCarrierId != null) {
            localVarFormParams.put("shipping_carrier_id", shippingCarrierId);
        }
        if (mailClass != null) {
            localVarFormParams.put("mail_class", mailClass);
        }
        if (minDeliveryDays != null) {
            localVarFormParams.put("min_delivery_days", minDeliveryDays);
        }
        if (maxDeliveryDays != null) {
            localVarFormParams.put("max_delivery_days", maxDeliveryDays);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/x-www-form-urlencoded"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createShopShippingProfileUpgradeValidateBeforeCall(Long shopId, Long shippingProfileId, String type, String upgradeName, Float price, Float secondaryPrice, Long shippingCarrierId, String mailClass, Long minDeliveryDays, Long maxDeliveryDays, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling createShopShippingProfileUpgrade(Async)");
        }
        if (shippingProfileId == null) {
            throw new ApiException("Missing the required parameter 'shippingProfileId' when calling createShopShippingProfileUpgrade(Async)");
        }
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling createShopShippingProfileUpgrade(Async)");
        }
        if (upgradeName == null) {
            throw new ApiException("Missing the required parameter 'upgradeName' when calling createShopShippingProfileUpgrade(Async)");
        }
        if (price == null) {
            throw new ApiException("Missing the required parameter 'price' when calling createShopShippingProfileUpgrade(Async)");
        }
        if (secondaryPrice == null) {
            throw new ApiException("Missing the required parameter 'secondaryPrice' when calling createShopShippingProfileUpgrade(Async)");
        }
        return this.createShopShippingProfileUpgradeCall(shopId, shippingProfileId, type, upgradeName, price, secondaryPrice, shippingCarrierId, mailClass, minDeliveryDays, maxDeliveryDays, _callback);
    }

    public ShopShippingProfileUpgrade createShopShippingProfileUpgrade(Long shopId, Long shippingProfileId, String type, String upgradeName, Float price, Float secondaryPrice, Long shippingCarrierId, String mailClass, Long minDeliveryDays, Long maxDeliveryDays) throws ApiException {
        ApiResponse<ShopShippingProfileUpgrade> localVarResp = this.createShopShippingProfileUpgradeWithHttpInfo(shopId, shippingProfileId, type, upgradeName, price, secondaryPrice, shippingCarrierId, mailClass, minDeliveryDays, maxDeliveryDays);
        return localVarResp.getData();
    }

    public ApiResponse<ShopShippingProfileUpgrade> createShopShippingProfileUpgradeWithHttpInfo(Long shopId, Long shippingProfileId, String type, String upgradeName, Float price, Float secondaryPrice, Long shippingCarrierId, String mailClass, Long minDeliveryDays, Long maxDeliveryDays) throws ApiException {
        Call localVarCall = this.createShopShippingProfileUpgradeValidateBeforeCall(shopId, shippingProfileId, type, upgradeName, price, secondaryPrice, shippingCarrierId, mailClass, minDeliveryDays, maxDeliveryDays, null);
        Type localVarReturnType = new TypeToken<ShopShippingProfileUpgrade>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createShopShippingProfileUpgradeAsync(Long shopId, Long shippingProfileId, String type, String upgradeName, Float price, Float secondaryPrice, Long shippingCarrierId, String mailClass, Long minDeliveryDays, Long maxDeliveryDays, ApiCallback<ShopShippingProfileUpgrade> _callback) throws ApiException {
        Call localVarCall = this.createShopShippingProfileUpgradeValidateBeforeCall(shopId, shippingProfileId, type, upgradeName, price, secondaryPrice, shippingCarrierId, mailClass, minDeliveryDays, maxDeliveryDays, _callback);
        Type localVarReturnType = new TypeToken<ShopShippingProfileUpgrade>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteShopShippingProfileCall(Long shopId, Long shippingProfileId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/shipping-profiles/{shipping_profile_id}".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString())).replace("{shipping_profile_id}", this.localVarApiClient.escapeString(shippingProfileId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteShopShippingProfileValidateBeforeCall(Long shopId, Long shippingProfileId, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling deleteShopShippingProfile(Async)");
        }
        if (shippingProfileId == null) {
            throw new ApiException("Missing the required parameter 'shippingProfileId' when calling deleteShopShippingProfile(Async)");
        }
        return this.deleteShopShippingProfileCall(shopId, shippingProfileId, _callback);
    }

    public void deleteShopShippingProfile(Long shopId, Long shippingProfileId) throws ApiException {
        this.deleteShopShippingProfileWithHttpInfo(shopId, shippingProfileId);
    }

    public ApiResponse<Void> deleteShopShippingProfileWithHttpInfo(Long shopId, Long shippingProfileId) throws ApiException {
        Call localVarCall = this.deleteShopShippingProfileValidateBeforeCall(shopId, shippingProfileId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteShopShippingProfileAsync(Long shopId, Long shippingProfileId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteShopShippingProfileValidateBeforeCall(shopId, shippingProfileId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteShopShippingProfileDestinationCall(Long shopId, Long shippingProfileId, Long shippingProfileDestinationId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/shipping-profiles/{shipping_profile_id}/destinations/{shipping_profile_destination_id}".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString())).replace("{shipping_profile_id}", this.localVarApiClient.escapeString(shippingProfileId.toString())).replace("{shipping_profile_destination_id}", this.localVarApiClient.escapeString(shippingProfileDestinationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteShopShippingProfileDestinationValidateBeforeCall(Long shopId, Long shippingProfileId, Long shippingProfileDestinationId, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling deleteShopShippingProfileDestination(Async)");
        }
        if (shippingProfileId == null) {
            throw new ApiException("Missing the required parameter 'shippingProfileId' when calling deleteShopShippingProfileDestination(Async)");
        }
        if (shippingProfileDestinationId == null) {
            throw new ApiException("Missing the required parameter 'shippingProfileDestinationId' when calling deleteShopShippingProfileDestination(Async)");
        }
        return this.deleteShopShippingProfileDestinationCall(shopId, shippingProfileId, shippingProfileDestinationId, _callback);
    }

    public void deleteShopShippingProfileDestination(Long shopId, Long shippingProfileId, Long shippingProfileDestinationId) throws ApiException {
        this.deleteShopShippingProfileDestinationWithHttpInfo(shopId, shippingProfileId, shippingProfileDestinationId);
    }

    public ApiResponse<Void> deleteShopShippingProfileDestinationWithHttpInfo(Long shopId, Long shippingProfileId, Long shippingProfileDestinationId) throws ApiException {
        Call localVarCall = this.deleteShopShippingProfileDestinationValidateBeforeCall(shopId, shippingProfileId, shippingProfileDestinationId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteShopShippingProfileDestinationAsync(Long shopId, Long shippingProfileId, Long shippingProfileDestinationId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteShopShippingProfileDestinationValidateBeforeCall(shopId, shippingProfileId, shippingProfileDestinationId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteShopShippingProfileUpgradeCall(Long shopId, Long shippingProfileId, Long upgradeId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/shipping-profiles/{shipping_profile_id}/upgrades/{upgrade_id}".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString())).replace("{shipping_profile_id}", this.localVarApiClient.escapeString(shippingProfileId.toString())).replace("{upgrade_id}", this.localVarApiClient.escapeString(upgradeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteShopShippingProfileUpgradeValidateBeforeCall(Long shopId, Long shippingProfileId, Long upgradeId, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling deleteShopShippingProfileUpgrade(Async)");
        }
        if (shippingProfileId == null) {
            throw new ApiException("Missing the required parameter 'shippingProfileId' when calling deleteShopShippingProfileUpgrade(Async)");
        }
        if (upgradeId == null) {
            throw new ApiException("Missing the required parameter 'upgradeId' when calling deleteShopShippingProfileUpgrade(Async)");
        }
        return this.deleteShopShippingProfileUpgradeCall(shopId, shippingProfileId, upgradeId, _callback);
    }

    public void deleteShopShippingProfileUpgrade(Long shopId, Long shippingProfileId, Long upgradeId) throws ApiException {
        this.deleteShopShippingProfileUpgradeWithHttpInfo(shopId, shippingProfileId, upgradeId);
    }

    public ApiResponse<Void> deleteShopShippingProfileUpgradeWithHttpInfo(Long shopId, Long shippingProfileId, Long upgradeId) throws ApiException {
        Call localVarCall = this.deleteShopShippingProfileUpgradeValidateBeforeCall(shopId, shippingProfileId, upgradeId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteShopShippingProfileUpgradeAsync(Long shopId, Long shippingProfileId, Long upgradeId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteShopShippingProfileUpgradeValidateBeforeCall(shopId, shippingProfileId, upgradeId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getShippingCarriersCall(String originCountryIso, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shipping-carriers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (originCountryIso != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("origin_country_iso", originCountryIso));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getShippingCarriersValidateBeforeCall(String originCountryIso, ApiCallback _callback) throws ApiException {
        if (originCountryIso == null) {
            throw new ApiException("Missing the required parameter 'originCountryIso' when calling getShippingCarriers(Async)");
        }
        return this.getShippingCarriersCall(originCountryIso, _callback);
    }

    public ShippingCarriers getShippingCarriers(String originCountryIso) throws ApiException {
        ApiResponse<ShippingCarriers> localVarResp = this.getShippingCarriersWithHttpInfo(originCountryIso);
        return localVarResp.getData();
    }

    public ApiResponse<ShippingCarriers> getShippingCarriersWithHttpInfo(String originCountryIso) throws ApiException {
        Call localVarCall = this.getShippingCarriersValidateBeforeCall(originCountryIso, null);
        Type localVarReturnType = new TypeToken<ShippingCarriers>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getShippingCarriersAsync(String originCountryIso, ApiCallback<ShippingCarriers> _callback) throws ApiException {
        Call localVarCall = this.getShippingCarriersValidateBeforeCall(originCountryIso, _callback);
        Type localVarReturnType = new TypeToken<ShippingCarriers>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getShopShippingProfileCall(Long shopId, Long shippingProfileId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/shipping-profiles/{shipping_profile_id}".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString())).replace("{shipping_profile_id}", this.localVarApiClient.escapeString(shippingProfileId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getShopShippingProfileValidateBeforeCall(Long shopId, Long shippingProfileId, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling getShopShippingProfile(Async)");
        }
        if (shippingProfileId == null) {
            throw new ApiException("Missing the required parameter 'shippingProfileId' when calling getShopShippingProfile(Async)");
        }
        return this.getShopShippingProfileCall(shopId, shippingProfileId, _callback);
    }

    public ShopShippingProfile getShopShippingProfile(Long shopId, Long shippingProfileId) throws ApiException {
        ApiResponse<ShopShippingProfile> localVarResp = this.getShopShippingProfileWithHttpInfo(shopId, shippingProfileId);
        return localVarResp.getData();
    }

    public ApiResponse<ShopShippingProfile> getShopShippingProfileWithHttpInfo(Long shopId, Long shippingProfileId) throws ApiException {
        Call localVarCall = this.getShopShippingProfileValidateBeforeCall(shopId, shippingProfileId, null);
        Type localVarReturnType = new TypeToken<ShopShippingProfile>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getShopShippingProfileAsync(Long shopId, Long shippingProfileId, ApiCallback<ShopShippingProfile> _callback) throws ApiException {
        Call localVarCall = this.getShopShippingProfileValidateBeforeCall(shopId, shippingProfileId, _callback);
        Type localVarReturnType = new TypeToken<ShopShippingProfile>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getShopShippingProfileDestinationsByShippingProfileCall(Long shopId, Long shippingProfileId, Long limit, Long offset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/shipping-profiles/{shipping_profile_id}/destinations".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString())).replace("{shipping_profile_id}", this.localVarApiClient.escapeString(shippingProfileId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getShopShippingProfileDestinationsByShippingProfileValidateBeforeCall(Long shopId, Long shippingProfileId, Long limit, Long offset, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling getShopShippingProfileDestinationsByShippingProfile(Async)");
        }
        if (shippingProfileId == null) {
            throw new ApiException("Missing the required parameter 'shippingProfileId' when calling getShopShippingProfileDestinationsByShippingProfile(Async)");
        }
        return this.getShopShippingProfileDestinationsByShippingProfileCall(shopId, shippingProfileId, limit, offset, _callback);
    }

    public ShopShippingProfileDestinations getShopShippingProfileDestinationsByShippingProfile(Long shopId, Long shippingProfileId, Long limit, Long offset) throws ApiException {
        ApiResponse<ShopShippingProfileDestinations> localVarResp = this.getShopShippingProfileDestinationsByShippingProfileWithHttpInfo(shopId, shippingProfileId, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<ShopShippingProfileDestinations> getShopShippingProfileDestinationsByShippingProfileWithHttpInfo(Long shopId, Long shippingProfileId, Long limit, Long offset) throws ApiException {
        Call localVarCall = this.getShopShippingProfileDestinationsByShippingProfileValidateBeforeCall(shopId, shippingProfileId, limit, offset, null);
        Type localVarReturnType = new TypeToken<ShopShippingProfileDestinations>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getShopShippingProfileDestinationsByShippingProfileAsync(Long shopId, Long shippingProfileId, Long limit, Long offset, ApiCallback<ShopShippingProfileDestinations> _callback) throws ApiException {
        Call localVarCall = this.getShopShippingProfileDestinationsByShippingProfileValidateBeforeCall(shopId, shippingProfileId, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<ShopShippingProfileDestinations>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getShopShippingProfileUpgradesCall(Long shopId, Long shippingProfileId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/shipping-profiles/{shipping_profile_id}/upgrades".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString())).replace("{shipping_profile_id}", this.localVarApiClient.escapeString(shippingProfileId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getShopShippingProfileUpgradesValidateBeforeCall(Long shopId, Long shippingProfileId, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling getShopShippingProfileUpgrades(Async)");
        }
        if (shippingProfileId == null) {
            throw new ApiException("Missing the required parameter 'shippingProfileId' when calling getShopShippingProfileUpgrades(Async)");
        }
        return this.getShopShippingProfileUpgradesCall(shopId, shippingProfileId, _callback);
    }

    public ShopShippingProfileUpgrades getShopShippingProfileUpgrades(Long shopId, Long shippingProfileId) throws ApiException {
        ApiResponse<ShopShippingProfileUpgrades> localVarResp = this.getShopShippingProfileUpgradesWithHttpInfo(shopId, shippingProfileId);
        return localVarResp.getData();
    }

    public ApiResponse<ShopShippingProfileUpgrades> getShopShippingProfileUpgradesWithHttpInfo(Long shopId, Long shippingProfileId) throws ApiException {
        Call localVarCall = this.getShopShippingProfileUpgradesValidateBeforeCall(shopId, shippingProfileId, null);
        Type localVarReturnType = new TypeToken<ShopShippingProfileUpgrades>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getShopShippingProfileUpgradesAsync(Long shopId, Long shippingProfileId, ApiCallback<ShopShippingProfileUpgrades> _callback) throws ApiException {
        Call localVarCall = this.getShopShippingProfileUpgradesValidateBeforeCall(shopId, shippingProfileId, _callback);
        Type localVarReturnType = new TypeToken<ShopShippingProfileUpgrades>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getShopShippingProfilesCall(Long shopId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/shipping-profiles".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getShopShippingProfilesValidateBeforeCall(Long shopId, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling getShopShippingProfiles(Async)");
        }
        return this.getShopShippingProfilesCall(shopId, _callback);
    }

    public ShopShippingProfiles getShopShippingProfiles(Long shopId) throws ApiException {
        ApiResponse<ShopShippingProfiles> localVarResp = this.getShopShippingProfilesWithHttpInfo(shopId);
        return localVarResp.getData();
    }

    public ApiResponse<ShopShippingProfiles> getShopShippingProfilesWithHttpInfo(Long shopId) throws ApiException {
        Call localVarCall = this.getShopShippingProfilesValidateBeforeCall(shopId, null);
        Type localVarReturnType = new TypeToken<ShopShippingProfiles>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getShopShippingProfilesAsync(Long shopId, ApiCallback<ShopShippingProfiles> _callback) throws ApiException {
        Call localVarCall = this.getShopShippingProfilesValidateBeforeCall(shopId, _callback);
        Type localVarReturnType = new TypeToken<ShopShippingProfiles>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateShopShippingProfileCall(Long shopId, Long shippingProfileId, String title, String originCountryIso, Long minProcessingTime, Long maxProcessingTime, String processingTimeUnit, String originPostalCode, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/shipping-profiles/{shipping_profile_id}".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString())).replace("{shipping_profile_id}", this.localVarApiClient.escapeString(shippingProfileId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (title != null) {
            localVarFormParams.put("title", title);
        }
        if (originCountryIso != null) {
            localVarFormParams.put("origin_country_iso", originCountryIso);
        }
        if (minProcessingTime != null) {
            localVarFormParams.put("min_processing_time", minProcessingTime);
        }
        if (maxProcessingTime != null) {
            localVarFormParams.put("max_processing_time", maxProcessingTime);
        }
        if (processingTimeUnit != null) {
            localVarFormParams.put("processing_time_unit", processingTimeUnit);
        }
        if (originPostalCode != null) {
            localVarFormParams.put("origin_postal_code", originPostalCode);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/x-www-form-urlencoded"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateShopShippingProfileValidateBeforeCall(Long shopId, Long shippingProfileId, String title, String originCountryIso, Long minProcessingTime, Long maxProcessingTime, String processingTimeUnit, String originPostalCode, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling updateShopShippingProfile(Async)");
        }
        if (shippingProfileId == null) {
            throw new ApiException("Missing the required parameter 'shippingProfileId' when calling updateShopShippingProfile(Async)");
        }
        return this.updateShopShippingProfileCall(shopId, shippingProfileId, title, originCountryIso, minProcessingTime, maxProcessingTime, processingTimeUnit, originPostalCode, _callback);
    }

    public ShopShippingProfile updateShopShippingProfile(Long shopId, Long shippingProfileId, String title, String originCountryIso, Long minProcessingTime, Long maxProcessingTime, String processingTimeUnit, String originPostalCode) throws ApiException {
        ApiResponse<ShopShippingProfile> localVarResp = this.updateShopShippingProfileWithHttpInfo(shopId, shippingProfileId, title, originCountryIso, minProcessingTime, maxProcessingTime, processingTimeUnit, originPostalCode);
        return localVarResp.getData();
    }

    public ApiResponse<ShopShippingProfile> updateShopShippingProfileWithHttpInfo(Long shopId, Long shippingProfileId, String title, String originCountryIso, Long minProcessingTime, Long maxProcessingTime, String processingTimeUnit, String originPostalCode) throws ApiException {
        Call localVarCall = this.updateShopShippingProfileValidateBeforeCall(shopId, shippingProfileId, title, originCountryIso, minProcessingTime, maxProcessingTime, processingTimeUnit, originPostalCode, null);
        Type localVarReturnType = new TypeToken<ShopShippingProfile>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateShopShippingProfileAsync(Long shopId, Long shippingProfileId, String title, String originCountryIso, Long minProcessingTime, Long maxProcessingTime, String processingTimeUnit, String originPostalCode, ApiCallback<ShopShippingProfile> _callback) throws ApiException {
        Call localVarCall = this.updateShopShippingProfileValidateBeforeCall(shopId, shippingProfileId, title, originCountryIso, minProcessingTime, maxProcessingTime, processingTimeUnit, originPostalCode, _callback);
        Type localVarReturnType = new TypeToken<ShopShippingProfile>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateShopShippingProfileDestinationCall(Long shopId, Long shippingProfileId, Long shippingProfileDestinationId, Float primaryCost, Float secondaryCost, String destinationCountryIso, String destinationRegion, Long shippingCarrierId, String mailClass, Long minDeliveryDays, Long maxDeliveryDays, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/shipping-profiles/{shipping_profile_id}/destinations/{shipping_profile_destination_id}".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString())).replace("{shipping_profile_id}", this.localVarApiClient.escapeString(shippingProfileId.toString())).replace("{shipping_profile_destination_id}", this.localVarApiClient.escapeString(shippingProfileDestinationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (primaryCost != null) {
            localVarFormParams.put("primary_cost", primaryCost);
        }
        if (secondaryCost != null) {
            localVarFormParams.put("secondary_cost", secondaryCost);
        }
        if (destinationCountryIso != null) {
            localVarFormParams.put("destination_country_iso", destinationCountryIso);
        }
        if (destinationRegion != null) {
            localVarFormParams.put("destination_region", destinationRegion);
        }
        if (shippingCarrierId != null) {
            localVarFormParams.put("shipping_carrier_id", shippingCarrierId);
        }
        if (mailClass != null) {
            localVarFormParams.put("mail_class", mailClass);
        }
        if (minDeliveryDays != null) {
            localVarFormParams.put("min_delivery_days", minDeliveryDays);
        }
        if (maxDeliveryDays != null) {
            localVarFormParams.put("max_delivery_days", maxDeliveryDays);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/x-www-form-urlencoded"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateShopShippingProfileDestinationValidateBeforeCall(Long shopId, Long shippingProfileId, Long shippingProfileDestinationId, Float primaryCost, Float secondaryCost, String destinationCountryIso, String destinationRegion, Long shippingCarrierId, String mailClass, Long minDeliveryDays, Long maxDeliveryDays, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling updateShopShippingProfileDestination(Async)");
        }
        if (shippingProfileId == null) {
            throw new ApiException("Missing the required parameter 'shippingProfileId' when calling updateShopShippingProfileDestination(Async)");
        }
        if (shippingProfileDestinationId == null) {
            throw new ApiException("Missing the required parameter 'shippingProfileDestinationId' when calling updateShopShippingProfileDestination(Async)");
        }
        return this.updateShopShippingProfileDestinationCall(shopId, shippingProfileId, shippingProfileDestinationId, primaryCost, secondaryCost, destinationCountryIso, destinationRegion, shippingCarrierId, mailClass, minDeliveryDays, maxDeliveryDays, _callback);
    }

    public ShopShippingProfileDestination updateShopShippingProfileDestination(Long shopId, Long shippingProfileId, Long shippingProfileDestinationId, Float primaryCost, Float secondaryCost, String destinationCountryIso, String destinationRegion, Long shippingCarrierId, String mailClass, Long minDeliveryDays, Long maxDeliveryDays) throws ApiException {
        ApiResponse<ShopShippingProfileDestination> localVarResp = this.updateShopShippingProfileDestinationWithHttpInfo(shopId, shippingProfileId, shippingProfileDestinationId, primaryCost, secondaryCost, destinationCountryIso, destinationRegion, shippingCarrierId, mailClass, minDeliveryDays, maxDeliveryDays);
        return localVarResp.getData();
    }

    public ApiResponse<ShopShippingProfileDestination> updateShopShippingProfileDestinationWithHttpInfo(Long shopId, Long shippingProfileId, Long shippingProfileDestinationId, Float primaryCost, Float secondaryCost, String destinationCountryIso, String destinationRegion, Long shippingCarrierId, String mailClass, Long minDeliveryDays, Long maxDeliveryDays) throws ApiException {
        Call localVarCall = this.updateShopShippingProfileDestinationValidateBeforeCall(shopId, shippingProfileId, shippingProfileDestinationId, primaryCost, secondaryCost, destinationCountryIso, destinationRegion, shippingCarrierId, mailClass, minDeliveryDays, maxDeliveryDays, null);
        Type localVarReturnType = new TypeToken<ShopShippingProfileDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateShopShippingProfileDestinationAsync(Long shopId, Long shippingProfileId, Long shippingProfileDestinationId, Float primaryCost, Float secondaryCost, String destinationCountryIso, String destinationRegion, Long shippingCarrierId, String mailClass, Long minDeliveryDays, Long maxDeliveryDays, ApiCallback<ShopShippingProfileDestination> _callback) throws ApiException {
        Call localVarCall = this.updateShopShippingProfileDestinationValidateBeforeCall(shopId, shippingProfileId, shippingProfileDestinationId, primaryCost, secondaryCost, destinationCountryIso, destinationRegion, shippingCarrierId, mailClass, minDeliveryDays, maxDeliveryDays, _callback);
        Type localVarReturnType = new TypeToken<ShopShippingProfileDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateShopShippingProfileUpgradeCall(Long shopId, Long shippingProfileId, Long upgradeId, String upgradeName, String type, Float price, Float secondaryPrice, Long shippingCarrierId, String mailClass, Long minDeliveryDays, Long maxDeliveryDays, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/shipping-profiles/{shipping_profile_id}/upgrades/{upgrade_id}".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString())).replace("{shipping_profile_id}", this.localVarApiClient.escapeString(shippingProfileId.toString())).replace("{upgrade_id}", this.localVarApiClient.escapeString(upgradeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (upgradeName != null) {
            localVarFormParams.put("upgrade_name", upgradeName);
        }
        if (type != null) {
            localVarFormParams.put("type", type);
        }
        if (price != null) {
            localVarFormParams.put("price", price);
        }
        if (secondaryPrice != null) {
            localVarFormParams.put("secondary_price", secondaryPrice);
        }
        if (shippingCarrierId != null) {
            localVarFormParams.put("shipping_carrier_id", shippingCarrierId);
        }
        if (mailClass != null) {
            localVarFormParams.put("mail_class", mailClass);
        }
        if (minDeliveryDays != null) {
            localVarFormParams.put("min_delivery_days", minDeliveryDays);
        }
        if (maxDeliveryDays != null) {
            localVarFormParams.put("max_delivery_days", maxDeliveryDays);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/x-www-form-urlencoded"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateShopShippingProfileUpgradeValidateBeforeCall(Long shopId, Long shippingProfileId, Long upgradeId, String upgradeName, String type, Float price, Float secondaryPrice, Long shippingCarrierId, String mailClass, Long minDeliveryDays, Long maxDeliveryDays, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling updateShopShippingProfileUpgrade(Async)");
        }
        if (shippingProfileId == null) {
            throw new ApiException("Missing the required parameter 'shippingProfileId' when calling updateShopShippingProfileUpgrade(Async)");
        }
        if (upgradeId == null) {
            throw new ApiException("Missing the required parameter 'upgradeId' when calling updateShopShippingProfileUpgrade(Async)");
        }
        return this.updateShopShippingProfileUpgradeCall(shopId, shippingProfileId, upgradeId, upgradeName, type, price, secondaryPrice, shippingCarrierId, mailClass, minDeliveryDays, maxDeliveryDays, _callback);
    }

    public ShopShippingProfileUpgrade updateShopShippingProfileUpgrade(Long shopId, Long shippingProfileId, Long upgradeId, String upgradeName, String type, Float price, Float secondaryPrice, Long shippingCarrierId, String mailClass, Long minDeliveryDays, Long maxDeliveryDays) throws ApiException {
        ApiResponse<ShopShippingProfileUpgrade> localVarResp = this.updateShopShippingProfileUpgradeWithHttpInfo(shopId, shippingProfileId, upgradeId, upgradeName, type, price, secondaryPrice, shippingCarrierId, mailClass, minDeliveryDays, maxDeliveryDays);
        return localVarResp.getData();
    }

    public ApiResponse<ShopShippingProfileUpgrade> updateShopShippingProfileUpgradeWithHttpInfo(Long shopId, Long shippingProfileId, Long upgradeId, String upgradeName, String type, Float price, Float secondaryPrice, Long shippingCarrierId, String mailClass, Long minDeliveryDays, Long maxDeliveryDays) throws ApiException {
        Call localVarCall = this.updateShopShippingProfileUpgradeValidateBeforeCall(shopId, shippingProfileId, upgradeId, upgradeName, type, price, secondaryPrice, shippingCarrierId, mailClass, minDeliveryDays, maxDeliveryDays, null);
        Type localVarReturnType = new TypeToken<ShopShippingProfileUpgrade>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateShopShippingProfileUpgradeAsync(Long shopId, Long shippingProfileId, Long upgradeId, String upgradeName, String type, Float price, Float secondaryPrice, Long shippingCarrierId, String mailClass, Long minDeliveryDays, Long maxDeliveryDays, ApiCallback<ShopShippingProfileUpgrade> _callback) throws ApiException {
        Call localVarCall = this.updateShopShippingProfileUpgradeValidateBeforeCall(shopId, shippingProfileId, upgradeId, upgradeName, type, price, secondaryPrice, shippingCarrierId, mailClass, minDeliveryDays, maxDeliveryDays, _callback);
        Type localVarReturnType = new TypeToken<ShopShippingProfileUpgrade>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

