/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.ShopSection;
import org.openapitools.client.model.ShopSections;

public class ShopSectionApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ShopSectionApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ShopSectionApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createShopSectionCall(Long shopId, String title, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/sections".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (title != null) {
            localVarFormParams.put("title", title);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/x-www-form-urlencoded"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createShopSectionValidateBeforeCall(Long shopId, String title, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling createShopSection(Async)");
        }
        if (title == null) {
            throw new ApiException("Missing the required parameter 'title' when calling createShopSection(Async)");
        }
        return this.createShopSectionCall(shopId, title, _callback);
    }

    public ShopSection createShopSection(Long shopId, String title) throws ApiException {
        ApiResponse<ShopSection> localVarResp = this.createShopSectionWithHttpInfo(shopId, title);
        return localVarResp.getData();
    }

    public ApiResponse<ShopSection> createShopSectionWithHttpInfo(Long shopId, String title) throws ApiException {
        Call localVarCall = this.createShopSectionValidateBeforeCall(shopId, title, null);
        Type localVarReturnType = new TypeToken<ShopSection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createShopSectionAsync(Long shopId, String title, ApiCallback<ShopSection> _callback) throws ApiException {
        Call localVarCall = this.createShopSectionValidateBeforeCall(shopId, title, _callback);
        Type localVarReturnType = new TypeToken<ShopSection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteShopSectionCall(Long shopId, Long shopSectionId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/sections/{shop_section_id}".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString())).replace("{shop_section_id}", this.localVarApiClient.escapeString(shopSectionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteShopSectionValidateBeforeCall(Long shopId, Long shopSectionId, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling deleteShopSection(Async)");
        }
        if (shopSectionId == null) {
            throw new ApiException("Missing the required parameter 'shopSectionId' when calling deleteShopSection(Async)");
        }
        return this.deleteShopSectionCall(shopId, shopSectionId, _callback);
    }

    public void deleteShopSection(Long shopId, Long shopSectionId) throws ApiException {
        this.deleteShopSectionWithHttpInfo(shopId, shopSectionId);
    }

    public ApiResponse<Void> deleteShopSectionWithHttpInfo(Long shopId, Long shopSectionId) throws ApiException {
        Call localVarCall = this.deleteShopSectionValidateBeforeCall(shopId, shopSectionId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteShopSectionAsync(Long shopId, Long shopSectionId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteShopSectionValidateBeforeCall(shopId, shopSectionId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getShopSectionCall(Long shopId, Long shopSectionId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/sections/{shop_section_id}".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString())).replace("{shop_section_id}", this.localVarApiClient.escapeString(shopSectionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getShopSectionValidateBeforeCall(Long shopId, Long shopSectionId, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling getShopSection(Async)");
        }
        if (shopSectionId == null) {
            throw new ApiException("Missing the required parameter 'shopSectionId' when calling getShopSection(Async)");
        }
        return this.getShopSectionCall(shopId, shopSectionId, _callback);
    }

    public ShopSection getShopSection(Long shopId, Long shopSectionId) throws ApiException {
        ApiResponse<ShopSection> localVarResp = this.getShopSectionWithHttpInfo(shopId, shopSectionId);
        return localVarResp.getData();
    }

    public ApiResponse<ShopSection> getShopSectionWithHttpInfo(Long shopId, Long shopSectionId) throws ApiException {
        Call localVarCall = this.getShopSectionValidateBeforeCall(shopId, shopSectionId, null);
        Type localVarReturnType = new TypeToken<ShopSection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getShopSectionAsync(Long shopId, Long shopSectionId, ApiCallback<ShopSection> _callback) throws ApiException {
        Call localVarCall = this.getShopSectionValidateBeforeCall(shopId, shopSectionId, _callback);
        Type localVarReturnType = new TypeToken<ShopSection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getShopSectionsCall(Long shopId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/sections".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getShopSectionsValidateBeforeCall(Long shopId, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling getShopSections(Async)");
        }
        return this.getShopSectionsCall(shopId, _callback);
    }

    public ShopSections getShopSections(Long shopId) throws ApiException {
        ApiResponse<ShopSections> localVarResp = this.getShopSectionsWithHttpInfo(shopId);
        return localVarResp.getData();
    }

    public ApiResponse<ShopSections> getShopSectionsWithHttpInfo(Long shopId) throws ApiException {
        Call localVarCall = this.getShopSectionsValidateBeforeCall(shopId, null);
        Type localVarReturnType = new TypeToken<ShopSections>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getShopSectionsAsync(Long shopId, ApiCallback<ShopSections> _callback) throws ApiException {
        Call localVarCall = this.getShopSectionsValidateBeforeCall(shopId, _callback);
        Type localVarReturnType = new TypeToken<ShopSections>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateShopSectionCall(Long shopId, Long shopSectionId, String title, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/sections/{shop_section_id}".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString())).replace("{shop_section_id}", this.localVarApiClient.escapeString(shopSectionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (title != null) {
            localVarFormParams.put("title", title);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/x-www-form-urlencoded"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateShopSectionValidateBeforeCall(Long shopId, Long shopSectionId, String title, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling updateShopSection(Async)");
        }
        if (shopSectionId == null) {
            throw new ApiException("Missing the required parameter 'shopSectionId' when calling updateShopSection(Async)");
        }
        if (title == null) {
            throw new ApiException("Missing the required parameter 'title' when calling updateShopSection(Async)");
        }
        return this.updateShopSectionCall(shopId, shopSectionId, title, _callback);
    }

    public ShopSection updateShopSection(Long shopId, Long shopSectionId, String title) throws ApiException {
        ApiResponse<ShopSection> localVarResp = this.updateShopSectionWithHttpInfo(shopId, shopSectionId, title);
        return localVarResp.getData();
    }

    public ApiResponse<ShopSection> updateShopSectionWithHttpInfo(Long shopId, Long shopSectionId, String title) throws ApiException {
        Call localVarCall = this.updateShopSectionValidateBeforeCall(shopId, shopSectionId, title, null);
        Type localVarReturnType = new TypeToken<ShopSection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateShopSectionAsync(Long shopId, Long shopSectionId, String title, ApiCallback<ShopSection> _callback) throws ApiException {
        Call localVarCall = this.updateShopSectionValidateBeforeCall(shopId, shopSectionId, title, _callback);
        Type localVarReturnType = new TypeToken<ShopSection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

