/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.ShopReturnPolicies;
import org.openapitools.client.model.ShopReturnPolicy;

public class ShopReturnPolicyApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ShopReturnPolicyApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ShopReturnPolicyApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call consolidateShopReturnPoliciesCall(Long shopId, Long sourceReturnPolicyId, Long destinationReturnPolicyId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/policies/return/consolidate".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (sourceReturnPolicyId != null) {
            localVarFormParams.put("source_return_policy_id", sourceReturnPolicyId);
        }
        if (destinationReturnPolicyId != null) {
            localVarFormParams.put("destination_return_policy_id", destinationReturnPolicyId);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/x-www-form-urlencoded"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call consolidateShopReturnPoliciesValidateBeforeCall(Long shopId, Long sourceReturnPolicyId, Long destinationReturnPolicyId, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling consolidateShopReturnPolicies(Async)");
        }
        if (sourceReturnPolicyId == null) {
            throw new ApiException("Missing the required parameter 'sourceReturnPolicyId' when calling consolidateShopReturnPolicies(Async)");
        }
        if (destinationReturnPolicyId == null) {
            throw new ApiException("Missing the required parameter 'destinationReturnPolicyId' when calling consolidateShopReturnPolicies(Async)");
        }
        return this.consolidateShopReturnPoliciesCall(shopId, sourceReturnPolicyId, destinationReturnPolicyId, _callback);
    }

    public ShopReturnPolicy consolidateShopReturnPolicies(Long shopId, Long sourceReturnPolicyId, Long destinationReturnPolicyId) throws ApiException {
        ApiResponse<ShopReturnPolicy> localVarResp = this.consolidateShopReturnPoliciesWithHttpInfo(shopId, sourceReturnPolicyId, destinationReturnPolicyId);
        return localVarResp.getData();
    }

    public ApiResponse<ShopReturnPolicy> consolidateShopReturnPoliciesWithHttpInfo(Long shopId, Long sourceReturnPolicyId, Long destinationReturnPolicyId) throws ApiException {
        Call localVarCall = this.consolidateShopReturnPoliciesValidateBeforeCall(shopId, sourceReturnPolicyId, destinationReturnPolicyId, null);
        Type localVarReturnType = new TypeToken<ShopReturnPolicy>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call consolidateShopReturnPoliciesAsync(Long shopId, Long sourceReturnPolicyId, Long destinationReturnPolicyId, ApiCallback<ShopReturnPolicy> _callback) throws ApiException {
        Call localVarCall = this.consolidateShopReturnPoliciesValidateBeforeCall(shopId, sourceReturnPolicyId, destinationReturnPolicyId, _callback);
        Type localVarReturnType = new TypeToken<ShopReturnPolicy>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createShopReturnPolicyCall(Long shopId, Boolean acceptsReturns, Boolean acceptsExchanges, Long returnDeadline, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/policies/return".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptsReturns != null) {
            localVarFormParams.put("accepts_returns", acceptsReturns);
        }
        if (acceptsExchanges != null) {
            localVarFormParams.put("accepts_exchanges", acceptsExchanges);
        }
        if (returnDeadline != null) {
            localVarFormParams.put("return_deadline", returnDeadline);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/x-www-form-urlencoded"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createShopReturnPolicyValidateBeforeCall(Long shopId, Boolean acceptsReturns, Boolean acceptsExchanges, Long returnDeadline, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling createShopReturnPolicy(Async)");
        }
        if (acceptsReturns == null) {
            throw new ApiException("Missing the required parameter 'acceptsReturns' when calling createShopReturnPolicy(Async)");
        }
        if (acceptsExchanges == null) {
            throw new ApiException("Missing the required parameter 'acceptsExchanges' when calling createShopReturnPolicy(Async)");
        }
        return this.createShopReturnPolicyCall(shopId, acceptsReturns, acceptsExchanges, returnDeadline, _callback);
    }

    public ShopReturnPolicy createShopReturnPolicy(Long shopId, Boolean acceptsReturns, Boolean acceptsExchanges, Long returnDeadline) throws ApiException {
        ApiResponse<ShopReturnPolicy> localVarResp = this.createShopReturnPolicyWithHttpInfo(shopId, acceptsReturns, acceptsExchanges, returnDeadline);
        return localVarResp.getData();
    }

    public ApiResponse<ShopReturnPolicy> createShopReturnPolicyWithHttpInfo(Long shopId, Boolean acceptsReturns, Boolean acceptsExchanges, Long returnDeadline) throws ApiException {
        Call localVarCall = this.createShopReturnPolicyValidateBeforeCall(shopId, acceptsReturns, acceptsExchanges, returnDeadline, null);
        Type localVarReturnType = new TypeToken<ShopReturnPolicy>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createShopReturnPolicyAsync(Long shopId, Boolean acceptsReturns, Boolean acceptsExchanges, Long returnDeadline, ApiCallback<ShopReturnPolicy> _callback) throws ApiException {
        Call localVarCall = this.createShopReturnPolicyValidateBeforeCall(shopId, acceptsReturns, acceptsExchanges, returnDeadline, _callback);
        Type localVarReturnType = new TypeToken<ShopReturnPolicy>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteShopReturnPolicyCall(Long shopId, Long returnPolicyId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/policies/return/{return_policy_id}".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString())).replace("{return_policy_id}", this.localVarApiClient.escapeString(returnPolicyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteShopReturnPolicyValidateBeforeCall(Long shopId, Long returnPolicyId, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling deleteShopReturnPolicy(Async)");
        }
        if (returnPolicyId == null) {
            throw new ApiException("Missing the required parameter 'returnPolicyId' when calling deleteShopReturnPolicy(Async)");
        }
        return this.deleteShopReturnPolicyCall(shopId, returnPolicyId, _callback);
    }

    public void deleteShopReturnPolicy(Long shopId, Long returnPolicyId) throws ApiException {
        this.deleteShopReturnPolicyWithHttpInfo(shopId, returnPolicyId);
    }

    public ApiResponse<Void> deleteShopReturnPolicyWithHttpInfo(Long shopId, Long returnPolicyId) throws ApiException {
        Call localVarCall = this.deleteShopReturnPolicyValidateBeforeCall(shopId, returnPolicyId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteShopReturnPolicyAsync(Long shopId, Long returnPolicyId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteShopReturnPolicyValidateBeforeCall(shopId, returnPolicyId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getShopReturnPoliciesCall(Long shopId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/policies/return".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getShopReturnPoliciesValidateBeforeCall(Long shopId, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling getShopReturnPolicies(Async)");
        }
        return this.getShopReturnPoliciesCall(shopId, _callback);
    }

    public ShopReturnPolicies getShopReturnPolicies(Long shopId) throws ApiException {
        ApiResponse<ShopReturnPolicies> localVarResp = this.getShopReturnPoliciesWithHttpInfo(shopId);
        return localVarResp.getData();
    }

    public ApiResponse<ShopReturnPolicies> getShopReturnPoliciesWithHttpInfo(Long shopId) throws ApiException {
        Call localVarCall = this.getShopReturnPoliciesValidateBeforeCall(shopId, null);
        Type localVarReturnType = new TypeToken<ShopReturnPolicies>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getShopReturnPoliciesAsync(Long shopId, ApiCallback<ShopReturnPolicies> _callback) throws ApiException {
        Call localVarCall = this.getShopReturnPoliciesValidateBeforeCall(shopId, _callback);
        Type localVarReturnType = new TypeToken<ShopReturnPolicies>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getShopReturnPolicyCall(Long shopId, Long returnPolicyId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/policies/return/{return_policy_id}".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString())).replace("{return_policy_id}", this.localVarApiClient.escapeString(returnPolicyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getShopReturnPolicyValidateBeforeCall(Long shopId, Long returnPolicyId, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling getShopReturnPolicy(Async)");
        }
        if (returnPolicyId == null) {
            throw new ApiException("Missing the required parameter 'returnPolicyId' when calling getShopReturnPolicy(Async)");
        }
        return this.getShopReturnPolicyCall(shopId, returnPolicyId, _callback);
    }

    public ShopReturnPolicy getShopReturnPolicy(Long shopId, Long returnPolicyId) throws ApiException {
        ApiResponse<ShopReturnPolicy> localVarResp = this.getShopReturnPolicyWithHttpInfo(shopId, returnPolicyId);
        return localVarResp.getData();
    }

    public ApiResponse<ShopReturnPolicy> getShopReturnPolicyWithHttpInfo(Long shopId, Long returnPolicyId) throws ApiException {
        Call localVarCall = this.getShopReturnPolicyValidateBeforeCall(shopId, returnPolicyId, null);
        Type localVarReturnType = new TypeToken<ShopReturnPolicy>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getShopReturnPolicyAsync(Long shopId, Long returnPolicyId, ApiCallback<ShopReturnPolicy> _callback) throws ApiException {
        Call localVarCall = this.getShopReturnPolicyValidateBeforeCall(shopId, returnPolicyId, _callback);
        Type localVarReturnType = new TypeToken<ShopReturnPolicy>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateShopReturnPolicyCall(Long shopId, Long returnPolicyId, Boolean acceptsReturns, Boolean acceptsExchanges, Long returnDeadline, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/policies/return/{return_policy_id}".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString())).replace("{return_policy_id}", this.localVarApiClient.escapeString(returnPolicyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptsReturns != null) {
            localVarFormParams.put("accepts_returns", acceptsReturns);
        }
        if (acceptsExchanges != null) {
            localVarFormParams.put("accepts_exchanges", acceptsExchanges);
        }
        if (returnDeadline != null) {
            localVarFormParams.put("return_deadline", returnDeadline);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/x-www-form-urlencoded"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateShopReturnPolicyValidateBeforeCall(Long shopId, Long returnPolicyId, Boolean acceptsReturns, Boolean acceptsExchanges, Long returnDeadline, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling updateShopReturnPolicy(Async)");
        }
        if (returnPolicyId == null) {
            throw new ApiException("Missing the required parameter 'returnPolicyId' when calling updateShopReturnPolicy(Async)");
        }
        if (acceptsReturns == null) {
            throw new ApiException("Missing the required parameter 'acceptsReturns' when calling updateShopReturnPolicy(Async)");
        }
        if (acceptsExchanges == null) {
            throw new ApiException("Missing the required parameter 'acceptsExchanges' when calling updateShopReturnPolicy(Async)");
        }
        return this.updateShopReturnPolicyCall(shopId, returnPolicyId, acceptsReturns, acceptsExchanges, returnDeadline, _callback);
    }

    public ShopReturnPolicy updateShopReturnPolicy(Long shopId, Long returnPolicyId, Boolean acceptsReturns, Boolean acceptsExchanges, Long returnDeadline) throws ApiException {
        ApiResponse<ShopReturnPolicy> localVarResp = this.updateShopReturnPolicyWithHttpInfo(shopId, returnPolicyId, acceptsReturns, acceptsExchanges, returnDeadline);
        return localVarResp.getData();
    }

    public ApiResponse<ShopReturnPolicy> updateShopReturnPolicyWithHttpInfo(Long shopId, Long returnPolicyId, Boolean acceptsReturns, Boolean acceptsExchanges, Long returnDeadline) throws ApiException {
        Call localVarCall = this.updateShopReturnPolicyValidateBeforeCall(shopId, returnPolicyId, acceptsReturns, acceptsExchanges, returnDeadline, null);
        Type localVarReturnType = new TypeToken<ShopReturnPolicy>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateShopReturnPolicyAsync(Long shopId, Long returnPolicyId, Boolean acceptsReturns, Boolean acceptsExchanges, Long returnDeadline, ApiCallback<ShopReturnPolicy> _callback) throws ApiException {
        Call localVarCall = this.updateShopReturnPolicyValidateBeforeCall(shopId, returnPolicyId, acceptsReturns, acceptsExchanges, returnDeadline, _callback);
        Type localVarReturnType = new TypeToken<ShopReturnPolicy>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

