/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.ShopReceiptTransaction;
import org.openapitools.client.model.ShopReceiptTransactions;

public class ShopReceiptTransactionsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ShopReceiptTransactionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ShopReceiptTransactionsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call getShopReceiptTransactionCall(Long shopId, Long transactionId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/transactions/{transaction_id}".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString())).replace("{transaction_id}", this.localVarApiClient.escapeString(transactionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getShopReceiptTransactionValidateBeforeCall(Long shopId, Long transactionId, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling getShopReceiptTransaction(Async)");
        }
        if (transactionId == null) {
            throw new ApiException("Missing the required parameter 'transactionId' when calling getShopReceiptTransaction(Async)");
        }
        return this.getShopReceiptTransactionCall(shopId, transactionId, _callback);
    }

    public ShopReceiptTransaction getShopReceiptTransaction(Long shopId, Long transactionId) throws ApiException {
        ApiResponse<ShopReceiptTransaction> localVarResp = this.getShopReceiptTransactionWithHttpInfo(shopId, transactionId);
        return localVarResp.getData();
    }

    public ApiResponse<ShopReceiptTransaction> getShopReceiptTransactionWithHttpInfo(Long shopId, Long transactionId) throws ApiException {
        Call localVarCall = this.getShopReceiptTransactionValidateBeforeCall(shopId, transactionId, null);
        Type localVarReturnType = new TypeToken<ShopReceiptTransaction>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getShopReceiptTransactionAsync(Long shopId, Long transactionId, ApiCallback<ShopReceiptTransaction> _callback) throws ApiException {
        Call localVarCall = this.getShopReceiptTransactionValidateBeforeCall(shopId, transactionId, _callback);
        Type localVarReturnType = new TypeToken<ShopReceiptTransaction>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getShopReceiptTransactionsByListingCall(Long shopId, Long listingId, Long limit, Long offset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/listings/{listing_id}/transactions".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString())).replace("{listing_id}", this.localVarApiClient.escapeString(listingId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getShopReceiptTransactionsByListingValidateBeforeCall(Long shopId, Long listingId, Long limit, Long offset, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling getShopReceiptTransactionsByListing(Async)");
        }
        if (listingId == null) {
            throw new ApiException("Missing the required parameter 'listingId' when calling getShopReceiptTransactionsByListing(Async)");
        }
        return this.getShopReceiptTransactionsByListingCall(shopId, listingId, limit, offset, _callback);
    }

    public ShopReceiptTransactions getShopReceiptTransactionsByListing(Long shopId, Long listingId, Long limit, Long offset) throws ApiException {
        ApiResponse<ShopReceiptTransactions> localVarResp = this.getShopReceiptTransactionsByListingWithHttpInfo(shopId, listingId, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<ShopReceiptTransactions> getShopReceiptTransactionsByListingWithHttpInfo(Long shopId, Long listingId, Long limit, Long offset) throws ApiException {
        Call localVarCall = this.getShopReceiptTransactionsByListingValidateBeforeCall(shopId, listingId, limit, offset, null);
        Type localVarReturnType = new TypeToken<ShopReceiptTransactions>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getShopReceiptTransactionsByListingAsync(Long shopId, Long listingId, Long limit, Long offset, ApiCallback<ShopReceiptTransactions> _callback) throws ApiException {
        Call localVarCall = this.getShopReceiptTransactionsByListingValidateBeforeCall(shopId, listingId, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<ShopReceiptTransactions>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getShopReceiptTransactionsByReceiptCall(Long shopId, Long receiptId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/receipts/{receipt_id}/transactions".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString())).replace("{receipt_id}", this.localVarApiClient.escapeString(receiptId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getShopReceiptTransactionsByReceiptValidateBeforeCall(Long shopId, Long receiptId, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling getShopReceiptTransactionsByReceipt(Async)");
        }
        if (receiptId == null) {
            throw new ApiException("Missing the required parameter 'receiptId' when calling getShopReceiptTransactionsByReceipt(Async)");
        }
        return this.getShopReceiptTransactionsByReceiptCall(shopId, receiptId, _callback);
    }

    public ShopReceiptTransactions getShopReceiptTransactionsByReceipt(Long shopId, Long receiptId) throws ApiException {
        ApiResponse<ShopReceiptTransactions> localVarResp = this.getShopReceiptTransactionsByReceiptWithHttpInfo(shopId, receiptId);
        return localVarResp.getData();
    }

    public ApiResponse<ShopReceiptTransactions> getShopReceiptTransactionsByReceiptWithHttpInfo(Long shopId, Long receiptId) throws ApiException {
        Call localVarCall = this.getShopReceiptTransactionsByReceiptValidateBeforeCall(shopId, receiptId, null);
        Type localVarReturnType = new TypeToken<ShopReceiptTransactions>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getShopReceiptTransactionsByReceiptAsync(Long shopId, Long receiptId, ApiCallback<ShopReceiptTransactions> _callback) throws ApiException {
        Call localVarCall = this.getShopReceiptTransactionsByReceiptValidateBeforeCall(shopId, receiptId, _callback);
        Type localVarReturnType = new TypeToken<ShopReceiptTransactions>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getShopReceiptTransactionsByShopCall(Long shopId, Long limit, Long offset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/transactions".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getShopReceiptTransactionsByShopValidateBeforeCall(Long shopId, Long limit, Long offset, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling getShopReceiptTransactionsByShop(Async)");
        }
        return this.getShopReceiptTransactionsByShopCall(shopId, limit, offset, _callback);
    }

    public ShopReceiptTransactions getShopReceiptTransactionsByShop(Long shopId, Long limit, Long offset) throws ApiException {
        ApiResponse<ShopReceiptTransactions> localVarResp = this.getShopReceiptTransactionsByShopWithHttpInfo(shopId, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<ShopReceiptTransactions> getShopReceiptTransactionsByShopWithHttpInfo(Long shopId, Long limit, Long offset) throws ApiException {
        Call localVarCall = this.getShopReceiptTransactionsByShopValidateBeforeCall(shopId, limit, offset, null);
        Type localVarReturnType = new TypeToken<ShopReceiptTransactions>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getShopReceiptTransactionsByShopAsync(Long shopId, Long limit, Long offset, ApiCallback<ShopReceiptTransactions> _callback) throws ApiException {
        Call localVarCall = this.getShopReceiptTransactionsByShopValidateBeforeCall(shopId, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<ShopReceiptTransactions>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

