/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.ShopReceipt;
import org.openapitools.client.model.ShopReceipts;

public class ShopReceiptApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ShopReceiptApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ShopReceiptApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createReceiptShipmentCall(Long shopId, Long receiptId, String trackingCode, String carrierName, Boolean sendBcc, String noteToBuyer, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/receipts/{receipt_id}/tracking".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString())).replace("{receipt_id}", this.localVarApiClient.escapeString(receiptId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (trackingCode != null) {
            localVarFormParams.put("tracking_code", trackingCode);
        }
        if (carrierName != null) {
            localVarFormParams.put("carrier_name", carrierName);
        }
        if (sendBcc != null) {
            localVarFormParams.put("send_bcc", sendBcc);
        }
        if (noteToBuyer != null) {
            localVarFormParams.put("note_to_buyer", noteToBuyer);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/x-www-form-urlencoded"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createReceiptShipmentValidateBeforeCall(Long shopId, Long receiptId, String trackingCode, String carrierName, Boolean sendBcc, String noteToBuyer, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling createReceiptShipment(Async)");
        }
        if (receiptId == null) {
            throw new ApiException("Missing the required parameter 'receiptId' when calling createReceiptShipment(Async)");
        }
        return this.createReceiptShipmentCall(shopId, receiptId, trackingCode, carrierName, sendBcc, noteToBuyer, _callback);
    }

    public ShopReceipt createReceiptShipment(Long shopId, Long receiptId, String trackingCode, String carrierName, Boolean sendBcc, String noteToBuyer) throws ApiException {
        ApiResponse<ShopReceipt> localVarResp = this.createReceiptShipmentWithHttpInfo(shopId, receiptId, trackingCode, carrierName, sendBcc, noteToBuyer);
        return localVarResp.getData();
    }

    public ApiResponse<ShopReceipt> createReceiptShipmentWithHttpInfo(Long shopId, Long receiptId, String trackingCode, String carrierName, Boolean sendBcc, String noteToBuyer) throws ApiException {
        Call localVarCall = this.createReceiptShipmentValidateBeforeCall(shopId, receiptId, trackingCode, carrierName, sendBcc, noteToBuyer, null);
        Type localVarReturnType = new TypeToken<ShopReceipt>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createReceiptShipmentAsync(Long shopId, Long receiptId, String trackingCode, String carrierName, Boolean sendBcc, String noteToBuyer, ApiCallback<ShopReceipt> _callback) throws ApiException {
        Call localVarCall = this.createReceiptShipmentValidateBeforeCall(shopId, receiptId, trackingCode, carrierName, sendBcc, noteToBuyer, _callback);
        Type localVarReturnType = new TypeToken<ShopReceipt>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getShopReceiptCall(Long shopId, Long receiptId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/receipts/{receipt_id}".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString())).replace("{receipt_id}", this.localVarApiClient.escapeString(receiptId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getShopReceiptValidateBeforeCall(Long shopId, Long receiptId, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling getShopReceipt(Async)");
        }
        if (receiptId == null) {
            throw new ApiException("Missing the required parameter 'receiptId' when calling getShopReceipt(Async)");
        }
        return this.getShopReceiptCall(shopId, receiptId, _callback);
    }

    public ShopReceipt getShopReceipt(Long shopId, Long receiptId) throws ApiException {
        ApiResponse<ShopReceipt> localVarResp = this.getShopReceiptWithHttpInfo(shopId, receiptId);
        return localVarResp.getData();
    }

    public ApiResponse<ShopReceipt> getShopReceiptWithHttpInfo(Long shopId, Long receiptId) throws ApiException {
        Call localVarCall = this.getShopReceiptValidateBeforeCall(shopId, receiptId, null);
        Type localVarReturnType = new TypeToken<ShopReceipt>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getShopReceiptAsync(Long shopId, Long receiptId, ApiCallback<ShopReceipt> _callback) throws ApiException {
        Call localVarCall = this.getShopReceiptValidateBeforeCall(shopId, receiptId, _callback);
        Type localVarReturnType = new TypeToken<ShopReceipt>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getShopReceiptsCall(Long shopId, Long minCreated, Long maxCreated, Long minLastModified, Long maxLastModified, Long limit, Long offset, String sortOn, String sortOrder, Boolean wasPaid, Boolean wasShipped, Boolean wasDelivered, Boolean wasCanceled, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/receipts".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (minCreated != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("min_created", minCreated));
        }
        if (maxCreated != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_created", maxCreated));
        }
        if (minLastModified != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("min_last_modified", minLastModified));
        }
        if (maxLastModified != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_last_modified", maxLastModified));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (sortOn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort_on", sortOn));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort_order", sortOrder));
        }
        if (wasPaid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("was_paid", wasPaid));
        }
        if (wasShipped != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("was_shipped", wasShipped));
        }
        if (wasDelivered != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("was_delivered", wasDelivered));
        }
        if (wasCanceled != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("was_canceled", wasCanceled));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getShopReceiptsValidateBeforeCall(Long shopId, Long minCreated, Long maxCreated, Long minLastModified, Long maxLastModified, Long limit, Long offset, String sortOn, String sortOrder, Boolean wasPaid, Boolean wasShipped, Boolean wasDelivered, Boolean wasCanceled, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling getShopReceipts(Async)");
        }
        return this.getShopReceiptsCall(shopId, minCreated, maxCreated, minLastModified, maxLastModified, limit, offset, sortOn, sortOrder, wasPaid, wasShipped, wasDelivered, wasCanceled, _callback);
    }

    public ShopReceipts getShopReceipts(Long shopId, Long minCreated, Long maxCreated, Long minLastModified, Long maxLastModified, Long limit, Long offset, String sortOn, String sortOrder, Boolean wasPaid, Boolean wasShipped, Boolean wasDelivered, Boolean wasCanceled) throws ApiException {
        ApiResponse<ShopReceipts> localVarResp = this.getShopReceiptsWithHttpInfo(shopId, minCreated, maxCreated, minLastModified, maxLastModified, limit, offset, sortOn, sortOrder, wasPaid, wasShipped, wasDelivered, wasCanceled);
        return localVarResp.getData();
    }

    public ApiResponse<ShopReceipts> getShopReceiptsWithHttpInfo(Long shopId, Long minCreated, Long maxCreated, Long minLastModified, Long maxLastModified, Long limit, Long offset, String sortOn, String sortOrder, Boolean wasPaid, Boolean wasShipped, Boolean wasDelivered, Boolean wasCanceled) throws ApiException {
        Call localVarCall = this.getShopReceiptsValidateBeforeCall(shopId, minCreated, maxCreated, minLastModified, maxLastModified, limit, offset, sortOn, sortOrder, wasPaid, wasShipped, wasDelivered, wasCanceled, null);
        Type localVarReturnType = new TypeToken<ShopReceipts>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getShopReceiptsAsync(Long shopId, Long minCreated, Long maxCreated, Long minLastModified, Long maxLastModified, Long limit, Long offset, String sortOn, String sortOrder, Boolean wasPaid, Boolean wasShipped, Boolean wasDelivered, Boolean wasCanceled, ApiCallback<ShopReceipts> _callback) throws ApiException {
        Call localVarCall = this.getShopReceiptsValidateBeforeCall(shopId, minCreated, maxCreated, minLastModified, maxLastModified, limit, offset, sortOn, sortOrder, wasPaid, wasShipped, wasDelivered, wasCanceled, _callback);
        Type localVarReturnType = new TypeToken<ShopReceipts>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateShopReceiptCall(Long shopId, Long receiptId, Boolean wasShipped, Boolean wasPaid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/receipts/{receipt_id}".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString())).replace("{receipt_id}", this.localVarApiClient.escapeString(receiptId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (wasShipped != null) {
            localVarFormParams.put("was_shipped", wasShipped);
        }
        if (wasPaid != null) {
            localVarFormParams.put("was_paid", wasPaid);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/x-www-form-urlencoded"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateShopReceiptValidateBeforeCall(Long shopId, Long receiptId, Boolean wasShipped, Boolean wasPaid, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling updateShopReceipt(Async)");
        }
        if (receiptId == null) {
            throw new ApiException("Missing the required parameter 'receiptId' when calling updateShopReceipt(Async)");
        }
        return this.updateShopReceiptCall(shopId, receiptId, wasShipped, wasPaid, _callback);
    }

    public ShopReceipt updateShopReceipt(Long shopId, Long receiptId, Boolean wasShipped, Boolean wasPaid) throws ApiException {
        ApiResponse<ShopReceipt> localVarResp = this.updateShopReceiptWithHttpInfo(shopId, receiptId, wasShipped, wasPaid);
        return localVarResp.getData();
    }

    public ApiResponse<ShopReceipt> updateShopReceiptWithHttpInfo(Long shopId, Long receiptId, Boolean wasShipped, Boolean wasPaid) throws ApiException {
        Call localVarCall = this.updateShopReceiptValidateBeforeCall(shopId, receiptId, wasShipped, wasPaid, null);
        Type localVarReturnType = new TypeToken<ShopReceipt>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateShopReceiptAsync(Long shopId, Long receiptId, Boolean wasShipped, Boolean wasPaid, ApiCallback<ShopReceipt> _callback) throws ApiException {
        Call localVarCall = this.updateShopReceiptValidateBeforeCall(shopId, receiptId, wasShipped, wasPaid, _callback);
        Type localVarReturnType = new TypeToken<ShopReceipt>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

