/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.ShopProductionPartners;

public class ShopProductionPartnerApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ShopProductionPartnerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ShopProductionPartnerApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call getShopProductionPartnersCall(Long shopId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/production-partners".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getShopProductionPartnersValidateBeforeCall(Long shopId, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling getShopProductionPartners(Async)");
        }
        return this.getShopProductionPartnersCall(shopId, _callback);
    }

    public ShopProductionPartners getShopProductionPartners(Long shopId) throws ApiException {
        ApiResponse<ShopProductionPartners> localVarResp = this.getShopProductionPartnersWithHttpInfo(shopId);
        return localVarResp.getData();
    }

    public ApiResponse<ShopProductionPartners> getShopProductionPartnersWithHttpInfo(Long shopId) throws ApiException {
        Call localVarCall = this.getShopProductionPartnersValidateBeforeCall(shopId, null);
        Type localVarReturnType = new TypeToken<ShopProductionPartners>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getShopProductionPartnersAsync(Long shopId, ApiCallback<ShopProductionPartners> _callback) throws ApiException {
        Call localVarCall = this.getShopProductionPartnersValidateBeforeCall(shopId, _callback);
        Type localVarReturnType = new TypeToken<ShopProductionPartners>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

