/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.ListingVideo;
import org.openapitools.client.model.ListingVideos;

public class ShopListingVideoApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ShopListingVideoApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ShopListingVideoApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call deleteListingVideoCall(Long shopId, Long listingId, Long videoId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/listings/{listing_id}/videos/{video_id}".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString())).replace("{listing_id}", this.localVarApiClient.escapeString(listingId.toString())).replace("{video_id}", this.localVarApiClient.escapeString(videoId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteListingVideoValidateBeforeCall(Long shopId, Long listingId, Long videoId, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling deleteListingVideo(Async)");
        }
        if (listingId == null) {
            throw new ApiException("Missing the required parameter 'listingId' when calling deleteListingVideo(Async)");
        }
        if (videoId == null) {
            throw new ApiException("Missing the required parameter 'videoId' when calling deleteListingVideo(Async)");
        }
        return this.deleteListingVideoCall(shopId, listingId, videoId, _callback);
    }

    public void deleteListingVideo(Long shopId, Long listingId, Long videoId) throws ApiException {
        this.deleteListingVideoWithHttpInfo(shopId, listingId, videoId);
    }

    public ApiResponse<Void> deleteListingVideoWithHttpInfo(Long shopId, Long listingId, Long videoId) throws ApiException {
        Call localVarCall = this.deleteListingVideoValidateBeforeCall(shopId, listingId, videoId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteListingVideoAsync(Long shopId, Long listingId, Long videoId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteListingVideoValidateBeforeCall(shopId, listingId, videoId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getListingVideoCall(Long videoId, Long listingId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/listings/{listing_id}/videos/{video_id}".replace("{video_id}", this.localVarApiClient.escapeString(videoId.toString())).replace("{listing_id}", this.localVarApiClient.escapeString(listingId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getListingVideoValidateBeforeCall(Long videoId, Long listingId, ApiCallback _callback) throws ApiException {
        if (videoId == null) {
            throw new ApiException("Missing the required parameter 'videoId' when calling getListingVideo(Async)");
        }
        if (listingId == null) {
            throw new ApiException("Missing the required parameter 'listingId' when calling getListingVideo(Async)");
        }
        return this.getListingVideoCall(videoId, listingId, _callback);
    }

    public ListingVideo getListingVideo(Long videoId, Long listingId) throws ApiException {
        ApiResponse<ListingVideo> localVarResp = this.getListingVideoWithHttpInfo(videoId, listingId);
        return localVarResp.getData();
    }

    public ApiResponse<ListingVideo> getListingVideoWithHttpInfo(Long videoId, Long listingId) throws ApiException {
        Call localVarCall = this.getListingVideoValidateBeforeCall(videoId, listingId, null);
        Type localVarReturnType = new TypeToken<ListingVideo>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getListingVideoAsync(Long videoId, Long listingId, ApiCallback<ListingVideo> _callback) throws ApiException {
        Call localVarCall = this.getListingVideoValidateBeforeCall(videoId, listingId, _callback);
        Type localVarReturnType = new TypeToken<ListingVideo>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getListingVideosCall(Long listingId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/listings/{listing_id}/videos".replace("{listing_id}", this.localVarApiClient.escapeString(listingId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getListingVideosValidateBeforeCall(Long listingId, ApiCallback _callback) throws ApiException {
        if (listingId == null) {
            throw new ApiException("Missing the required parameter 'listingId' when calling getListingVideos(Async)");
        }
        return this.getListingVideosCall(listingId, _callback);
    }

    public ListingVideos getListingVideos(Long listingId) throws ApiException {
        ApiResponse<ListingVideos> localVarResp = this.getListingVideosWithHttpInfo(listingId);
        return localVarResp.getData();
    }

    public ApiResponse<ListingVideos> getListingVideosWithHttpInfo(Long listingId) throws ApiException {
        Call localVarCall = this.getListingVideosValidateBeforeCall(listingId, null);
        Type localVarReturnType = new TypeToken<ListingVideos>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getListingVideosAsync(Long listingId, ApiCallback<ListingVideos> _callback) throws ApiException {
        Call localVarCall = this.getListingVideosValidateBeforeCall(listingId, _callback);
        Type localVarReturnType = new TypeToken<ListingVideos>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call uploadListingVideoCall(Long shopId, Long listingId, Long videoId, File video, String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/listings/{listing_id}/videos".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString())).replace("{listing_id}", this.localVarApiClient.escapeString(listingId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (videoId != null) {
            localVarFormParams.put("video_id", videoId);
        }
        if (video != null) {
            localVarFormParams.put("video", video);
        }
        if (name != null) {
            localVarFormParams.put("name", name);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call uploadListingVideoValidateBeforeCall(Long shopId, Long listingId, Long videoId, File video, String name, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling uploadListingVideo(Async)");
        }
        if (listingId == null) {
            throw new ApiException("Missing the required parameter 'listingId' when calling uploadListingVideo(Async)");
        }
        return this.uploadListingVideoCall(shopId, listingId, videoId, video, name, _callback);
    }

    public ListingVideo uploadListingVideo(Long shopId, Long listingId, Long videoId, File video, String name) throws ApiException {
        ApiResponse<ListingVideo> localVarResp = this.uploadListingVideoWithHttpInfo(shopId, listingId, videoId, video, name);
        return localVarResp.getData();
    }

    public ApiResponse<ListingVideo> uploadListingVideoWithHttpInfo(Long shopId, Long listingId, Long videoId, File video, String name) throws ApiException {
        Call localVarCall = this.uploadListingVideoValidateBeforeCall(shopId, listingId, videoId, video, name, null);
        Type localVarReturnType = new TypeToken<ListingVideo>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call uploadListingVideoAsync(Long shopId, Long listingId, Long videoId, File video, String name, ApiCallback<ListingVideo> _callback) throws ApiException {
        Call localVarCall = this.uploadListingVideoValidateBeforeCall(shopId, listingId, videoId, video, name, _callback);
        Type localVarReturnType = new TypeToken<ListingVideo>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

