/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.ListingTranslation;

public class ShopListingTranslationApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ShopListingTranslationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ShopListingTranslationApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createListingTranslationCall(Long shopId, Long listingId, String language, String title, String description, List<String> tags, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/listings/{listing_id}/translations/{language}".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString())).replace("{listing_id}", this.localVarApiClient.escapeString(listingId.toString())).replace("{language}", this.localVarApiClient.escapeString(language.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (title != null) {
            localVarFormParams.put("title", title);
        }
        if (description != null) {
            localVarFormParams.put("description", description);
        }
        if (tags != null) {
            localVarFormParams.put("tags", tags);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/x-www-form-urlencoded"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createListingTranslationValidateBeforeCall(Long shopId, Long listingId, String language, String title, String description, List<String> tags, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling createListingTranslation(Async)");
        }
        if (listingId == null) {
            throw new ApiException("Missing the required parameter 'listingId' when calling createListingTranslation(Async)");
        }
        if (language == null) {
            throw new ApiException("Missing the required parameter 'language' when calling createListingTranslation(Async)");
        }
        if (title == null) {
            throw new ApiException("Missing the required parameter 'title' when calling createListingTranslation(Async)");
        }
        if (description == null) {
            throw new ApiException("Missing the required parameter 'description' when calling createListingTranslation(Async)");
        }
        return this.createListingTranslationCall(shopId, listingId, language, title, description, tags, _callback);
    }

    public ListingTranslation createListingTranslation(Long shopId, Long listingId, String language, String title, String description, List<String> tags) throws ApiException {
        ApiResponse<ListingTranslation> localVarResp = this.createListingTranslationWithHttpInfo(shopId, listingId, language, title, description, tags);
        return localVarResp.getData();
    }

    public ApiResponse<ListingTranslation> createListingTranslationWithHttpInfo(Long shopId, Long listingId, String language, String title, String description, List<String> tags) throws ApiException {
        Call localVarCall = this.createListingTranslationValidateBeforeCall(shopId, listingId, language, title, description, tags, null);
        Type localVarReturnType = new TypeToken<ListingTranslation>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createListingTranslationAsync(Long shopId, Long listingId, String language, String title, String description, List<String> tags, ApiCallback<ListingTranslation> _callback) throws ApiException {
        Call localVarCall = this.createListingTranslationValidateBeforeCall(shopId, listingId, language, title, description, tags, _callback);
        Type localVarReturnType = new TypeToken<ListingTranslation>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getListingTranslationCall(Long shopId, Long listingId, String language, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/listings/{listing_id}/translations/{language}".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString())).replace("{listing_id}", this.localVarApiClient.escapeString(listingId.toString())).replace("{language}", this.localVarApiClient.escapeString(language.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getListingTranslationValidateBeforeCall(Long shopId, Long listingId, String language, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling getListingTranslation(Async)");
        }
        if (listingId == null) {
            throw new ApiException("Missing the required parameter 'listingId' when calling getListingTranslation(Async)");
        }
        if (language == null) {
            throw new ApiException("Missing the required parameter 'language' when calling getListingTranslation(Async)");
        }
        return this.getListingTranslationCall(shopId, listingId, language, _callback);
    }

    public ListingTranslation getListingTranslation(Long shopId, Long listingId, String language) throws ApiException {
        ApiResponse<ListingTranslation> localVarResp = this.getListingTranslationWithHttpInfo(shopId, listingId, language);
        return localVarResp.getData();
    }

    public ApiResponse<ListingTranslation> getListingTranslationWithHttpInfo(Long shopId, Long listingId, String language) throws ApiException {
        Call localVarCall = this.getListingTranslationValidateBeforeCall(shopId, listingId, language, null);
        Type localVarReturnType = new TypeToken<ListingTranslation>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getListingTranslationAsync(Long shopId, Long listingId, String language, ApiCallback<ListingTranslation> _callback) throws ApiException {
        Call localVarCall = this.getListingTranslationValidateBeforeCall(shopId, listingId, language, _callback);
        Type localVarReturnType = new TypeToken<ListingTranslation>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateListingTranslationCall(Long shopId, Long listingId, String language, String title, String description, List<String> tags, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/listings/{listing_id}/translations/{language}".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString())).replace("{listing_id}", this.localVarApiClient.escapeString(listingId.toString())).replace("{language}", this.localVarApiClient.escapeString(language.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (title != null) {
            localVarFormParams.put("title", title);
        }
        if (description != null) {
            localVarFormParams.put("description", description);
        }
        if (tags != null) {
            localVarFormParams.put("tags", tags);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/x-www-form-urlencoded"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateListingTranslationValidateBeforeCall(Long shopId, Long listingId, String language, String title, String description, List<String> tags, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling updateListingTranslation(Async)");
        }
        if (listingId == null) {
            throw new ApiException("Missing the required parameter 'listingId' when calling updateListingTranslation(Async)");
        }
        if (language == null) {
            throw new ApiException("Missing the required parameter 'language' when calling updateListingTranslation(Async)");
        }
        if (title == null) {
            throw new ApiException("Missing the required parameter 'title' when calling updateListingTranslation(Async)");
        }
        if (description == null) {
            throw new ApiException("Missing the required parameter 'description' when calling updateListingTranslation(Async)");
        }
        return this.updateListingTranslationCall(shopId, listingId, language, title, description, tags, _callback);
    }

    public ListingTranslation updateListingTranslation(Long shopId, Long listingId, String language, String title, String description, List<String> tags) throws ApiException {
        ApiResponse<ListingTranslation> localVarResp = this.updateListingTranslationWithHttpInfo(shopId, listingId, language, title, description, tags);
        return localVarResp.getData();
    }

    public ApiResponse<ListingTranslation> updateListingTranslationWithHttpInfo(Long shopId, Long listingId, String language, String title, String description, List<String> tags) throws ApiException {
        Call localVarCall = this.updateListingTranslationValidateBeforeCall(shopId, listingId, language, title, description, tags, null);
        Type localVarReturnType = new TypeToken<ListingTranslation>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateListingTranslationAsync(Long shopId, Long listingId, String language, String title, String description, List<String> tags, ApiCallback<ListingTranslation> _callback) throws ApiException {
        Call localVarCall = this.updateListingTranslationValidateBeforeCall(shopId, listingId, language, title, description, tags, _callback);
        Type localVarReturnType = new TypeToken<ListingTranslation>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

