/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.ListingInventoryProduct;

public class ShopListingProductApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ShopListingProductApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ShopListingProductApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call getListingProductCall(Long listingId, Long productId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/listings/{listing_id}/inventory/products/{product_id}".replace("{listing_id}", this.localVarApiClient.escapeString(listingId.toString())).replace("{product_id}", this.localVarApiClient.escapeString(productId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getListingProductValidateBeforeCall(Long listingId, Long productId, ApiCallback _callback) throws ApiException {
        if (listingId == null) {
            throw new ApiException("Missing the required parameter 'listingId' when calling getListingProduct(Async)");
        }
        if (productId == null) {
            throw new ApiException("Missing the required parameter 'productId' when calling getListingProduct(Async)");
        }
        return this.getListingProductCall(listingId, productId, _callback);
    }

    public ListingInventoryProduct getListingProduct(Long listingId, Long productId) throws ApiException {
        ApiResponse<ListingInventoryProduct> localVarResp = this.getListingProductWithHttpInfo(listingId, productId);
        return localVarResp.getData();
    }

    public ApiResponse<ListingInventoryProduct> getListingProductWithHttpInfo(Long listingId, Long productId) throws ApiException {
        Call localVarCall = this.getListingProductValidateBeforeCall(listingId, productId, null);
        Type localVarReturnType = new TypeToken<ListingInventoryProduct>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getListingProductAsync(Long listingId, Long productId, ApiCallback<ListingInventoryProduct> _callback) throws ApiException {
        Call localVarCall = this.getListingProductValidateBeforeCall(listingId, productId, _callback);
        Type localVarReturnType = new TypeToken<ListingInventoryProduct>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

