/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.ListingInventoryProductOffering;

public class ShopListingOfferingApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ShopListingOfferingApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ShopListingOfferingApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call getListingOfferingCall(Long listingId, Long productId, Long productOfferingId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/listings/{listing_id}/products/{product_id}/offerings/{product_offering_id}".replace("{listing_id}", this.localVarApiClient.escapeString(listingId.toString())).replace("{product_id}", this.localVarApiClient.escapeString(productId.toString())).replace("{product_offering_id}", this.localVarApiClient.escapeString(productOfferingId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getListingOfferingValidateBeforeCall(Long listingId, Long productId, Long productOfferingId, ApiCallback _callback) throws ApiException {
        if (listingId == null) {
            throw new ApiException("Missing the required parameter 'listingId' when calling getListingOffering(Async)");
        }
        if (productId == null) {
            throw new ApiException("Missing the required parameter 'productId' when calling getListingOffering(Async)");
        }
        if (productOfferingId == null) {
            throw new ApiException("Missing the required parameter 'productOfferingId' when calling getListingOffering(Async)");
        }
        return this.getListingOfferingCall(listingId, productId, productOfferingId, _callback);
    }

    public ListingInventoryProductOffering getListingOffering(Long listingId, Long productId, Long productOfferingId) throws ApiException {
        ApiResponse<ListingInventoryProductOffering> localVarResp = this.getListingOfferingWithHttpInfo(listingId, productId, productOfferingId);
        return localVarResp.getData();
    }

    public ApiResponse<ListingInventoryProductOffering> getListingOfferingWithHttpInfo(Long listingId, Long productId, Long productOfferingId) throws ApiException {
        Call localVarCall = this.getListingOfferingValidateBeforeCall(listingId, productId, productOfferingId, null);
        Type localVarReturnType = new TypeToken<ListingInventoryProductOffering>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getListingOfferingAsync(Long listingId, Long productId, Long productOfferingId, ApiCallback<ListingInventoryProductOffering> _callback) throws ApiException {
        Call localVarCall = this.getListingOfferingValidateBeforeCall(listingId, productId, productOfferingId, _callback);
        Type localVarReturnType = new TypeToken<ListingInventoryProductOffering>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

