/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.ListingInventory;
import org.openapitools.client.model.ListingInventoryWithAssociations;
import org.openapitools.client.model.UpdateListingInventoryRequest;

public class ShopListingInventoryApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ShopListingInventoryApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ShopListingInventoryApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call getListingInventoryCall(Long listingId, Boolean showDeleted, String includes, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/listings/{listing_id}/inventory".replace("{listing_id}", this.localVarApiClient.escapeString(listingId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (showDeleted != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("show_deleted", showDeleted));
        }
        if (includes != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("includes", includes));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getListingInventoryValidateBeforeCall(Long listingId, Boolean showDeleted, String includes, ApiCallback _callback) throws ApiException {
        if (listingId == null) {
            throw new ApiException("Missing the required parameter 'listingId' when calling getListingInventory(Async)");
        }
        return this.getListingInventoryCall(listingId, showDeleted, includes, _callback);
    }

    public ListingInventoryWithAssociations getListingInventory(Long listingId, Boolean showDeleted, String includes) throws ApiException {
        ApiResponse<ListingInventoryWithAssociations> localVarResp = this.getListingInventoryWithHttpInfo(listingId, showDeleted, includes);
        return localVarResp.getData();
    }

    public ApiResponse<ListingInventoryWithAssociations> getListingInventoryWithHttpInfo(Long listingId, Boolean showDeleted, String includes) throws ApiException {
        Call localVarCall = this.getListingInventoryValidateBeforeCall(listingId, showDeleted, includes, null);
        Type localVarReturnType = new TypeToken<ListingInventoryWithAssociations>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getListingInventoryAsync(Long listingId, Boolean showDeleted, String includes, ApiCallback<ListingInventoryWithAssociations> _callback) throws ApiException {
        Call localVarCall = this.getListingInventoryValidateBeforeCall(listingId, showDeleted, includes, _callback);
        Type localVarReturnType = new TypeToken<ListingInventoryWithAssociations>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateListingInventoryCall(Long listingId, UpdateListingInventoryRequest updateListingInventoryRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateListingInventoryRequest localVarPostBody = updateListingInventoryRequest;
        String localVarPath = "/v3/application/listings/{listing_id}/inventory".replace("{listing_id}", this.localVarApiClient.escapeString(listingId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateListingInventoryValidateBeforeCall(Long listingId, UpdateListingInventoryRequest updateListingInventoryRequest, ApiCallback _callback) throws ApiException {
        if (listingId == null) {
            throw new ApiException("Missing the required parameter 'listingId' when calling updateListingInventory(Async)");
        }
        return this.updateListingInventoryCall(listingId, updateListingInventoryRequest, _callback);
    }

    public ListingInventory updateListingInventory(Long listingId, UpdateListingInventoryRequest updateListingInventoryRequest) throws ApiException {
        ApiResponse<ListingInventory> localVarResp = this.updateListingInventoryWithHttpInfo(listingId, updateListingInventoryRequest);
        return localVarResp.getData();
    }

    public ApiResponse<ListingInventory> updateListingInventoryWithHttpInfo(Long listingId, UpdateListingInventoryRequest updateListingInventoryRequest) throws ApiException {
        Call localVarCall = this.updateListingInventoryValidateBeforeCall(listingId, updateListingInventoryRequest, null);
        Type localVarReturnType = new TypeToken<ListingInventory>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateListingInventoryAsync(Long listingId, UpdateListingInventoryRequest updateListingInventoryRequest, ApiCallback<ListingInventory> _callback) throws ApiException {
        Call localVarCall = this.updateListingInventoryValidateBeforeCall(listingId, updateListingInventoryRequest, _callback);
        Type localVarReturnType = new TypeToken<ListingInventory>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

