/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.ListingImage;
import org.openapitools.client.model.ListingImages;

public class ShopListingImageApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ShopListingImageApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ShopListingImageApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call deleteListingImageCall(Long shopId, Long listingId, Long listingImageId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/listings/{listing_id}/images/{listing_image_id}".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString())).replace("{listing_id}", this.localVarApiClient.escapeString(listingId.toString())).replace("{listing_image_id}", this.localVarApiClient.escapeString(listingImageId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteListingImageValidateBeforeCall(Long shopId, Long listingId, Long listingImageId, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling deleteListingImage(Async)");
        }
        if (listingId == null) {
            throw new ApiException("Missing the required parameter 'listingId' when calling deleteListingImage(Async)");
        }
        if (listingImageId == null) {
            throw new ApiException("Missing the required parameter 'listingImageId' when calling deleteListingImage(Async)");
        }
        return this.deleteListingImageCall(shopId, listingId, listingImageId, _callback);
    }

    public void deleteListingImage(Long shopId, Long listingId, Long listingImageId) throws ApiException {
        this.deleteListingImageWithHttpInfo(shopId, listingId, listingImageId);
    }

    public ApiResponse<Void> deleteListingImageWithHttpInfo(Long shopId, Long listingId, Long listingImageId) throws ApiException {
        Call localVarCall = this.deleteListingImageValidateBeforeCall(shopId, listingId, listingImageId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteListingImageAsync(Long shopId, Long listingId, Long listingImageId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteListingImageValidateBeforeCall(shopId, listingId, listingImageId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getListingImageCall(Long listingId, Long listingImageId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/listings/{listing_id}/images/{listing_image_id}".replace("{listing_id}", this.localVarApiClient.escapeString(listingId.toString())).replace("{listing_image_id}", this.localVarApiClient.escapeString(listingImageId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getListingImageValidateBeforeCall(Long listingId, Long listingImageId, ApiCallback _callback) throws ApiException {
        if (listingId == null) {
            throw new ApiException("Missing the required parameter 'listingId' when calling getListingImage(Async)");
        }
        if (listingImageId == null) {
            throw new ApiException("Missing the required parameter 'listingImageId' when calling getListingImage(Async)");
        }
        return this.getListingImageCall(listingId, listingImageId, _callback);
    }

    public ListingImage getListingImage(Long listingId, Long listingImageId) throws ApiException {
        ApiResponse<ListingImage> localVarResp = this.getListingImageWithHttpInfo(listingId, listingImageId);
        return localVarResp.getData();
    }

    public ApiResponse<ListingImage> getListingImageWithHttpInfo(Long listingId, Long listingImageId) throws ApiException {
        Call localVarCall = this.getListingImageValidateBeforeCall(listingId, listingImageId, null);
        Type localVarReturnType = new TypeToken<ListingImage>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getListingImageAsync(Long listingId, Long listingImageId, ApiCallback<ListingImage> _callback) throws ApiException {
        Call localVarCall = this.getListingImageValidateBeforeCall(listingId, listingImageId, _callback);
        Type localVarReturnType = new TypeToken<ListingImage>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getListingImageDeprecatedCall(Long shopId, Long listingId, Long listingImageId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/listings/{listing_id}/images/{listing_image_id}".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString())).replace("{listing_id}", this.localVarApiClient.escapeString(listingId.toString())).replace("{listing_image_id}", this.localVarApiClient.escapeString(listingImageId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getListingImageDeprecatedValidateBeforeCall(Long shopId, Long listingId, Long listingImageId, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling getListingImageDeprecated(Async)");
        }
        if (listingId == null) {
            throw new ApiException("Missing the required parameter 'listingId' when calling getListingImageDeprecated(Async)");
        }
        if (listingImageId == null) {
            throw new ApiException("Missing the required parameter 'listingImageId' when calling getListingImageDeprecated(Async)");
        }
        return this.getListingImageDeprecatedCall(shopId, listingId, listingImageId, _callback);
    }

    public ListingImage getListingImageDeprecated(Long shopId, Long listingId, Long listingImageId) throws ApiException {
        ApiResponse<ListingImage> localVarResp = this.getListingImageDeprecatedWithHttpInfo(shopId, listingId, listingImageId);
        return localVarResp.getData();
    }

    public ApiResponse<ListingImage> getListingImageDeprecatedWithHttpInfo(Long shopId, Long listingId, Long listingImageId) throws ApiException {
        Call localVarCall = this.getListingImageDeprecatedValidateBeforeCall(shopId, listingId, listingImageId, null);
        Type localVarReturnType = new TypeToken<ListingImage>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getListingImageDeprecatedAsync(Long shopId, Long listingId, Long listingImageId, ApiCallback<ListingImage> _callback) throws ApiException {
        Call localVarCall = this.getListingImageDeprecatedValidateBeforeCall(shopId, listingId, listingImageId, _callback);
        Type localVarReturnType = new TypeToken<ListingImage>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getListingImagesCall(Long listingId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/listings/{listing_id}/images".replace("{listing_id}", this.localVarApiClient.escapeString(listingId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getListingImagesValidateBeforeCall(Long listingId, ApiCallback _callback) throws ApiException {
        if (listingId == null) {
            throw new ApiException("Missing the required parameter 'listingId' when calling getListingImages(Async)");
        }
        return this.getListingImagesCall(listingId, _callback);
    }

    public ListingImages getListingImages(Long listingId) throws ApiException {
        ApiResponse<ListingImages> localVarResp = this.getListingImagesWithHttpInfo(listingId);
        return localVarResp.getData();
    }

    public ApiResponse<ListingImages> getListingImagesWithHttpInfo(Long listingId) throws ApiException {
        Call localVarCall = this.getListingImagesValidateBeforeCall(listingId, null);
        Type localVarReturnType = new TypeToken<ListingImages>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getListingImagesAsync(Long listingId, ApiCallback<ListingImages> _callback) throws ApiException {
        Call localVarCall = this.getListingImagesValidateBeforeCall(listingId, _callback);
        Type localVarReturnType = new TypeToken<ListingImages>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getListingImagesDeprecatedCall(Long shopId, Long listingId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/listings/{listing_id}/images".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString())).replace("{listing_id}", this.localVarApiClient.escapeString(listingId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getListingImagesDeprecatedValidateBeforeCall(Long shopId, Long listingId, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling getListingImagesDeprecated(Async)");
        }
        if (listingId == null) {
            throw new ApiException("Missing the required parameter 'listingId' when calling getListingImagesDeprecated(Async)");
        }
        return this.getListingImagesDeprecatedCall(shopId, listingId, _callback);
    }

    public ListingImages getListingImagesDeprecated(Long shopId, Long listingId) throws ApiException {
        ApiResponse<ListingImages> localVarResp = this.getListingImagesDeprecatedWithHttpInfo(shopId, listingId);
        return localVarResp.getData();
    }

    public ApiResponse<ListingImages> getListingImagesDeprecatedWithHttpInfo(Long shopId, Long listingId) throws ApiException {
        Call localVarCall = this.getListingImagesDeprecatedValidateBeforeCall(shopId, listingId, null);
        Type localVarReturnType = new TypeToken<ListingImages>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getListingImagesDeprecatedAsync(Long shopId, Long listingId, ApiCallback<ListingImages> _callback) throws ApiException {
        Call localVarCall = this.getListingImagesDeprecatedValidateBeforeCall(shopId, listingId, _callback);
        Type localVarReturnType = new TypeToken<ListingImages>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call uploadListingImageCall(Long shopId, Long listingId, File image, Long listingImageId, Long rank, Boolean overwrite, Boolean isWatermarked, String altText, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/listings/{listing_id}/images".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString())).replace("{listing_id}", this.localVarApiClient.escapeString(listingId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (image != null) {
            localVarFormParams.put("image", image);
        }
        if (listingImageId != null) {
            localVarFormParams.put("listing_image_id", listingImageId);
        }
        if (rank != null) {
            localVarFormParams.put("rank", rank);
        }
        if (overwrite != null) {
            localVarFormParams.put("overwrite", overwrite);
        }
        if (isWatermarked != null) {
            localVarFormParams.put("is_watermarked", isWatermarked);
        }
        if (altText != null) {
            localVarFormParams.put("alt_text", altText);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call uploadListingImageValidateBeforeCall(Long shopId, Long listingId, File image, Long listingImageId, Long rank, Boolean overwrite, Boolean isWatermarked, String altText, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling uploadListingImage(Async)");
        }
        if (listingId == null) {
            throw new ApiException("Missing the required parameter 'listingId' when calling uploadListingImage(Async)");
        }
        return this.uploadListingImageCall(shopId, listingId, image, listingImageId, rank, overwrite, isWatermarked, altText, _callback);
    }

    public ListingImage uploadListingImage(Long shopId, Long listingId, File image, Long listingImageId, Long rank, Boolean overwrite, Boolean isWatermarked, String altText) throws ApiException {
        ApiResponse<ListingImage> localVarResp = this.uploadListingImageWithHttpInfo(shopId, listingId, image, listingImageId, rank, overwrite, isWatermarked, altText);
        return localVarResp.getData();
    }

    public ApiResponse<ListingImage> uploadListingImageWithHttpInfo(Long shopId, Long listingId, File image, Long listingImageId, Long rank, Boolean overwrite, Boolean isWatermarked, String altText) throws ApiException {
        Call localVarCall = this.uploadListingImageValidateBeforeCall(shopId, listingId, image, listingImageId, rank, overwrite, isWatermarked, altText, null);
        Type localVarReturnType = new TypeToken<ListingImage>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call uploadListingImageAsync(Long shopId, Long listingId, File image, Long listingImageId, Long rank, Boolean overwrite, Boolean isWatermarked, String altText, ApiCallback<ListingImage> _callback) throws ApiException {
        Call localVarCall = this.uploadListingImageValidateBeforeCall(shopId, listingId, image, listingImageId, rank, overwrite, isWatermarked, altText, _callback);
        Type localVarReturnType = new TypeToken<ListingImage>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

