/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.ListingPropertyValue;
import org.openapitools.client.model.ListingPropertyValues;
import org.openapitools.client.model.ShopListing;
import org.openapitools.client.model.ShopListingWithAssociations;
import org.openapitools.client.model.ShopListings;
import org.openapitools.client.model.ShopListingsWithAssociations;

public class ShopListingApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ShopListingApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ShopListingApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createDraftListingCall(Long shopId, Long quantity, String title, String description, Float price, String whoMade, String whenMade, Long taxonomyId, Long shippingProfileId, Long returnPolicyId, List<String> materials, Long shopSectionId, Long processingMin, Long processingMax, List<String> tags, List<String> styles, Float itemWeight, Float itemLength, Float itemWidth, Float itemHeight, String itemWeightUnit, String itemDimensionsUnit, Boolean isPersonalizable, Boolean personalizationIsRequired, Long personalizationCharCountMax, String personalizationInstructions, List<Long> productionPartnerIds, List<Long> imageIds, Boolean isSupply, Boolean isCustomizable, Boolean shouldAutoRenew, Boolean isTaxable, String type, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/listings".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (quantity != null) {
            localVarFormParams.put("quantity", quantity);
        }
        if (title != null) {
            localVarFormParams.put("title", title);
        }
        if (description != null) {
            localVarFormParams.put("description", description);
        }
        if (price != null) {
            localVarFormParams.put("price", price);
        }
        if (whoMade != null) {
            localVarFormParams.put("who_made", whoMade);
        }
        if (whenMade != null) {
            localVarFormParams.put("when_made", whenMade);
        }
        if (taxonomyId != null) {
            localVarFormParams.put("taxonomy_id", taxonomyId);
        }
        if (shippingProfileId != null) {
            localVarFormParams.put("shipping_profile_id", shippingProfileId);
        }
        if (returnPolicyId != null) {
            localVarFormParams.put("return_policy_id", returnPolicyId);
        }
        if (materials != null) {
            localVarFormParams.put("materials", materials);
        }
        if (shopSectionId != null) {
            localVarFormParams.put("shop_section_id", shopSectionId);
        }
        if (processingMin != null) {
            localVarFormParams.put("processing_min", processingMin);
        }
        if (processingMax != null) {
            localVarFormParams.put("processing_max", processingMax);
        }
        if (tags != null) {
            localVarFormParams.put("tags", tags);
        }
        if (styles != null) {
            localVarFormParams.put("styles", styles);
        }
        if (itemWeight != null) {
            localVarFormParams.put("item_weight", itemWeight);
        }
        if (itemLength != null) {
            localVarFormParams.put("item_length", itemLength);
        }
        if (itemWidth != null) {
            localVarFormParams.put("item_width", itemWidth);
        }
        if (itemHeight != null) {
            localVarFormParams.put("item_height", itemHeight);
        }
        if (itemWeightUnit != null) {
            localVarFormParams.put("item_weight_unit", itemWeightUnit);
        }
        if (itemDimensionsUnit != null) {
            localVarFormParams.put("item_dimensions_unit", itemDimensionsUnit);
        }
        if (isPersonalizable != null) {
            localVarFormParams.put("is_personalizable", isPersonalizable);
        }
        if (personalizationIsRequired != null) {
            localVarFormParams.put("personalization_is_required", personalizationIsRequired);
        }
        if (personalizationCharCountMax != null) {
            localVarFormParams.put("personalization_char_count_max", personalizationCharCountMax);
        }
        if (personalizationInstructions != null) {
            localVarFormParams.put("personalization_instructions", personalizationInstructions);
        }
        if (productionPartnerIds != null) {
            localVarFormParams.put("production_partner_ids", productionPartnerIds);
        }
        if (imageIds != null) {
            localVarFormParams.put("image_ids", imageIds);
        }
        if (isSupply != null) {
            localVarFormParams.put("is_supply", isSupply);
        }
        if (isCustomizable != null) {
            localVarFormParams.put("is_customizable", isCustomizable);
        }
        if (shouldAutoRenew != null) {
            localVarFormParams.put("should_auto_renew", shouldAutoRenew);
        }
        if (isTaxable != null) {
            localVarFormParams.put("is_taxable", isTaxable);
        }
        if (type != null) {
            localVarFormParams.put("type", type);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/x-www-form-urlencoded"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createDraftListingValidateBeforeCall(Long shopId, Long quantity, String title, String description, Float price, String whoMade, String whenMade, Long taxonomyId, Long shippingProfileId, Long returnPolicyId, List<String> materials, Long shopSectionId, Long processingMin, Long processingMax, List<String> tags, List<String> styles, Float itemWeight, Float itemLength, Float itemWidth, Float itemHeight, String itemWeightUnit, String itemDimensionsUnit, Boolean isPersonalizable, Boolean personalizationIsRequired, Long personalizationCharCountMax, String personalizationInstructions, List<Long> productionPartnerIds, List<Long> imageIds, Boolean isSupply, Boolean isCustomizable, Boolean shouldAutoRenew, Boolean isTaxable, String type, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling createDraftListing(Async)");
        }
        if (quantity == null) {
            throw new ApiException("Missing the required parameter 'quantity' when calling createDraftListing(Async)");
        }
        if (title == null) {
            throw new ApiException("Missing the required parameter 'title' when calling createDraftListing(Async)");
        }
        if (description == null) {
            throw new ApiException("Missing the required parameter 'description' when calling createDraftListing(Async)");
        }
        if (price == null) {
            throw new ApiException("Missing the required parameter 'price' when calling createDraftListing(Async)");
        }
        if (whoMade == null) {
            throw new ApiException("Missing the required parameter 'whoMade' when calling createDraftListing(Async)");
        }
        if (whenMade == null) {
            throw new ApiException("Missing the required parameter 'whenMade' when calling createDraftListing(Async)");
        }
        if (taxonomyId == null) {
            throw new ApiException("Missing the required parameter 'taxonomyId' when calling createDraftListing(Async)");
        }
        return this.createDraftListingCall(shopId, quantity, title, description, price, whoMade, whenMade, taxonomyId, shippingProfileId, returnPolicyId, materials, shopSectionId, processingMin, processingMax, tags, styles, itemWeight, itemLength, itemWidth, itemHeight, itemWeightUnit, itemDimensionsUnit, isPersonalizable, personalizationIsRequired, personalizationCharCountMax, personalizationInstructions, productionPartnerIds, imageIds, isSupply, isCustomizable, shouldAutoRenew, isTaxable, type, _callback);
    }

    public ShopListing createDraftListing(Long shopId, Long quantity, String title, String description, Float price, String whoMade, String whenMade, Long taxonomyId, Long shippingProfileId, Long returnPolicyId, List<String> materials, Long shopSectionId, Long processingMin, Long processingMax, List<String> tags, List<String> styles, Float itemWeight, Float itemLength, Float itemWidth, Float itemHeight, String itemWeightUnit, String itemDimensionsUnit, Boolean isPersonalizable, Boolean personalizationIsRequired, Long personalizationCharCountMax, String personalizationInstructions, List<Long> productionPartnerIds, List<Long> imageIds, Boolean isSupply, Boolean isCustomizable, Boolean shouldAutoRenew, Boolean isTaxable, String type) throws ApiException {
        ApiResponse<ShopListing> localVarResp = this.createDraftListingWithHttpInfo(shopId, quantity, title, description, price, whoMade, whenMade, taxonomyId, shippingProfileId, returnPolicyId, materials, shopSectionId, processingMin, processingMax, tags, styles, itemWeight, itemLength, itemWidth, itemHeight, itemWeightUnit, itemDimensionsUnit, isPersonalizable, personalizationIsRequired, personalizationCharCountMax, personalizationInstructions, productionPartnerIds, imageIds, isSupply, isCustomizable, shouldAutoRenew, isTaxable, type);
        return localVarResp.getData();
    }

    public ApiResponse<ShopListing> createDraftListingWithHttpInfo(Long shopId, Long quantity, String title, String description, Float price, String whoMade, String whenMade, Long taxonomyId, Long shippingProfileId, Long returnPolicyId, List<String> materials, Long shopSectionId, Long processingMin, Long processingMax, List<String> tags, List<String> styles, Float itemWeight, Float itemLength, Float itemWidth, Float itemHeight, String itemWeightUnit, String itemDimensionsUnit, Boolean isPersonalizable, Boolean personalizationIsRequired, Long personalizationCharCountMax, String personalizationInstructions, List<Long> productionPartnerIds, List<Long> imageIds, Boolean isSupply, Boolean isCustomizable, Boolean shouldAutoRenew, Boolean isTaxable, String type) throws ApiException {
        Call localVarCall = this.createDraftListingValidateBeforeCall(shopId, quantity, title, description, price, whoMade, whenMade, taxonomyId, shippingProfileId, returnPolicyId, materials, shopSectionId, processingMin, processingMax, tags, styles, itemWeight, itemLength, itemWidth, itemHeight, itemWeightUnit, itemDimensionsUnit, isPersonalizable, personalizationIsRequired, personalizationCharCountMax, personalizationInstructions, productionPartnerIds, imageIds, isSupply, isCustomizable, shouldAutoRenew, isTaxable, type, null);
        Type localVarReturnType = new TypeToken<ShopListing>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createDraftListingAsync(Long shopId, Long quantity, String title, String description, Float price, String whoMade, String whenMade, Long taxonomyId, Long shippingProfileId, Long returnPolicyId, List<String> materials, Long shopSectionId, Long processingMin, Long processingMax, List<String> tags, List<String> styles, Float itemWeight, Float itemLength, Float itemWidth, Float itemHeight, String itemWeightUnit, String itemDimensionsUnit, Boolean isPersonalizable, Boolean personalizationIsRequired, Long personalizationCharCountMax, String personalizationInstructions, List<Long> productionPartnerIds, List<Long> imageIds, Boolean isSupply, Boolean isCustomizable, Boolean shouldAutoRenew, Boolean isTaxable, String type, ApiCallback<ShopListing> _callback) throws ApiException {
        Call localVarCall = this.createDraftListingValidateBeforeCall(shopId, quantity, title, description, price, whoMade, whenMade, taxonomyId, shippingProfileId, returnPolicyId, materials, shopSectionId, processingMin, processingMax, tags, styles, itemWeight, itemLength, itemWidth, itemHeight, itemWeightUnit, itemDimensionsUnit, isPersonalizable, personalizationIsRequired, personalizationCharCountMax, personalizationInstructions, productionPartnerIds, imageIds, isSupply, isCustomizable, shouldAutoRenew, isTaxable, type, _callback);
        Type localVarReturnType = new TypeToken<ShopListing>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteListingCall(Long listingId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/listings/{listing_id}".replace("{listing_id}", this.localVarApiClient.escapeString(listingId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteListingValidateBeforeCall(Long listingId, ApiCallback _callback) throws ApiException {
        if (listingId == null) {
            throw new ApiException("Missing the required parameter 'listingId' when calling deleteListing(Async)");
        }
        return this.deleteListingCall(listingId, _callback);
    }

    public void deleteListing(Long listingId) throws ApiException {
        this.deleteListingWithHttpInfo(listingId);
    }

    public ApiResponse<Void> deleteListingWithHttpInfo(Long listingId) throws ApiException {
        Call localVarCall = this.deleteListingValidateBeforeCall(listingId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteListingAsync(Long listingId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteListingValidateBeforeCall(listingId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteListingPropertyCall(Long shopId, Long listingId, Long propertyId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/listings/{listing_id}/properties/{property_id}".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString())).replace("{listing_id}", this.localVarApiClient.escapeString(listingId.toString())).replace("{property_id}", this.localVarApiClient.escapeString(propertyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteListingPropertyValidateBeforeCall(Long shopId, Long listingId, Long propertyId, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling deleteListingProperty(Async)");
        }
        if (listingId == null) {
            throw new ApiException("Missing the required parameter 'listingId' when calling deleteListingProperty(Async)");
        }
        if (propertyId == null) {
            throw new ApiException("Missing the required parameter 'propertyId' when calling deleteListingProperty(Async)");
        }
        return this.deleteListingPropertyCall(shopId, listingId, propertyId, _callback);
    }

    public void deleteListingProperty(Long shopId, Long listingId, Long propertyId) throws ApiException {
        this.deleteListingPropertyWithHttpInfo(shopId, listingId, propertyId);
    }

    public ApiResponse<Void> deleteListingPropertyWithHttpInfo(Long shopId, Long listingId, Long propertyId) throws ApiException {
        Call localVarCall = this.deleteListingPropertyValidateBeforeCall(shopId, listingId, propertyId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteListingPropertyAsync(Long shopId, Long listingId, Long propertyId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteListingPropertyValidateBeforeCall(shopId, listingId, propertyId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call findAllActiveListingsByShopCall(Long shopId, Long limit, String sortOn, String sortOrder, Long offset, String keywords, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/listings/active".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (sortOn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort_on", sortOn));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort_order", sortOrder));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (keywords != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("keywords", keywords));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call findAllActiveListingsByShopValidateBeforeCall(Long shopId, Long limit, String sortOn, String sortOrder, Long offset, String keywords, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling findAllActiveListingsByShop(Async)");
        }
        return this.findAllActiveListingsByShopCall(shopId, limit, sortOn, sortOrder, offset, keywords, _callback);
    }

    public ShopListings findAllActiveListingsByShop(Long shopId, Long limit, String sortOn, String sortOrder, Long offset, String keywords) throws ApiException {
        ApiResponse<ShopListings> localVarResp = this.findAllActiveListingsByShopWithHttpInfo(shopId, limit, sortOn, sortOrder, offset, keywords);
        return localVarResp.getData();
    }

    public ApiResponse<ShopListings> findAllActiveListingsByShopWithHttpInfo(Long shopId, Long limit, String sortOn, String sortOrder, Long offset, String keywords) throws ApiException {
        Call localVarCall = this.findAllActiveListingsByShopValidateBeforeCall(shopId, limit, sortOn, sortOrder, offset, keywords, null);
        Type localVarReturnType = new TypeToken<ShopListings>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call findAllActiveListingsByShopAsync(Long shopId, Long limit, String sortOn, String sortOrder, Long offset, String keywords, ApiCallback<ShopListings> _callback) throws ApiException {
        Call localVarCall = this.findAllActiveListingsByShopValidateBeforeCall(shopId, limit, sortOn, sortOrder, offset, keywords, _callback);
        Type localVarReturnType = new TypeToken<ShopListings>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call findAllListingsActiveCall(Long limit, Long offset, String keywords, String sortOn, String sortOrder, Float minPrice, Float maxPrice, Long taxonomyId, String shopLocation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/listings/active";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (keywords != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("keywords", keywords));
        }
        if (sortOn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort_on", sortOn));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort_order", sortOrder));
        }
        if (minPrice != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("min_price", minPrice));
        }
        if (maxPrice != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_price", maxPrice));
        }
        if (taxonomyId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("taxonomy_id", taxonomyId));
        }
        if (shopLocation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("shop_location", shopLocation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call findAllListingsActiveValidateBeforeCall(Long limit, Long offset, String keywords, String sortOn, String sortOrder, Float minPrice, Float maxPrice, Long taxonomyId, String shopLocation, ApiCallback _callback) throws ApiException {
        return this.findAllListingsActiveCall(limit, offset, keywords, sortOn, sortOrder, minPrice, maxPrice, taxonomyId, shopLocation, _callback);
    }

    public ShopListings findAllListingsActive(Long limit, Long offset, String keywords, String sortOn, String sortOrder, Float minPrice, Float maxPrice, Long taxonomyId, String shopLocation) throws ApiException {
        ApiResponse<ShopListings> localVarResp = this.findAllListingsActiveWithHttpInfo(limit, offset, keywords, sortOn, sortOrder, minPrice, maxPrice, taxonomyId, shopLocation);
        return localVarResp.getData();
    }

    public ApiResponse<ShopListings> findAllListingsActiveWithHttpInfo(Long limit, Long offset, String keywords, String sortOn, String sortOrder, Float minPrice, Float maxPrice, Long taxonomyId, String shopLocation) throws ApiException {
        Call localVarCall = this.findAllListingsActiveValidateBeforeCall(limit, offset, keywords, sortOn, sortOrder, minPrice, maxPrice, taxonomyId, shopLocation, null);
        Type localVarReturnType = new TypeToken<ShopListings>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call findAllListingsActiveAsync(Long limit, Long offset, String keywords, String sortOn, String sortOrder, Float minPrice, Float maxPrice, Long taxonomyId, String shopLocation, ApiCallback<ShopListings> _callback) throws ApiException {
        Call localVarCall = this.findAllListingsActiveValidateBeforeCall(limit, offset, keywords, sortOn, sortOrder, minPrice, maxPrice, taxonomyId, shopLocation, _callback);
        Type localVarReturnType = new TypeToken<ShopListings>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getFeaturedListingsByShopCall(Long shopId, Long limit, Long offset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/listings/featured".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getFeaturedListingsByShopValidateBeforeCall(Long shopId, Long limit, Long offset, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling getFeaturedListingsByShop(Async)");
        }
        return this.getFeaturedListingsByShopCall(shopId, limit, offset, _callback);
    }

    public ShopListings getFeaturedListingsByShop(Long shopId, Long limit, Long offset) throws ApiException {
        ApiResponse<ShopListings> localVarResp = this.getFeaturedListingsByShopWithHttpInfo(shopId, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<ShopListings> getFeaturedListingsByShopWithHttpInfo(Long shopId, Long limit, Long offset) throws ApiException {
        Call localVarCall = this.getFeaturedListingsByShopValidateBeforeCall(shopId, limit, offset, null);
        Type localVarReturnType = new TypeToken<ShopListings>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getFeaturedListingsByShopAsync(Long shopId, Long limit, Long offset, ApiCallback<ShopListings> _callback) throws ApiException {
        Call localVarCall = this.getFeaturedListingsByShopValidateBeforeCall(shopId, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<ShopListings>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getListingCall(Long listingId, List<String> includes, String language, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/listings/{listing_id}".replace("{listing_id}", this.localVarApiClient.escapeString(listingId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (includes != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "includes", includes));
        }
        if (language != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("language", language));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getListingValidateBeforeCall(Long listingId, List<String> includes, String language, ApiCallback _callback) throws ApiException {
        if (listingId == null) {
            throw new ApiException("Missing the required parameter 'listingId' when calling getListing(Async)");
        }
        return this.getListingCall(listingId, includes, language, _callback);
    }

    public ShopListingWithAssociations getListing(Long listingId, List<String> includes, String language) throws ApiException {
        ApiResponse<ShopListingWithAssociations> localVarResp = this.getListingWithHttpInfo(listingId, includes, language);
        return localVarResp.getData();
    }

    public ApiResponse<ShopListingWithAssociations> getListingWithHttpInfo(Long listingId, List<String> includes, String language) throws ApiException {
        Call localVarCall = this.getListingValidateBeforeCall(listingId, includes, language, null);
        Type localVarReturnType = new TypeToken<ShopListingWithAssociations>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getListingAsync(Long listingId, List<String> includes, String language, ApiCallback<ShopListingWithAssociations> _callback) throws ApiException {
        Call localVarCall = this.getListingValidateBeforeCall(listingId, includes, language, _callback);
        Type localVarReturnType = new TypeToken<ShopListingWithAssociations>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getListingPropertiesCall(Long shopId, Long listingId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/listings/{listing_id}/properties".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString())).replace("{listing_id}", this.localVarApiClient.escapeString(listingId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getListingPropertiesValidateBeforeCall(Long shopId, Long listingId, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling getListingProperties(Async)");
        }
        if (listingId == null) {
            throw new ApiException("Missing the required parameter 'listingId' when calling getListingProperties(Async)");
        }
        return this.getListingPropertiesCall(shopId, listingId, _callback);
    }

    public ListingPropertyValues getListingProperties(Long shopId, Long listingId) throws ApiException {
        ApiResponse<ListingPropertyValues> localVarResp = this.getListingPropertiesWithHttpInfo(shopId, listingId);
        return localVarResp.getData();
    }

    public ApiResponse<ListingPropertyValues> getListingPropertiesWithHttpInfo(Long shopId, Long listingId) throws ApiException {
        Call localVarCall = this.getListingPropertiesValidateBeforeCall(shopId, listingId, null);
        Type localVarReturnType = new TypeToken<ListingPropertyValues>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getListingPropertiesAsync(Long shopId, Long listingId, ApiCallback<ListingPropertyValues> _callback) throws ApiException {
        Call localVarCall = this.getListingPropertiesValidateBeforeCall(shopId, listingId, _callback);
        Type localVarReturnType = new TypeToken<ListingPropertyValues>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getListingPropertyCall(Long listingId, Long propertyId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/listings/{listing_id}/properties/{property_id}".replace("{listing_id}", this.localVarApiClient.escapeString(listingId.toString())).replace("{property_id}", this.localVarApiClient.escapeString(propertyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getListingPropertyValidateBeforeCall(Long listingId, Long propertyId, ApiCallback _callback) throws ApiException {
        if (listingId == null) {
            throw new ApiException("Missing the required parameter 'listingId' when calling getListingProperty(Async)");
        }
        if (propertyId == null) {
            throw new ApiException("Missing the required parameter 'propertyId' when calling getListingProperty(Async)");
        }
        return this.getListingPropertyCall(listingId, propertyId, _callback);
    }

    public ListingPropertyValue getListingProperty(Long listingId, Long propertyId) throws ApiException {
        ApiResponse<ListingPropertyValue> localVarResp = this.getListingPropertyWithHttpInfo(listingId, propertyId);
        return localVarResp.getData();
    }

    public ApiResponse<ListingPropertyValue> getListingPropertyWithHttpInfo(Long listingId, Long propertyId) throws ApiException {
        Call localVarCall = this.getListingPropertyValidateBeforeCall(listingId, propertyId, null);
        Type localVarReturnType = new TypeToken<ListingPropertyValue>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getListingPropertyAsync(Long listingId, Long propertyId, ApiCallback<ListingPropertyValue> _callback) throws ApiException {
        Call localVarCall = this.getListingPropertyValidateBeforeCall(listingId, propertyId, _callback);
        Type localVarReturnType = new TypeToken<ListingPropertyValue>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getListingsByListingIdsCall(List<Long> listingIds, List<String> includes, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/listings/batch";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (listingIds != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "listing_ids", listingIds));
        }
        if (includes != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "includes", includes));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getListingsByListingIdsValidateBeforeCall(List<Long> listingIds, List<String> includes, ApiCallback _callback) throws ApiException {
        if (listingIds == null) {
            throw new ApiException("Missing the required parameter 'listingIds' when calling getListingsByListingIds(Async)");
        }
        return this.getListingsByListingIdsCall(listingIds, includes, _callback);
    }

    public ShopListingsWithAssociations getListingsByListingIds(List<Long> listingIds, List<String> includes) throws ApiException {
        ApiResponse<ShopListingsWithAssociations> localVarResp = this.getListingsByListingIdsWithHttpInfo(listingIds, includes);
        return localVarResp.getData();
    }

    public ApiResponse<ShopListingsWithAssociations> getListingsByListingIdsWithHttpInfo(List<Long> listingIds, List<String> includes) throws ApiException {
        Call localVarCall = this.getListingsByListingIdsValidateBeforeCall(listingIds, includes, null);
        Type localVarReturnType = new TypeToken<ShopListingsWithAssociations>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getListingsByListingIdsAsync(List<Long> listingIds, List<String> includes, ApiCallback<ShopListingsWithAssociations> _callback) throws ApiException {
        Call localVarCall = this.getListingsByListingIdsValidateBeforeCall(listingIds, includes, _callback);
        Type localVarReturnType = new TypeToken<ShopListingsWithAssociations>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getListingsByShopCall(Long shopId, String state, Long limit, Long offset, String sortOn, String sortOrder, List<String> includes, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/listings".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (state != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("state", state));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (sortOn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort_on", sortOn));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort_order", sortOrder));
        }
        if (includes != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "includes", includes));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getListingsByShopValidateBeforeCall(Long shopId, String state, Long limit, Long offset, String sortOn, String sortOrder, List<String> includes, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling getListingsByShop(Async)");
        }
        return this.getListingsByShopCall(shopId, state, limit, offset, sortOn, sortOrder, includes, _callback);
    }

    public ShopListingsWithAssociations getListingsByShop(Long shopId, String state, Long limit, Long offset, String sortOn, String sortOrder, List<String> includes) throws ApiException {
        ApiResponse<ShopListingsWithAssociations> localVarResp = this.getListingsByShopWithHttpInfo(shopId, state, limit, offset, sortOn, sortOrder, includes);
        return localVarResp.getData();
    }

    public ApiResponse<ShopListingsWithAssociations> getListingsByShopWithHttpInfo(Long shopId, String state, Long limit, Long offset, String sortOn, String sortOrder, List<String> includes) throws ApiException {
        Call localVarCall = this.getListingsByShopValidateBeforeCall(shopId, state, limit, offset, sortOn, sortOrder, includes, null);
        Type localVarReturnType = new TypeToken<ShopListingsWithAssociations>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getListingsByShopAsync(Long shopId, String state, Long limit, Long offset, String sortOn, String sortOrder, List<String> includes, ApiCallback<ShopListingsWithAssociations> _callback) throws ApiException {
        Call localVarCall = this.getListingsByShopValidateBeforeCall(shopId, state, limit, offset, sortOn, sortOrder, includes, _callback);
        Type localVarReturnType = new TypeToken<ShopListingsWithAssociations>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getListingsByShopReceiptCall(Long receiptId, Long shopId, Long limit, Long offset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/receipts/{receipt_id}/listings".replace("{receipt_id}", this.localVarApiClient.escapeString(receiptId.toString())).replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getListingsByShopReceiptValidateBeforeCall(Long receiptId, Long shopId, Long limit, Long offset, ApiCallback _callback) throws ApiException {
        if (receiptId == null) {
            throw new ApiException("Missing the required parameter 'receiptId' when calling getListingsByShopReceipt(Async)");
        }
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling getListingsByShopReceipt(Async)");
        }
        return this.getListingsByShopReceiptCall(receiptId, shopId, limit, offset, _callback);
    }

    public ShopListings getListingsByShopReceipt(Long receiptId, Long shopId, Long limit, Long offset) throws ApiException {
        ApiResponse<ShopListings> localVarResp = this.getListingsByShopReceiptWithHttpInfo(receiptId, shopId, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<ShopListings> getListingsByShopReceiptWithHttpInfo(Long receiptId, Long shopId, Long limit, Long offset) throws ApiException {
        Call localVarCall = this.getListingsByShopReceiptValidateBeforeCall(receiptId, shopId, limit, offset, null);
        Type localVarReturnType = new TypeToken<ShopListings>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getListingsByShopReceiptAsync(Long receiptId, Long shopId, Long limit, Long offset, ApiCallback<ShopListings> _callback) throws ApiException {
        Call localVarCall = this.getListingsByShopReceiptValidateBeforeCall(receiptId, shopId, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<ShopListings>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getListingsByShopReturnPolicyCall(Long returnPolicyId, Long shopId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/policies/return/{return_policy_id}/listings".replace("{return_policy_id}", this.localVarApiClient.escapeString(returnPolicyId.toString())).replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getListingsByShopReturnPolicyValidateBeforeCall(Long returnPolicyId, Long shopId, ApiCallback _callback) throws ApiException {
        if (returnPolicyId == null) {
            throw new ApiException("Missing the required parameter 'returnPolicyId' when calling getListingsByShopReturnPolicy(Async)");
        }
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling getListingsByShopReturnPolicy(Async)");
        }
        return this.getListingsByShopReturnPolicyCall(returnPolicyId, shopId, _callback);
    }

    public ShopListings getListingsByShopReturnPolicy(Long returnPolicyId, Long shopId) throws ApiException {
        ApiResponse<ShopListings> localVarResp = this.getListingsByShopReturnPolicyWithHttpInfo(returnPolicyId, shopId);
        return localVarResp.getData();
    }

    public ApiResponse<ShopListings> getListingsByShopReturnPolicyWithHttpInfo(Long returnPolicyId, Long shopId) throws ApiException {
        Call localVarCall = this.getListingsByShopReturnPolicyValidateBeforeCall(returnPolicyId, shopId, null);
        Type localVarReturnType = new TypeToken<ShopListings>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getListingsByShopReturnPolicyAsync(Long returnPolicyId, Long shopId, ApiCallback<ShopListings> _callback) throws ApiException {
        Call localVarCall = this.getListingsByShopReturnPolicyValidateBeforeCall(returnPolicyId, shopId, _callback);
        Type localVarReturnType = new TypeToken<ShopListings>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getListingsByShopSectionIdCall(Long shopId, List<Long> shopSectionIds, Long limit, Long offset, String sortOn, String sortOrder, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/shop-sections/listings".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (shopSectionIds != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "shop_section_ids", shopSectionIds));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (sortOn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort_on", sortOn));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort_order", sortOrder));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getListingsByShopSectionIdValidateBeforeCall(Long shopId, List<Long> shopSectionIds, Long limit, Long offset, String sortOn, String sortOrder, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling getListingsByShopSectionId(Async)");
        }
        if (shopSectionIds == null) {
            throw new ApiException("Missing the required parameter 'shopSectionIds' when calling getListingsByShopSectionId(Async)");
        }
        return this.getListingsByShopSectionIdCall(shopId, shopSectionIds, limit, offset, sortOn, sortOrder, _callback);
    }

    public ShopListings getListingsByShopSectionId(Long shopId, List<Long> shopSectionIds, Long limit, Long offset, String sortOn, String sortOrder) throws ApiException {
        ApiResponse<ShopListings> localVarResp = this.getListingsByShopSectionIdWithHttpInfo(shopId, shopSectionIds, limit, offset, sortOn, sortOrder);
        return localVarResp.getData();
    }

    public ApiResponse<ShopListings> getListingsByShopSectionIdWithHttpInfo(Long shopId, List<Long> shopSectionIds, Long limit, Long offset, String sortOn, String sortOrder) throws ApiException {
        Call localVarCall = this.getListingsByShopSectionIdValidateBeforeCall(shopId, shopSectionIds, limit, offset, sortOn, sortOrder, null);
        Type localVarReturnType = new TypeToken<ShopListings>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getListingsByShopSectionIdAsync(Long shopId, List<Long> shopSectionIds, Long limit, Long offset, String sortOn, String sortOrder, ApiCallback<ShopListings> _callback) throws ApiException {
        Call localVarCall = this.getListingsByShopSectionIdValidateBeforeCall(shopId, shopSectionIds, limit, offset, sortOn, sortOrder, _callback);
        Type localVarReturnType = new TypeToken<ShopListings>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateListingCall(Long shopId, Long listingId, List<Long> imageIds, String title, String description, List<String> materials, Boolean shouldAutoRenew, Long shippingProfileId, Long returnPolicyId, Long shopSectionId, Float itemWeight, Float itemLength, Float itemWidth, Float itemHeight, String itemWeightUnit, String itemDimensionsUnit, Boolean isTaxable, Long taxonomyId, List<String> tags, String whoMade, String whenMade, Long featuredRank, Boolean isPersonalizable, Boolean personalizationIsRequired, Long personalizationCharCountMax, String personalizationInstructions, String state, Boolean isSupply, List<Long> productionPartnerIds, String type, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/listings/{listing_id}".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString())).replace("{listing_id}", this.localVarApiClient.escapeString(listingId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (imageIds != null) {
            localVarFormParams.put("image_ids", imageIds);
        }
        if (title != null) {
            localVarFormParams.put("title", title);
        }
        if (description != null) {
            localVarFormParams.put("description", description);
        }
        if (materials != null) {
            localVarFormParams.put("materials", materials);
        }
        if (shouldAutoRenew != null) {
            localVarFormParams.put("should_auto_renew", shouldAutoRenew);
        }
        if (shippingProfileId != null) {
            localVarFormParams.put("shipping_profile_id", shippingProfileId);
        }
        if (returnPolicyId != null) {
            localVarFormParams.put("return_policy_id", returnPolicyId);
        }
        if (shopSectionId != null) {
            localVarFormParams.put("shop_section_id", shopSectionId);
        }
        if (itemWeight != null) {
            localVarFormParams.put("item_weight", itemWeight);
        }
        if (itemLength != null) {
            localVarFormParams.put("item_length", itemLength);
        }
        if (itemWidth != null) {
            localVarFormParams.put("item_width", itemWidth);
        }
        if (itemHeight != null) {
            localVarFormParams.put("item_height", itemHeight);
        }
        if (itemWeightUnit != null) {
            localVarFormParams.put("item_weight_unit", itemWeightUnit);
        }
        if (itemDimensionsUnit != null) {
            localVarFormParams.put("item_dimensions_unit", itemDimensionsUnit);
        }
        if (isTaxable != null) {
            localVarFormParams.put("is_taxable", isTaxable);
        }
        if (taxonomyId != null) {
            localVarFormParams.put("taxonomy_id", taxonomyId);
        }
        if (tags != null) {
            localVarFormParams.put("tags", tags);
        }
        if (whoMade != null) {
            localVarFormParams.put("who_made", whoMade);
        }
        if (whenMade != null) {
            localVarFormParams.put("when_made", whenMade);
        }
        if (featuredRank != null) {
            localVarFormParams.put("featured_rank", featuredRank);
        }
        if (isPersonalizable != null) {
            localVarFormParams.put("is_personalizable", isPersonalizable);
        }
        if (personalizationIsRequired != null) {
            localVarFormParams.put("personalization_is_required", personalizationIsRequired);
        }
        if (personalizationCharCountMax != null) {
            localVarFormParams.put("personalization_char_count_max", personalizationCharCountMax);
        }
        if (personalizationInstructions != null) {
            localVarFormParams.put("personalization_instructions", personalizationInstructions);
        }
        if (state != null) {
            localVarFormParams.put("state", state);
        }
        if (isSupply != null) {
            localVarFormParams.put("is_supply", isSupply);
        }
        if (productionPartnerIds != null) {
            localVarFormParams.put("production_partner_ids", productionPartnerIds);
        }
        if (type != null) {
            localVarFormParams.put("type", type);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/x-www-form-urlencoded"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateListingValidateBeforeCall(Long shopId, Long listingId, List<Long> imageIds, String title, String description, List<String> materials, Boolean shouldAutoRenew, Long shippingProfileId, Long returnPolicyId, Long shopSectionId, Float itemWeight, Float itemLength, Float itemWidth, Float itemHeight, String itemWeightUnit, String itemDimensionsUnit, Boolean isTaxable, Long taxonomyId, List<String> tags, String whoMade, String whenMade, Long featuredRank, Boolean isPersonalizable, Boolean personalizationIsRequired, Long personalizationCharCountMax, String personalizationInstructions, String state, Boolean isSupply, List<Long> productionPartnerIds, String type, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling updateListing(Async)");
        }
        if (listingId == null) {
            throw new ApiException("Missing the required parameter 'listingId' when calling updateListing(Async)");
        }
        return this.updateListingCall(shopId, listingId, imageIds, title, description, materials, shouldAutoRenew, shippingProfileId, returnPolicyId, shopSectionId, itemWeight, itemLength, itemWidth, itemHeight, itemWeightUnit, itemDimensionsUnit, isTaxable, taxonomyId, tags, whoMade, whenMade, featuredRank, isPersonalizable, personalizationIsRequired, personalizationCharCountMax, personalizationInstructions, state, isSupply, productionPartnerIds, type, _callback);
    }

    public ShopListing updateListing(Long shopId, Long listingId, List<Long> imageIds, String title, String description, List<String> materials, Boolean shouldAutoRenew, Long shippingProfileId, Long returnPolicyId, Long shopSectionId, Float itemWeight, Float itemLength, Float itemWidth, Float itemHeight, String itemWeightUnit, String itemDimensionsUnit, Boolean isTaxable, Long taxonomyId, List<String> tags, String whoMade, String whenMade, Long featuredRank, Boolean isPersonalizable, Boolean personalizationIsRequired, Long personalizationCharCountMax, String personalizationInstructions, String state, Boolean isSupply, List<Long> productionPartnerIds, String type) throws ApiException {
        ApiResponse<ShopListing> localVarResp = this.updateListingWithHttpInfo(shopId, listingId, imageIds, title, description, materials, shouldAutoRenew, shippingProfileId, returnPolicyId, shopSectionId, itemWeight, itemLength, itemWidth, itemHeight, itemWeightUnit, itemDimensionsUnit, isTaxable, taxonomyId, tags, whoMade, whenMade, featuredRank, isPersonalizable, personalizationIsRequired, personalizationCharCountMax, personalizationInstructions, state, isSupply, productionPartnerIds, type);
        return localVarResp.getData();
    }

    public ApiResponse<ShopListing> updateListingWithHttpInfo(Long shopId, Long listingId, List<Long> imageIds, String title, String description, List<String> materials, Boolean shouldAutoRenew, Long shippingProfileId, Long returnPolicyId, Long shopSectionId, Float itemWeight, Float itemLength, Float itemWidth, Float itemHeight, String itemWeightUnit, String itemDimensionsUnit, Boolean isTaxable, Long taxonomyId, List<String> tags, String whoMade, String whenMade, Long featuredRank, Boolean isPersonalizable, Boolean personalizationIsRequired, Long personalizationCharCountMax, String personalizationInstructions, String state, Boolean isSupply, List<Long> productionPartnerIds, String type) throws ApiException {
        Call localVarCall = this.updateListingValidateBeforeCall(shopId, listingId, imageIds, title, description, materials, shouldAutoRenew, shippingProfileId, returnPolicyId, shopSectionId, itemWeight, itemLength, itemWidth, itemHeight, itemWeightUnit, itemDimensionsUnit, isTaxable, taxonomyId, tags, whoMade, whenMade, featuredRank, isPersonalizable, personalizationIsRequired, personalizationCharCountMax, personalizationInstructions, state, isSupply, productionPartnerIds, type, null);
        Type localVarReturnType = new TypeToken<ShopListing>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateListingAsync(Long shopId, Long listingId, List<Long> imageIds, String title, String description, List<String> materials, Boolean shouldAutoRenew, Long shippingProfileId, Long returnPolicyId, Long shopSectionId, Float itemWeight, Float itemLength, Float itemWidth, Float itemHeight, String itemWeightUnit, String itemDimensionsUnit, Boolean isTaxable, Long taxonomyId, List<String> tags, String whoMade, String whenMade, Long featuredRank, Boolean isPersonalizable, Boolean personalizationIsRequired, Long personalizationCharCountMax, String personalizationInstructions, String state, Boolean isSupply, List<Long> productionPartnerIds, String type, ApiCallback<ShopListing> _callback) throws ApiException {
        Call localVarCall = this.updateListingValidateBeforeCall(shopId, listingId, imageIds, title, description, materials, shouldAutoRenew, shippingProfileId, returnPolicyId, shopSectionId, itemWeight, itemLength, itemWidth, itemHeight, itemWeightUnit, itemDimensionsUnit, isTaxable, taxonomyId, tags, whoMade, whenMade, featuredRank, isPersonalizable, personalizationIsRequired, personalizationCharCountMax, personalizationInstructions, state, isSupply, productionPartnerIds, type, _callback);
        Type localVarReturnType = new TypeToken<ShopListing>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateListingDeprecatedCall(Long shopId, Long listingId, List<Long> imageIds, String title, String description, List<String> materials, Boolean shouldAutoRenew, Long shippingProfileId, Long shopSectionId, Float itemWeight, Float itemLength, Float itemWidth, Float itemHeight, String itemWeightUnit, String itemDimensionsUnit, Boolean isTaxable, Long taxonomyId, List<String> tags, String whoMade, String whenMade, Long featuredRank, Boolean isPersonalizable, Boolean personalizationIsRequired, Long personalizationCharCountMax, String personalizationInstructions, String state, Boolean isSupply, List<Long> productionPartnerIds, String type, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/listings/{listing_id}".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString())).replace("{listing_id}", this.localVarApiClient.escapeString(listingId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (imageIds != null) {
            localVarFormParams.put("image_ids", imageIds);
        }
        if (title != null) {
            localVarFormParams.put("title", title);
        }
        if (description != null) {
            localVarFormParams.put("description", description);
        }
        if (materials != null) {
            localVarFormParams.put("materials", materials);
        }
        if (shouldAutoRenew != null) {
            localVarFormParams.put("should_auto_renew", shouldAutoRenew);
        }
        if (shippingProfileId != null) {
            localVarFormParams.put("shipping_profile_id", shippingProfileId);
        }
        if (shopSectionId != null) {
            localVarFormParams.put("shop_section_id", shopSectionId);
        }
        if (itemWeight != null) {
            localVarFormParams.put("item_weight", itemWeight);
        }
        if (itemLength != null) {
            localVarFormParams.put("item_length", itemLength);
        }
        if (itemWidth != null) {
            localVarFormParams.put("item_width", itemWidth);
        }
        if (itemHeight != null) {
            localVarFormParams.put("item_height", itemHeight);
        }
        if (itemWeightUnit != null) {
            localVarFormParams.put("item_weight_unit", itemWeightUnit);
        }
        if (itemDimensionsUnit != null) {
            localVarFormParams.put("item_dimensions_unit", itemDimensionsUnit);
        }
        if (isTaxable != null) {
            localVarFormParams.put("is_taxable", isTaxable);
        }
        if (taxonomyId != null) {
            localVarFormParams.put("taxonomy_id", taxonomyId);
        }
        if (tags != null) {
            localVarFormParams.put("tags", tags);
        }
        if (whoMade != null) {
            localVarFormParams.put("who_made", whoMade);
        }
        if (whenMade != null) {
            localVarFormParams.put("when_made", whenMade);
        }
        if (featuredRank != null) {
            localVarFormParams.put("featured_rank", featuredRank);
        }
        if (isPersonalizable != null) {
            localVarFormParams.put("is_personalizable", isPersonalizable);
        }
        if (personalizationIsRequired != null) {
            localVarFormParams.put("personalization_is_required", personalizationIsRequired);
        }
        if (personalizationCharCountMax != null) {
            localVarFormParams.put("personalization_char_count_max", personalizationCharCountMax);
        }
        if (personalizationInstructions != null) {
            localVarFormParams.put("personalization_instructions", personalizationInstructions);
        }
        if (state != null) {
            localVarFormParams.put("state", state);
        }
        if (isSupply != null) {
            localVarFormParams.put("is_supply", isSupply);
        }
        if (productionPartnerIds != null) {
            localVarFormParams.put("production_partner_ids", productionPartnerIds);
        }
        if (type != null) {
            localVarFormParams.put("type", type);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/x-www-form-urlencoded"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateListingDeprecatedValidateBeforeCall(Long shopId, Long listingId, List<Long> imageIds, String title, String description, List<String> materials, Boolean shouldAutoRenew, Long shippingProfileId, Long shopSectionId, Float itemWeight, Float itemLength, Float itemWidth, Float itemHeight, String itemWeightUnit, String itemDimensionsUnit, Boolean isTaxable, Long taxonomyId, List<String> tags, String whoMade, String whenMade, Long featuredRank, Boolean isPersonalizable, Boolean personalizationIsRequired, Long personalizationCharCountMax, String personalizationInstructions, String state, Boolean isSupply, List<Long> productionPartnerIds, String type, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling updateListingDeprecated(Async)");
        }
        if (listingId == null) {
            throw new ApiException("Missing the required parameter 'listingId' when calling updateListingDeprecated(Async)");
        }
        return this.updateListingDeprecatedCall(shopId, listingId, imageIds, title, description, materials, shouldAutoRenew, shippingProfileId, shopSectionId, itemWeight, itemLength, itemWidth, itemHeight, itemWeightUnit, itemDimensionsUnit, isTaxable, taxonomyId, tags, whoMade, whenMade, featuredRank, isPersonalizable, personalizationIsRequired, personalizationCharCountMax, personalizationInstructions, state, isSupply, productionPartnerIds, type, _callback);
    }

    public ShopListing updateListingDeprecated(Long shopId, Long listingId, List<Long> imageIds, String title, String description, List<String> materials, Boolean shouldAutoRenew, Long shippingProfileId, Long shopSectionId, Float itemWeight, Float itemLength, Float itemWidth, Float itemHeight, String itemWeightUnit, String itemDimensionsUnit, Boolean isTaxable, Long taxonomyId, List<String> tags, String whoMade, String whenMade, Long featuredRank, Boolean isPersonalizable, Boolean personalizationIsRequired, Long personalizationCharCountMax, String personalizationInstructions, String state, Boolean isSupply, List<Long> productionPartnerIds, String type) throws ApiException {
        ApiResponse<ShopListing> localVarResp = this.updateListingDeprecatedWithHttpInfo(shopId, listingId, imageIds, title, description, materials, shouldAutoRenew, shippingProfileId, shopSectionId, itemWeight, itemLength, itemWidth, itemHeight, itemWeightUnit, itemDimensionsUnit, isTaxable, taxonomyId, tags, whoMade, whenMade, featuredRank, isPersonalizable, personalizationIsRequired, personalizationCharCountMax, personalizationInstructions, state, isSupply, productionPartnerIds, type);
        return localVarResp.getData();
    }

    public ApiResponse<ShopListing> updateListingDeprecatedWithHttpInfo(Long shopId, Long listingId, List<Long> imageIds, String title, String description, List<String> materials, Boolean shouldAutoRenew, Long shippingProfileId, Long shopSectionId, Float itemWeight, Float itemLength, Float itemWidth, Float itemHeight, String itemWeightUnit, String itemDimensionsUnit, Boolean isTaxable, Long taxonomyId, List<String> tags, String whoMade, String whenMade, Long featuredRank, Boolean isPersonalizable, Boolean personalizationIsRequired, Long personalizationCharCountMax, String personalizationInstructions, String state, Boolean isSupply, List<Long> productionPartnerIds, String type) throws ApiException {
        Call localVarCall = this.updateListingDeprecatedValidateBeforeCall(shopId, listingId, imageIds, title, description, materials, shouldAutoRenew, shippingProfileId, shopSectionId, itemWeight, itemLength, itemWidth, itemHeight, itemWeightUnit, itemDimensionsUnit, isTaxable, taxonomyId, tags, whoMade, whenMade, featuredRank, isPersonalizable, personalizationIsRequired, personalizationCharCountMax, personalizationInstructions, state, isSupply, productionPartnerIds, type, null);
        Type localVarReturnType = new TypeToken<ShopListing>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateListingDeprecatedAsync(Long shopId, Long listingId, List<Long> imageIds, String title, String description, List<String> materials, Boolean shouldAutoRenew, Long shippingProfileId, Long shopSectionId, Float itemWeight, Float itemLength, Float itemWidth, Float itemHeight, String itemWeightUnit, String itemDimensionsUnit, Boolean isTaxable, Long taxonomyId, List<String> tags, String whoMade, String whenMade, Long featuredRank, Boolean isPersonalizable, Boolean personalizationIsRequired, Long personalizationCharCountMax, String personalizationInstructions, String state, Boolean isSupply, List<Long> productionPartnerIds, String type, ApiCallback<ShopListing> _callback) throws ApiException {
        Call localVarCall = this.updateListingDeprecatedValidateBeforeCall(shopId, listingId, imageIds, title, description, materials, shouldAutoRenew, shippingProfileId, shopSectionId, itemWeight, itemLength, itemWidth, itemHeight, itemWeightUnit, itemDimensionsUnit, isTaxable, taxonomyId, tags, whoMade, whenMade, featuredRank, isPersonalizable, personalizationIsRequired, personalizationCharCountMax, personalizationInstructions, state, isSupply, productionPartnerIds, type, _callback);
        Type localVarReturnType = new TypeToken<ShopListing>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateListingPropertyCall(Long shopId, Long listingId, Long propertyId, List<Long> valueIds, List<String> values, Long scaleId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/listings/{listing_id}/properties/{property_id}".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString())).replace("{listing_id}", this.localVarApiClient.escapeString(listingId.toString())).replace("{property_id}", this.localVarApiClient.escapeString(propertyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (valueIds != null) {
            localVarFormParams.put("value_ids", valueIds);
        }
        if (values != null) {
            localVarFormParams.put("values", values);
        }
        if (scaleId != null) {
            localVarFormParams.put("scale_id", scaleId);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/x-www-form-urlencoded"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateListingPropertyValidateBeforeCall(Long shopId, Long listingId, Long propertyId, List<Long> valueIds, List<String> values, Long scaleId, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling updateListingProperty(Async)");
        }
        if (listingId == null) {
            throw new ApiException("Missing the required parameter 'listingId' when calling updateListingProperty(Async)");
        }
        if (propertyId == null) {
            throw new ApiException("Missing the required parameter 'propertyId' when calling updateListingProperty(Async)");
        }
        if (valueIds == null) {
            throw new ApiException("Missing the required parameter 'valueIds' when calling updateListingProperty(Async)");
        }
        if (values == null) {
            throw new ApiException("Missing the required parameter 'values' when calling updateListingProperty(Async)");
        }
        return this.updateListingPropertyCall(shopId, listingId, propertyId, valueIds, values, scaleId, _callback);
    }

    public ListingPropertyValue updateListingProperty(Long shopId, Long listingId, Long propertyId, List<Long> valueIds, List<String> values, Long scaleId) throws ApiException {
        ApiResponse<ListingPropertyValue> localVarResp = this.updateListingPropertyWithHttpInfo(shopId, listingId, propertyId, valueIds, values, scaleId);
        return localVarResp.getData();
    }

    public ApiResponse<ListingPropertyValue> updateListingPropertyWithHttpInfo(Long shopId, Long listingId, Long propertyId, List<Long> valueIds, List<String> values, Long scaleId) throws ApiException {
        Call localVarCall = this.updateListingPropertyValidateBeforeCall(shopId, listingId, propertyId, valueIds, values, scaleId, null);
        Type localVarReturnType = new TypeToken<ListingPropertyValue>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateListingPropertyAsync(Long shopId, Long listingId, Long propertyId, List<Long> valueIds, List<String> values, Long scaleId, ApiCallback<ListingPropertyValue> _callback) throws ApiException {
        Call localVarCall = this.updateListingPropertyValidateBeforeCall(shopId, listingId, propertyId, valueIds, values, scaleId, _callback);
        Type localVarReturnType = new TypeToken<ListingPropertyValue>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

