/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.Shop;
import org.openapitools.client.model.Shops;

public class ShopApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ShopApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ShopApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call findShopsCall(String shopName, Long limit, Long offset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (shopName != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("shop_name", shopName));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call findShopsValidateBeforeCall(String shopName, Long limit, Long offset, ApiCallback _callback) throws ApiException {
        if (shopName == null) {
            throw new ApiException("Missing the required parameter 'shopName' when calling findShops(Async)");
        }
        return this.findShopsCall(shopName, limit, offset, _callback);
    }

    public Shops findShops(String shopName, Long limit, Long offset) throws ApiException {
        ApiResponse<Shops> localVarResp = this.findShopsWithHttpInfo(shopName, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<Shops> findShopsWithHttpInfo(String shopName, Long limit, Long offset) throws ApiException {
        Call localVarCall = this.findShopsValidateBeforeCall(shopName, limit, offset, null);
        Type localVarReturnType = new TypeToken<Shops>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call findShopsAsync(String shopName, Long limit, Long offset, ApiCallback<Shops> _callback) throws ApiException {
        Call localVarCall = this.findShopsValidateBeforeCall(shopName, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<Shops>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getShopCall(Long shopId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getShopValidateBeforeCall(Long shopId, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling getShop(Async)");
        }
        return this.getShopCall(shopId, _callback);
    }

    public Shop getShop(Long shopId) throws ApiException {
        ApiResponse<Shop> localVarResp = this.getShopWithHttpInfo(shopId);
        return localVarResp.getData();
    }

    public ApiResponse<Shop> getShopWithHttpInfo(Long shopId) throws ApiException {
        Call localVarCall = this.getShopValidateBeforeCall(shopId, null);
        Type localVarReturnType = new TypeToken<Shop>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getShopAsync(Long shopId, ApiCallback<Shop> _callback) throws ApiException {
        Call localVarCall = this.getShopValidateBeforeCall(shopId, _callback);
        Type localVarReturnType = new TypeToken<Shop>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getShopByOwnerUserIdCall(Long userId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/users/{user_id}/shops".replace("{user_id}", this.localVarApiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getShopByOwnerUserIdValidateBeforeCall(Long userId, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling getShopByOwnerUserId(Async)");
        }
        return this.getShopByOwnerUserIdCall(userId, _callback);
    }

    public Shop getShopByOwnerUserId(Long userId) throws ApiException {
        ApiResponse<Shop> localVarResp = this.getShopByOwnerUserIdWithHttpInfo(userId);
        return localVarResp.getData();
    }

    public ApiResponse<Shop> getShopByOwnerUserIdWithHttpInfo(Long userId) throws ApiException {
        Call localVarCall = this.getShopByOwnerUserIdValidateBeforeCall(userId, null);
        Type localVarReturnType = new TypeToken<Shop>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getShopByOwnerUserIdAsync(Long userId, ApiCallback<Shop> _callback) throws ApiException {
        Call localVarCall = this.getShopByOwnerUserIdValidateBeforeCall(userId, _callback);
        Type localVarReturnType = new TypeToken<Shop>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateShopCall(Long shopId, String title, String announcement, String saleMessage, String digitalSaleMessage, String policyAdditional, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (title != null) {
            localVarFormParams.put("title", title);
        }
        if (announcement != null) {
            localVarFormParams.put("announcement", announcement);
        }
        if (saleMessage != null) {
            localVarFormParams.put("sale_message", saleMessage);
        }
        if (digitalSaleMessage != null) {
            localVarFormParams.put("digital_sale_message", digitalSaleMessage);
        }
        if (policyAdditional != null) {
            localVarFormParams.put("policy_additional", policyAdditional);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/x-www-form-urlencoded"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateShopValidateBeforeCall(Long shopId, String title, String announcement, String saleMessage, String digitalSaleMessage, String policyAdditional, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling updateShop(Async)");
        }
        return this.updateShopCall(shopId, title, announcement, saleMessage, digitalSaleMessage, policyAdditional, _callback);
    }

    public Shop updateShop(Long shopId, String title, String announcement, String saleMessage, String digitalSaleMessage, String policyAdditional) throws ApiException {
        ApiResponse<Shop> localVarResp = this.updateShopWithHttpInfo(shopId, title, announcement, saleMessage, digitalSaleMessage, policyAdditional);
        return localVarResp.getData();
    }

    public ApiResponse<Shop> updateShopWithHttpInfo(Long shopId, String title, String announcement, String saleMessage, String digitalSaleMessage, String policyAdditional) throws ApiException {
        Call localVarCall = this.updateShopValidateBeforeCall(shopId, title, announcement, saleMessage, digitalSaleMessage, policyAdditional, null);
        Type localVarReturnType = new TypeToken<Shop>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateShopAsync(Long shopId, String title, String announcement, String saleMessage, String digitalSaleMessage, String policyAdditional, ApiCallback<Shop> _callback) throws ApiException {
        Call localVarCall = this.updateShopValidateBeforeCall(shopId, title, announcement, saleMessage, digitalSaleMessage, policyAdditional, _callback);
        Type localVarReturnType = new TypeToken<Shop>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

