/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.ListingReviews;
import org.openapitools.client.model.TransactionReviews;

public class ReviewApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ReviewApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ReviewApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call getReviewsByListingCall(Long listingId, Long limit, Long offset, Long minCreated, Long maxCreated, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/listings/{listing_id}/reviews".replace("{listing_id}", this.localVarApiClient.escapeString(listingId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (minCreated != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("min_created", minCreated));
        }
        if (maxCreated != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_created", maxCreated));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getReviewsByListingValidateBeforeCall(Long listingId, Long limit, Long offset, Long minCreated, Long maxCreated, ApiCallback _callback) throws ApiException {
        if (listingId == null) {
            throw new ApiException("Missing the required parameter 'listingId' when calling getReviewsByListing(Async)");
        }
        return this.getReviewsByListingCall(listingId, limit, offset, minCreated, maxCreated, _callback);
    }

    public ListingReviews getReviewsByListing(Long listingId, Long limit, Long offset, Long minCreated, Long maxCreated) throws ApiException {
        ApiResponse<ListingReviews> localVarResp = this.getReviewsByListingWithHttpInfo(listingId, limit, offset, minCreated, maxCreated);
        return localVarResp.getData();
    }

    public ApiResponse<ListingReviews> getReviewsByListingWithHttpInfo(Long listingId, Long limit, Long offset, Long minCreated, Long maxCreated) throws ApiException {
        Call localVarCall = this.getReviewsByListingValidateBeforeCall(listingId, limit, offset, minCreated, maxCreated, null);
        Type localVarReturnType = new TypeToken<ListingReviews>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getReviewsByListingAsync(Long listingId, Long limit, Long offset, Long minCreated, Long maxCreated, ApiCallback<ListingReviews> _callback) throws ApiException {
        Call localVarCall = this.getReviewsByListingValidateBeforeCall(listingId, limit, offset, minCreated, maxCreated, _callback);
        Type localVarReturnType = new TypeToken<ListingReviews>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getReviewsByShopCall(Long shopId, Long limit, Long offset, Long minCreated, Long maxCreated, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/application/shops/{shop_id}/reviews".replace("{shop_id}", this.localVarApiClient.escapeString(shopId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (minCreated != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("min_created", minCreated));
        }
        if (maxCreated != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_created", maxCreated));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getReviewsByShopValidateBeforeCall(Long shopId, Long limit, Long offset, Long minCreated, Long maxCreated, ApiCallback _callback) throws ApiException {
        if (shopId == null) {
            throw new ApiException("Missing the required parameter 'shopId' when calling getReviewsByShop(Async)");
        }
        return this.getReviewsByShopCall(shopId, limit, offset, minCreated, maxCreated, _callback);
    }

    public TransactionReviews getReviewsByShop(Long shopId, Long limit, Long offset, Long minCreated, Long maxCreated) throws ApiException {
        ApiResponse<TransactionReviews> localVarResp = this.getReviewsByShopWithHttpInfo(shopId, limit, offset, minCreated, maxCreated);
        return localVarResp.getData();
    }

    public ApiResponse<TransactionReviews> getReviewsByShopWithHttpInfo(Long shopId, Long limit, Long offset, Long minCreated, Long maxCreated) throws ApiException {
        Call localVarCall = this.getReviewsByShopValidateBeforeCall(shopId, limit, offset, minCreated, maxCreated, null);
        Type localVarReturnType = new TypeToken<TransactionReviews>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getReviewsByShopAsync(Long shopId, Long limit, Long offset, Long minCreated, Long maxCreated, ApiCallback<TransactionReviews> _callback) throws ApiException {
        Call localVarCall = this.getReviewsByShopValidateBeforeCall(shopId, limit, offset, minCreated, maxCreated, _callback);
        Type localVarReturnType = new TypeToken<TransactionReviews>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

